/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.define.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.parsers.AbstractArtifactExtractor;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;

public class WholeWordDocumentExtractor
extends AbstractArtifactExtractor {
    public String getDescription() {
        return "Extract all the content of each Word XML document as one artifact.";
    }

    @Override
    protected XResultData extractFromSource(OrcsApi orcsApi, XResultData results, URI source, RoughArtifactCollector collector) throws Exception {
        if (source == null) {
            throw new OseeArgumentException("importFile can not be null", new Object[0]);
        }
        RoughArtifact roughArtifact = new RoughArtifact(orcsApi, results, RoughArtifactKind.PRIMARY, Lib.removeExtension((String)new File(source).getName()));
        collector.addRoughArtifact(roughArtifact);
        roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, source);
        return results;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }
        };
    }

    public String getName() {
        return "Whole Word Document";
    }
}

