/*********************************************************************
 * Copyright (c) 2012 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.orcs.db.internal.loader;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.LoadContext;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.db.internal.sql.SqlContextImpl;

/**
 * @author Roberto E. Escobar
 */
public class LoadSqlContext extends SqlContextImpl implements LoadContext, HasBranchId {

   private final BranchId branch;
   private final List<BranchCategoryToken> branchCategories;

   public LoadSqlContext(OrcsSession session, Options options, BranchId branch, List<BranchCategoryToken> branchCategories) {
      super(session, options);
      this.branch = branch;
      this.branchCategories = branchCategories;
   }

   public LoadSqlContext(OrcsSession session, Options options, BranchId branch) {
      this(session, options, branch, new ArrayList<BranchCategoryToken>());
   }

   @Override
   public BranchId getBranch() {
      return branch;
   }

   public List<BranchCategoryToken> getBranchCategories() {
      return branchCategories;
   }
}
