-- OSEE_OAUTH_CLIENT_CREDENTIAL
CREATE TABLE OSEE_OAUTH_CLIENT_CREDENTIAL (
	CLIENT_ID ${db.bigint} NOT NULL,
	APPLICATION_ID ${db.bigint} NOT NULL,
	SUBJECT_ID ${db.bigint} NOT NULL,
	CLIENT_CERT VARCHAR(255),
	CLIENT_SECRET VARCHAR(255),
	CLIENT_KEY VARCHAR(255) NOT NULL,
	CONSTRAINT OSEE_OAUTH_CLIENT_CRED__U_PK PRIMARY KEY(CLIENT_ID)
);

CREATE INDEX OSEE_OAUTH_CLIENT_CRED__CK_IDX ON OSEE_OAUTH_CLIENT_CREDENTIAL(CLIENT_KEY);
CREATE INDEX OSEE_OAUTH_CLIENT_CRED__AI_IDX ON OSEE_OAUTH_CLIENT_CREDENTIAL(APPLICATION_ID);

-- OSEE_OAUTH_AUTHORIZATION
CREATE TABLE OSEE_OAUTH_AUTHORIZATION (
	AUDIENCE VARCHAR(512),
	APPROVED_SCOPES VARCHAR(2000),
	REDIRECT_URI VARCHAR(512),
	EXPIRES_IN ${db.bigint} NOT NULL,
	ISSUED_AT ${db.bigint} NOT NULL,
	VERIFIER VARCHAR(512),
	CLIENT_ID ${db.bigint} NOT NULL,
	ID ${db.bigint} NOT NULL,
	SUBJECT_ID ${db.bigint} NOT NULL,
	CODE VARCHAR(512) NOT NULL,
	CONSTRAINT OSEE_OAUTH_AUTH__ID_PK PRIMARY KEY(ID),
	CONSTRAINT OSEE_OAUTH_AUTH__CI_FK FOREIGN KEY(CLIENT_ID) REFERENCES OSEE_OAUTH_CLIENT_CREDENTIAL(CLIENT_ID) ON DELETE CASCADE
);
	
CREATE INDEX OSEE_OAUTH_AUTH__C_IDX ON OSEE_OAUTH_AUTHORIZATION(CODE);

-- OSEE_OAUTH_TOKEN
CREATE TABLE OSEE_OAUTH_TOKEN (
	AUDIENCE VARCHAR(512),
	EXPIRES_IN ${db.bigint} NOT NULL,
	ISSUED_AT ${db.bigint} NOT NULL,
	TOKEN_KEY VARCHAR(512) NOT NULL,
	PARENT_TOKEN_ID ${db.bigint} NOT NULL,
	CLIENT_ID ${db.bigint} NOT NULL,
	GRANT_TYPE VARCHAR(255) NOT NULL,
	ID ${db.bigint} NOT NULL,
	SUBJECT_ID ${db.bigint} NOT NULL,
	TYPE_ID SMALLINT NOT NULL,
	TOKEN_TYPE VARCHAR(255) NOT NULL,
	CONSTRAINT OSEE_OAUTH_TOKEN__ID_PK PRIMARY KEY(ID),
	CONSTRAINT OSEE_OAUTH_TOKEN__CI_FK FOREIGN KEY(CLIENT_ID) REFERENCES OSEE_OAUTH_CLIENT_CREDENTIAL(CLIENT_ID) ON DELETE CASCADE
);

CREATE INDEX OSEE_OAUTH_TOKEN__TK_IDX ON OSEE_OAUTH_TOKEN(TOKEN_KEY);

