/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.attribute.BinaryAttribute;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public final class JavaObjectAttribute
extends BinaryAttribute<Object> {
    public Object getValue() {
        return this.getObjectFromBytes(this.getAttributeDataProvider().getValueAsBytes());
    }

    private Object getObjectFromBytes(ByteBuffer buffer) {
        Object obj = null;
        InputStream inputStream = null;
        ObjectInputStream objectStream = null;
        try {
            try {
                inputStream = Lib.byteBufferToInputStream((ByteBuffer)buffer);
                if (inputStream != null) {
                    objectStream = new ObjectInputStream(inputStream);
                    obj = objectStream.readObject();
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                try {
                    if (inputStream != null) {
                        inputStream.reset();
                    }
                }
                catch (IOException ex2) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex2);
                }
                try {
                    if (objectStream != null) {
                        objectStream.close();
                    }
                }
                catch (IOException ex3) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex3);
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.reset();
                }
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            try {
                if (objectStream != null) {
                    objectStream.close();
                }
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return obj;
    }

    @Override
    protected boolean subClassSetValue(Object value) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(value);
            objectStream.flush();
            objectStream.close();
            this.getAttributeDataProvider().setValue(ByteBuffer.wrap(byteStream.toByteArray()));
            this.getAttributeDataProvider().setDisplayableString(value.getClass().getName());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return true;
    }

    @Override
    public Object convertStringToValue(String value) {
        return this.getObjectFromBytes(ByteBuffer.wrap(value.getBytes()));
    }
}

