/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class NewTaskData {
    @JsonSerialize(using=ToStringSerializer.class)
    Long teamWfId;
    List<JaxAtsTask> newTasks = new ArrayList<JaxAtsTask>();
    Boolean fixTitles = false;
    TransactionToken transaction = TransactionToken.SENTINEL;
    AtsWorkDefinitionToken taskWorkDef = AtsWorkDefinitionToken.SENTINEL;

    public Long getTeamWfId() {
        return this.teamWfId;
    }

    public void setTeamWfId(Long teamWfId) {
        this.teamWfId = teamWfId;
    }

    public List<JaxAtsTask> getTasks() {
        return this.newTasks;
    }

    public void add(JaxAtsTask jTask) {
        this.newTasks.add(jTask);
    }

    public void setNewTasks(List<JaxAtsTask> newTasks) {
        this.newTasks = newTasks;
    }

    public String toString() {
        return "NewTaskData [teamId=" + this.teamWfId + ", tasks=" + this.newTasks + "]";
    }

    public boolean isEmpty() {
        return this.newTasks == null || this.newTasks.isEmpty();
    }

    public Boolean getFixTitles() {
        return this.fixTitles;
    }

    public Boolean isFixTitles() {
        return this.fixTitles;
    }

    public void setFixTitles(Boolean fixTitles) {
        this.fixTitles = fixTitles;
    }

    public static NewTaskData create(NewTaskSet newTaskSet, IAtsTeamWorkflow teamWf) {
        NewTaskData ntd = new NewTaskData();
        newTaskSet.add(ntd);
        if (teamWf != null) {
            ntd.setTeamWfId(teamWf.getId());
        }
        return ntd;
    }

    public static NewTaskData create(IAtsTeamWorkflow teamWf, List<String> titles, List<AtsUser> assignees, Date createdDate, AtsUser createdBy, String relatedToState, String taskWorkDef, Map<AttributeTypeToken, List<Object>> attributes) {
        NewTaskData newTaskData = new NewTaskData();
        newTaskData.setTeamWfId(teamWf.getId());
        if (createdDate == null) {
            createdDate = new Date();
        }
        for (String title : titles) {
            JaxAtsTask task = new JaxAtsTask();
            task.setName(title);
            if (assignees != null) {
                for (AtsUser atsUser : assignees) {
                    task.addAssigneeUserIds(atsUser.getUserId());
                }
            } else {
                task.addAssigneeUserIds(AtsCoreUsers.UNASSIGNED_USER.getUserId());
            }
            if (Strings.isValid((String)relatedToState)) {
                task.setRelatedToState(relatedToState);
            }
            task.setCreatedByUserId(createdBy.getUserId());
            task.setCreatedDate(createdDate);
            if (Strings.isValid((String)taskWorkDef)) {
                task.setWorkDef(taskWorkDef);
            }
            newTaskData.getTasks().add(task);
            if (attributes == null) continue;
            for (Map.Entry entry : attributes.entrySet()) {
                task.addAttributes((AttributeTypeToken)entry.getKey(), (List)entry.getValue());
            }
        }
        return newTaskData;
    }

    public TransactionToken getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionToken transaction) {
        this.transaction = transaction;
    }

    public AtsWorkDefinitionToken getTaskWorkDef() {
        return this.taskWorkDef;
    }

    public void setTaskWorkDef(AtsWorkDefinitionToken taskWorkDef) {
        this.taskWorkDef = taskWorkDef;
    }
}

