/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.review.ReviewRoleType;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.model.AbstractWorkDefItem;
import org.eclipse.osee.ats.api.workdef.model.HeaderDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefOption;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;

public class WorkDefinition
extends AbstractWorkDefItem
implements IAtsWorkDefinition {
    private final List<IAtsStateDefinition> states = new ArrayList<IAtsStateDefinition>(5);
    private final CountingMap<String> labelCount = new CountingMap();
    private final List<CreateTasksDefinition> createTasksDefs = new ArrayList<CreateTasksDefinition>();
    private final Map<ReviewRole, Integer> reviewRoleMap = new ConcurrentHashMap<ReviewRole, Integer>();
    private final Map<ReviewRoleType, Integer> reviewRoleTypeMap = new ConcurrentHashMap<ReviewRoleType, Integer>();
    private IAtsStateDefinition startState;
    private HeaderDefinition headerDef;
    private boolean showStateMetrics = false;
    private List<XViewerColumn> reviewDefectColumns = new ArrayList<XViewerColumn>();
    private XResultData results = new XResultData();
    private final List<WorkDefOption> options = new ArrayList<WorkDefOption>();

    public WorkDefinition(Long id, String name) {
        this(id, name, ArtifactTypeToken.SENTINEL);
    }

    public WorkDefinition(Long id, String name, ArtifactTypeToken artType) {
        super(id, name, artType);
        if (artType == null) {
            this.results.errorf("Artifact Type can not be null Work Def [%s]", new Object[]{name});
        }
        this.headerDef = new HeaderDefinition(this);
    }

    @Override
    public IAtsStateDefinition getStateByName(String name) {
        for (IAtsStateDefinition state : this.states) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    @Override
    public IAtsStateDefinition getStartState() {
        return this.startState;
    }

    public void setStartState(IAtsStateDefinition startState) {
        this.startState = startState;
    }

    public IAtsStateDefinition addState(IAtsStateDefinition state) {
        this.states.add(state);
        return state;
    }

    @Override
    public List<IAtsStateDefinition> getStates() {
        return this.states;
    }

    @Override
    public HeaderDefinition getHeaderDef() {
        return this.headerDef;
    }

    @Override
    public boolean hasHeaderDefinitionItems() {
        return this.headerDef != null && !this.headerDef.getLayoutItems().isEmpty();
    }

    @Override
    public HeaderDefinition getDefaultHeaderDef() {
        HeaderDefinition defaultHeaderDef = new HeaderDefinition(this);
        defaultHeaderDef.setShowMetricsHeader(true);
        defaultHeaderDef.setShowWorkPackageHeader(true);
        return defaultHeaderDef;
    }

    @Override
    public void setHeaderDefinition(HeaderDefinition headerDef) {
        this.headerDef = headerDef;
    }

    @Override
    public boolean isShowStateMetrics() {
        return this.showStateMetrics;
    }

    @Override
    public void setShowStateMetrics(boolean showStateMetrics) {
        this.showStateMetrics = showStateMetrics;
    }

    public void addTaskSetDef(CreateTasksDefinition createTasksDef) {
        this.createTasksDefs.add(createTasksDef);
    }

    @Override
    public List<CreateTasksDefinition> getCreateTasksDefs() {
        return this.createTasksDefs;
    }

    public CountingMap<String> getLabelCount() {
        return this.labelCount;
    }

    @Override
    public List<XViewerColumn> getReviewDefectColumns() {
        return this.reviewDefectColumns;
    }

    @Override
    public void setReviewDefectColumns(List<XViewerColumn> reviewDefectColumns) {
        this.reviewDefectColumns = reviewDefectColumns;
    }

    public void addReviewRole(ReviewRole role, int minimum) {
        this.reviewRoleMap.put(role, minimum);
    }

    @Override
    public Set<ReviewRole> getReviewRoles() {
        return this.reviewRoleMap.keySet();
    }

    public void andReviewRoleTypeMinimum(ReviewRoleType reviewRoleType, int minimum) {
        this.reviewRoleTypeMap.put(reviewRoleType, minimum);
    }

    @Override
    public Map<ReviewRoleType, Integer> getReviewRoleTypeMap() {
        return this.reviewRoleTypeMap;
    }

    @Override
    public Map<ReviewRole, Integer> getReviewRoleMap() {
        return this.reviewRoleMap;
    }

    @Override
    public ReviewRole fromName(String name) {
        for (ReviewRole role : this.reviewRoleMap.keySet()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        ReviewRole newRole = new ReviewRole(Long.valueOf(this.reviewRoleMap.size()), name, ReviewRoleType.Reviewer);
        this.reviewRoleMap.put(newRole, 0);
        return newRole;
    }

    @Override
    public XResultData getResults() {
        return this.results;
    }

    public void setResults(XResultData results) {
        this.results = results;
    }

    public List<WorkDefOption> getOptions() {
        return this.options;
    }

    @Override
    public boolean hasOption(WorkDefOption workDefOption) {
        return this.options.contains((Object)workDefOption);
    }
}

