/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class ArtifactOperations {
    private final Artifact artifact;
    private List<String> partitions;
    private String qualificationMethod;
    private String qualificationFacility;

    public ArtifactOperations(Artifact artifact) {
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getParagraphNumber() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
    }

    public List<String> getPartitions() {
        if (this.partitions == null) {
            this.partitions = new ArrayList<String>();
            try {
                this.partitions.addAll(this.artifact.getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.Partition));
                if (this.partitions.isEmpty()) {
                    this.partitions.add("unspecified");
                }
                Collections.sort(this.partitions);
            }
            catch (OseeCoreException ex) {
                OseeLog.logf(Activator.class, (Level)Level.WARNING, (Throwable)ex, (String)"Error obtaining partition info for [%s]", (Object[])new Object[]{this.getName()});
                this.partitions.add("Error");
            }
        }
        return this.partitions;
    }

    public String getQualificationMethod() {
        if (this.qualificationMethod == null) {
            this.processQualificationMethod();
        }
        return this.qualificationMethod;
    }

    public String getQualificationFacility() {
        if (this.qualificationFacility == null) {
            this.processQualificationMethod();
        }
        return this.qualificationFacility;
    }

    private void processQualificationMethod() {
        StringBuilder qualMethodBuilder = new StringBuilder();
        StringBuilder qualFacilityBuilder = new StringBuilder();
        try {
            ArrayList methods = new ArrayList(this.artifact.getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.QualificationMethod));
            Collections.sort(methods);
            int index = 0;
            while (index < methods.size()) {
                String qualMethod = (String)methods.get(index);
                QualificationMethod method = QualificationMethod.getMethodFromAttribute(qualMethod);
                qualMethodBuilder.append(method.getShortName());
                qualFacilityBuilder.append((Object)method.getFacility());
                if (index + 1 < methods.size()) {
                    qualMethodBuilder.append(", ");
                    qualFacilityBuilder.append(", ");
                }
                ++index;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.logf(Activator.class, (Level)Level.WARNING, (Throwable)ex, (String)"Error obtaining qualification info [%s]", (Object[])new Object[]{this.getName()});
        }
        this.qualificationMethod = qualMethodBuilder.toString();
        this.qualificationFacility = qualFacilityBuilder.toString();
    }

    public static HashCollectionSet<String, Artifact> sortByPartition(Collection<Artifact> source) {
        HashCollectionSet partitionMap = new HashCollectionSet(TreeSet::new);
        for (Artifact artifact : source) {
            ArtifactOperations operator = new ArtifactOperations(artifact);
            List<String> partitions = operator.getPartitions();
            for (String key : partitions) {
                partitionMap.put((Object)key, (Object)artifact);
            }
        }
        return partitionMap;
    }

    public static List<Artifact> sortByParagraphNumbers(Collection<Artifact> source) {
        ArrayList<Artifact> toReturn = new ArrayList<Artifact>(source);
        Collections.sort(toReturn, new Comparator<Artifact>(){

            @Override
            public int compare(Artifact art1, Artifact art2) {
                try {
                    int size;
                    int toReturn = 0;
                    String paragraph1 = new ArtifactOperations(art1).getParagraphNumber();
                    String paragraph2 = new ArtifactOperations(art2).getParagraphNumber();
                    Integer[] set1 = ArtifactOperations.getParagraphIndices(paragraph1);
                    Integer[] set2 = ArtifactOperations.getParagraphIndices(paragraph2);
                    int length1 = set1.length;
                    int length2 = set2.length;
                    int n = size = length1 < length2 ? length1 : length2;
                    if (size == 0 && length1 != length2) {
                        toReturn = length1 < length2 ? -1 : 1;
                    } else {
                        int index = 0;
                        while (index < size) {
                            toReturn = set1[index].compareTo(set2[index]);
                            if (toReturn != 0) break;
                            ++index;
                        }
                    }
                    return toReturn;
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    return 1;
                }
            }
        });
        return toReturn;
    }

    private static Integer[] getParagraphIndices(String paragraph) {
        ArrayList<Integer> paragraphs = new ArrayList<Integer>();
        if (Strings.isValid((String)paragraph)) {
            String[] values = paragraph.split("\\.");
            int index = 0;
            while (index < values.length) {
                try {
                    paragraphs.add(Integer.valueOf(values[index]));
                }
                catch (Exception exception) {}
                ++index;
            }
        }
        return paragraphs.toArray(new Integer[paragraphs.size()]);
    }

    public String getPriority() {
        String toReturn = null;
        try {
            toReturn = (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Category, (Object)"");
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            toReturn = "";
        }
        return toReturn;
    }

    static enum QualificationFacility {
        UNKNOWN,
        STE,
        AIL,
        SEE;

    }

    static enum QualificationMethod {
        Test("Test", "T", QualificationFacility.STE),
        Demo("Demonstration", "D", QualificationFacility.AIL),
        Inspection("Inspection", "I", QualificationFacility.SEE),
        SpecialQualification("Special Qualification", "S", QualificationFacility.AIL),
        Analysis("Analysis", "A", QualificationFacility.SEE),
        Unspecified("Unspecified", "U", QualificationFacility.UNKNOWN);

        String attributeString;
        String shortName;
        QualificationFacility facility;

        private QualificationMethod(String attributeString, String shortName, QualificationFacility facility) {
            this.attributeString = attributeString;
            this.shortName = shortName;
            this.facility = facility;
        }

        public String getAttributeString() {
            return this.attributeString;
        }

        public String getShortName() {
            return this.shortName;
        }

        public QualificationFacility getFacility() {
            return this.facility;
        }

        public static QualificationMethod getMethodFromAttribute(String attribute) {
            QualificationMethod toReturn = Unspecified;
            QualificationMethod[] qualificationMethodArray = QualificationMethod.values();
            int n = qualificationMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                QualificationMethod method = qualificationMethodArray[n2];
                if (method.getAttributeString().equalsIgnoreCase(attribute)) {
                    toReturn = method;
                    break;
                }
                ++n2;
            }
            return toReturn;
        }
    }
}

