/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.ICustomizable;
import org.eclipse.osee.define.ide.traceability.report.ISimpleTable;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.IVariantData;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public class TraceabilityTable {
    private static final Pattern TABLE_START_PATTERN = Pattern.compile("(<Table.*?>)");
    private static final Pattern COLUMN_PATTERN = Pattern.compile("(\\s*<Column.*?/>\\s*)");
    private static final Pattern STYLE_PATTERN = Pattern.compile("<Styles>.*</Styles>\\s*", 32);
    private CharSequence result;
    private final StringWriter stringWriter;
    private final ExcelXmlWriter sheetWriter;
    private final ISimpleTable[] styles;

    public TraceabilityTable(StringWriter stringWriter, ExcelXmlWriter sheetWriter, ISimpleTable ... styles) {
        this.stringWriter = stringWriter;
        this.sheetWriter = sheetWriter;
        this.styles = styles;
        this.result = null;
    }

    public void setOptions(IVariantData data) {
        ISimpleTable[] iSimpleTableArray = this.styles;
        int n = this.styles.length;
        int n2 = 0;
        while (n2 < n) {
            ISimpleTable style = iSimpleTableArray[n2];
            if (style != null && style instanceof ICustomizable) {
                ((ICustomizable)((Object)style)).setOptions(data);
            }
            ++n2;
        }
    }

    public void run(IProgressMonitor monitor) throws Exception {
        ISimpleTable[] iSimpleTableArray = this.styles;
        int n = this.styles.length;
        int n2 = 0;
        while (n2 < n) {
            ISimpleTable style = iSimpleTableArray[n2];
            style.initializeSheet(this.sheetWriter);
            this.sheetWriter.startSheet(style.getWorksheetName(), style.getColumnCount());
            style.generateBody(this.sheetWriter);
            this.sheetWriter.endSheet();
            ++n2;
        }
        this.sheetWriter.endWorkbook();
        this.postProcess();
    }

    private void postProcess() throws Exception {
        String source = this.stringWriter.toString();
        ChangeSet changeSet = new ChangeSet((CharSequence)source);
        Matcher styleMatcher = STYLE_PATTERN.matcher(source);
        Matcher tableMatcher = TABLE_START_PATTERN.matcher(source);
        Matcher columnMatcher = COLUMN_PATTERN.matcher(source);
        if (styleMatcher.find()) {
            changeSet.replace(styleMatcher.start(), styleMatcher.end(), this.styles[0].getHeaderStyles());
        }
        ISimpleTable[] iSimpleTableArray = this.styles;
        int n = this.styles.length;
        int n2 = 0;
        while (n2 < n) {
            ISimpleTable style = iSimpleTableArray[n2];
            if (tableMatcher.find()) {
                changeSet.insertBefore(tableMatcher.end(), style.getHeader());
            }
            ++n2;
        }
        while (columnMatcher.find()) {
            changeSet.delete(columnMatcher.start(), columnMatcher.end());
        }
        this.result = changeSet.applyChangesToSelf();
    }

    public String toString() {
        return this.result.toString();
    }
}

