/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.junit.ui.JUnitUIPreferencesConstants;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class JUnitPlugin
extends AbstractUIPlugin {
    private static JUnitPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.junit";
    public static final String ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS = "org.eclipse.jdt.junit.junitLaunchConfigs";
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    private List<String> fJUnitLaunchConfigTypeIDs;
    private BundleContext fBundleContext;
    private static boolean fIsStopped = false;

    public JUnitPlugin() {
        fgPlugin = this;
    }

    public static JUnitPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = PlatformUI.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(Throwable e) {
        JUnitPlugin.log((IStatus)new Status(4, JUnitPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        JUnitPlugin.getDefault().getLog().log(status);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        return JUnitPlugin.createImageDescriptor(JUnitPlugin.getDefault().getBundle(), path, true);
    }

    public static Image createImage(String path) {
        return JUnitPlugin.getImageDescriptor(path).createImage();
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        JUnitPlugin.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = JUnitPlugin.createImageDescriptor("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = JUnitPlugin.createImageDescriptor("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createImageDescriptor(String pathPrefix, String imageName, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(pathPrefix).append(imageName);
        return JUnitPlugin.createImageDescriptor(JUnitPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        this.setCodeassistFavoriteStaticMembers();
    }

    private void setCodeassistFavoriteStaticMembers() {
        LinkedHashSet<String> favoritesToAdd = new LinkedHashSet<String>();
        favoritesToAdd.add("org.junit.Assert.*");
        favoritesToAdd.add("org.junit.Assume.*");
        favoritesToAdd.add("org.junit.jupiter.api.Assertions.*");
        favoritesToAdd.add("org.junit.jupiter.api.Assumptions.*");
        favoritesToAdd.add("org.junit.jupiter.api.DynamicContainer.*");
        favoritesToAdd.add("org.junit.jupiter.api.DynamicTest.*");
        LinkedHashSet<String> defaultFavorites = new LinkedHashSet<String>();
        String defaultPreferenceValue = PreferenceConstants.getPreferenceStore().getDefaultString("content_assist_favorite_static_members");
        if (defaultPreferenceValue != null && defaultPreferenceValue.length() > 0) {
            defaultFavorites.addAll(Arrays.asList(defaultPreferenceValue.split(";")));
        }
        defaultFavorites.addAll(favoritesToAdd);
        String newDefaultPreferenceValue = defaultFavorites.stream().collect(Collectors.joining(";"));
        PreferenceConstants.getPreferenceStore().setDefault("content_assist_favorite_static_members", newDefaultPreferenceValue);
        if (JUnitUIPreferencesConstants.isCodeassistFavoriteStaticMembersMigrated()) {
            return;
        }
        LinkedHashSet<String> currentFavorites = new LinkedHashSet<String>();
        String currentPreferenceValue = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (currentPreferenceValue != null && currentPreferenceValue.length() > 0) {
            currentFavorites.addAll(Arrays.asList(currentPreferenceValue.split(";")));
        }
        favoritesToAdd.removeAll(currentFavorites);
        if (!favoritesToAdd.isEmpty()) {
            String newPreferenceValue = String.valueOf(currentPreferenceValue) + ";" + favoritesToAdd.stream().collect(Collectors.joining(";"));
            PreferenceConstants.getPreferenceStore().setValue("content_assist_favorite_static_members", newPreferenceValue);
        }
        JUnitUIPreferencesConstants.setCodeassistFavoriteStaticMembersMigrated(true);
    }

    public void stop(BundleContext context) throws Exception {
        fIsStopped = true;
        super.stop(context);
        this.fBundleContext = null;
    }

    public Object getService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.fBundleContext.getService(reference);
    }

    private void loadLaunchConfigTypeIDs() {
        IConfigurationElement[] configs;
        this.fJUnitLaunchConfigTypeIDs = new ArrayList<String>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = configs = extensionPoint.getConfigurationElements();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String configTypeID = config.getAttribute("configTypeID");
            this.fJUnitLaunchConfigTypeIDs.add(configTypeID);
            ++n2;
        }
    }

    public List<String> getJUnitLaunchConfigTypeIDs() {
        if (this.fJUnitLaunchConfigTypeIDs == null) {
            this.loadLaunchConfigTypeIDs();
        }
        return this.fJUnitLaunchConfigTypeIDs;
    }

    public Bundle getBundle(String bundleName) {
        Bundle[] bundles = this.getBundles(bundleName, null);
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Bundle[] getBundles(String bundleName, String version) {
        Bundle[] bundles = Platform.getBundles((String)bundleName, (String)version);
        if (bundles != null) {
            return bundles;
        }
        ServiceReference serviceRef = this.fBundleContext.getServiceReference(PackageAdmin.class);
        PackageAdmin admin = (PackageAdmin)this.fBundleContext.getService(serviceRef);
        bundles = admin.getBundles(bundleName, version);
        if (bundles != null && bundles.length > 0) {
            return bundles;
        }
        return null;
    }

    public static boolean isStopped() {
        return fIsStopped;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static void asyncShowTestRunnerViewPart() {
        JUnitPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                JUnitPlugin.showTestRunnerViewPartInActivePage();
            }
        });
    }

    public static TestRunnerViewPart showTestRunnerViewPartInActivePage() {
        IWorkbenchPage page;
        block4: {
            try {
                page = JUnitPlugin.getActivePage();
                if (page != null) break block4;
                return null;
            }
            catch (PartInitException pie) {
                JUnitPlugin.log(pie);
                return null;
            }
        }
        TestRunnerViewPart view = (TestRunnerViewPart)page.findView("org.eclipse.jdt.junit.ResultView");
        if (view == null) {
            return (TestRunnerViewPart)page.showView("org.eclipse.jdt.junit.ResultView", null, 2);
        }
        return view;
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

