/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.OrderedLongHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class RangeVariable
implements Cloneable {
    static final RangeVariable[] emptyArray = new RangeVariable[0];
    public static final int TABLE_RANGE = 1;
    public static final int TRANSITION_RANGE = 2;
    public static final int PARAMETER_RANGE = 3;
    public static final int VARIALBE_RANGE = 4;
    Table rangeTable;
    final HsqlNameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private HsqlNameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    private Object[] emptyData;
    boolean[] columnsInGroupBy;
    boolean hasKeyedColumnInGroupBy;
    boolean[] usedColumns;
    boolean[] updatedColumns;
    RangeVariableConditions[] joinConditions;
    RangeVariableConditions[] whereConditions;
    int subRangeCount;
    Expression joinCondition;
    boolean isLateral;
    boolean isLeftJoin;
    boolean isRightJoin;
    boolean isBoundary;
    boolean hasLateral;
    boolean hasLeftJoin;
    boolean hasRightJoin;
    int level;
    int indexDistinctCount;
    int rangePositionInJoin;
    int rangePosition;
    int parsePosition;
    HashMappedList variables;
    int rangeType;
    boolean isGenerated;

    public RangeVariable(HashMappedList hashMappedList, HsqlNameManager.SimpleName simpleName, boolean bl, int n) {
        this.variables = hashMappedList;
        this.rangeType = n;
        this.rangeTable = null;
        this.tableAlias = simpleName;
        this.emptyData = null;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "RangeVariable");
            }
        }
    }

    public RangeVariable(Table table, HsqlNameManager.SimpleName simpleName, OrderedHashSet orderedHashSet, HsqlNameManager.SimpleName[] simpleNameArray, ParserDQL.CompileContext compileContext) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = simpleName;
        this.columnAliases = orderedHashSet;
        this.columnAliasNames = simpleNameArray;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        compileContext.registerRangeVariable(this);
        if (this.rangeTable.getColumnCount() != 0) {
            this.setRangeTableVariables();
        }
    }

    public RangeVariable(Table table, int n) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = n;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public void setRangeTableVariables() {
        if (this.columnAliasNames != null && this.rangeTable.getColumnCount() != this.columnAliasNames.length) {
            throw Error.error(5593);
        }
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public RangeVariable duplicate() {
        RangeVariable rangeVariable = null;
        try {
            rangeVariable = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        rangeVariable.resetConditions();
        return rangeVariable;
    }

    public void setJoinType(boolean bl, boolean bl2) {
        this.isLeftJoin = bl;
        this.isRightJoin = bl2;
        if (this.isRightJoin) {
            this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        }
    }

    public void addNamedJoinColumns(OrderedHashSet orderedHashSet) {
        this.namedJoinColumns = orderedHashSet;
    }

    public void addColumn(int n) {
        if (this.usedColumns != null) {
            this.usedColumns[n] = true;
        }
    }

    public void addAllColumns() {
        if (this.usedColumns != null) {
            ArrayUtil.fillArray(this.usedColumns, true);
        }
    }

    public void addNamedJoinColumnExpression(String string, Expression expression) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(string, expression);
    }

    public ExpressionColumn getColumnExpression(String string) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(string);
    }

    public Table getTable() {
        return this.rangeTable;
    }

    public boolean hasAnyIndexCondition() {
        int n;
        for (n = 0; n < this.joinConditions.length; ++n) {
            if (this.joinConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        for (n = 0; n < this.whereConditions.length; ++n) {
            if (this.whereConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSingleIndexCondition() {
        return this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount > 0;
    }

    public boolean setDistinctColumnsOnIndex(int[] nArray) {
        if (this.joinConditions.length != 1) {
            return false;
        }
        int[] nArray2 = this.joinConditions[0].rangeIndex.getColumns();
        if (nArray.length != ArrayUtil.countTrueElements(this.usedColumns)) {
            return false;
        }
        if (nArray.length == 1 && nArray[0] == nArray2[0]) {
            this.indexDistinctCount = 1;
            return true;
        }
        return false;
    }

    public Index getSortIndex() {
        if (this.joinConditions.length == 1) {
            return this.joinConditions[0].rangeIndex;
        }
        return null;
    }

    public boolean setSortIndex(Index index, boolean bl) {
        if (this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount == 0) {
            this.joinConditions[0].rangeIndex = index;
            this.joinConditions[0].reversed = bl;
            return true;
        }
        return false;
    }

    public boolean reverseOrder() {
        this.joinConditions[0].reverseIndexCondition();
        return true;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        if (this.columnAliases != null) {
            orderedHashSet.addAll(this.columnAliases);
            return orderedHashSet;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String string = this.rangeTable.getColumn((int)i).getName().name;
            boolean bl = orderedHashSet.add(string);
            if (bl) continue;
            throw Error.error(5578, string);
        }
        return orderedHashSet;
    }

    public int findColumn(String string, String string2, String string3) {
        if (this.resolvesSchemaAndTableName(string, string2)) {
            return this.findColumn(string3);
        }
        return -1;
    }

    private int findColumn(String string) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(string)) {
            return -1;
        }
        if (this.variables != null) {
            return this.variables.getIndex(string);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(string);
        }
        return this.rangeTable.findColumn(string);
    }

    public ColumnSchema getColumn(int n) {
        if (this.variables == null) {
            return this.rangeTable.getColumn(n);
        }
        return (ColumnSchema)this.variables.get(n);
    }

    public HsqlNameManager.SimpleName getColumnAlias(int n) {
        if (this.columnAliases == null) {
            return this.rangeTable.getColumn(n).getName();
        }
        return this.columnAliasNames[n];
    }

    public boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    public boolean hasTableAlias() {
        return this.tableAlias != null;
    }

    public HsqlNameManager.SimpleName getTableAlias() {
        return this.tableAlias == null ? this.rangeTable.getName() : this.tableAlias;
    }

    public RangeVariable getRangeForTableName(String string) {
        if (this.resolvesTableName(string)) {
            return this;
        }
        return null;
    }

    private boolean resolvesSchemaAndTableName(String string, String string2) {
        return this.resolvesSchemaName(string) && this.resolvesTableName(string2);
    }

    private boolean resolvesTableName(String string) {
        if (string == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return string.equals(this.tableAlias.name);
            }
            return false;
        }
        return this.tableAlias == null ? string.equals(this.rangeTable.getName().name) : string.equals(this.tableAlias.name);
    }

    private boolean resolvesSchemaName(String string) {
        if (string == null) {
            return true;
        }
        if (this.variables != null) {
            return false;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return string.equals(this.rangeTable.getSchemaName().name);
    }

    public void addTableColumns(HsqlArrayList hsqlArrayList) {
        if (this.namedJoinColumns != null) {
            int n = hsqlArrayList.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Expression expression = (Expression)hsqlArrayList.get(i);
                String string = expression.getColumnName();
                if (!this.namedJoinColumns.contains(string)) continue;
                if (n2 != i) {
                    hsqlArrayList.remove(i);
                    hsqlArrayList.add(n2, expression);
                }
                expression = this.getColumnExpression(string);
                hsqlArrayList.set(n2, expression);
                ++n2;
            }
        }
        this.addTableColumns(hsqlArrayList, hsqlArrayList.size(), (HashSet)this.namedJoinColumns);
    }

    public int addTableColumns(HsqlArrayList hsqlArrayList, int n, HashSet hashSet) {
        Table table = this.getTable();
        int n2 = table.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(n++, expressionColumn);
        }
        return n;
    }

    public void addTableColumns(RangeVariable rangeVariable, Expression expression, HashSet hashSet) {
        if (rangeVariable == this) {
            Table table = this.getTable();
            int n = table.getColumnCount();
            this.addTableColumns(expression, 0, n, hashSet);
        }
    }

    protected int getFirstColumnIndex(RangeVariable rangeVariable) {
        if (rangeVariable == this) {
            return 0;
        }
        return -1;
    }

    protected void addTableColumns(Expression expression, int n, int n2, HashSet hashSet) {
        Table table = this.getTable();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i = n; i < n + n2; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(expressionColumn);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression.nodes = expressionArray;
    }

    public void setForCheckConstraint() {
        this.joinConditions[0].rangeIndex = null;
        this.rangePosition = 0;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void addJoinCondition(Expression expression) {
        this.joinCondition = ExpressionLogical.andExpressions(this.joinCondition, expression);
    }

    public void resetConditions() {
        Index index = this.joinConditions[0].rangeIndex;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = index;
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public OrderedHashSet getSubqueries() {
        OrderedHashSet orderedHashSet = null;
        if (this.joinCondition != null) {
            orderedHashSet = this.joinCondition.collectAllSubqueries(orderedHashSet);
        }
        if (this.rangeTable instanceof TableDerived) {
            QueryExpression queryExpression = ((TableDerived)this.rangeTable).getQueryExpression();
            if (queryExpression == null) {
                Expression expression = ((TableDerived)this.rangeTable).getDataExpression();
                if (expression != null) {
                    if (orderedHashSet == null) {
                        orderedHashSet = new OrderedHashSet();
                    }
                    OrderedHashSet.addAll(orderedHashSet, expression.getSubqueries());
                }
            } else {
                OrderedHashSet orderedHashSet2 = queryExpression.getSubqueries();
                orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
                orderedHashSet = OrderedHashSet.add(orderedHashSet, this.rangeTable);
            }
        }
        return orderedHashSet;
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        if (this.joinCondition != null) {
            orderedHashSet = this.joinCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression expression = this.rangeTable.getDataExpression();
        if (queryExpression != null) {
            orderedHashSet = queryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (expression != null) {
            orderedHashSet = expression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    public void replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
        int n;
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression expression = this.rangeTable.getDataExpression();
        if (expression != null) {
            expression = expression.replaceColumnReferences(rangeVariable, expressionArray);
        }
        if (queryExpression != null) {
            queryExpression.replaceColumnReferences(rangeVariable, expressionArray);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.replaceColumnReferences(rangeVariable, expressionArray);
        }
        for (n = 0; n < this.joinConditions.length; ++n) {
            this.joinConditions[n].replaceColumnReferences(rangeVariable, expressionArray);
        }
        for (n = 0; n < this.whereConditions.length; ++n) {
            this.whereConditions[n].replaceColumnReferences(rangeVariable, expressionArray);
        }
    }

    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
    }

    public void resolveRangeTable(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroupArray) {
        HsqlList hsqlList;
        Table table = this.rangeTable;
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression expression = this.rangeTable.getDataExpression();
        if (queryExpression == null && expression == null) {
            return;
        }
        rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
        if (expression != null) {
            hsqlList = expression.resolveColumnReferences(session, RangeGroup.emptyGroup, rangeGroupArray, null);
            hsqlList = Expression.resolveColumnSet(session, emptyArray, RangeGroup.emptyArray, hsqlList);
            ExpressionColumn.checkColumnsResolved(hsqlList);
            expression.resolveTypes(session, null);
            this.setRangeTableVariables();
        }
        if (queryExpression != null) {
            queryExpression.resolveReferences(session, rangeGroupArray);
            hsqlList = queryExpression.getUnresolvedExpressions();
            hsqlList = Expression.resolveColumnSet(session, emptyArray, RangeGroup.emptyArray, hsqlList);
            ExpressionColumn.checkColumnsResolved(hsqlList);
            queryExpression.resolveTypesPartOne(session);
            queryExpression.resolveTypesPartTwo(session);
            this.rangeTable.prepareTable();
            this.setRangeTableVariables();
        }
    }

    void resolveRangeTableTypes(Session session, RangeVariable[] rangeVariableArray) {
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        if (queryExpression != null) {
            if (queryExpression instanceof QuerySpecification) {
                QuerySpecification querySpecification = (QuerySpecification)queryExpression;
                if (!(querySpecification.isGrouped || querySpecification.isAggregated || querySpecification.isOrderSensitive)) {
                    this.moveConditionsToInner(session, rangeVariableArray);
                }
            }
            queryExpression.resolveTypesPartThree(session);
        }
    }

    void moveConditionsToInner(Session session, RangeVariable[] rangeVariableArray) {
        int n = ArrayUtil.find(rangeVariableArray, this);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        if (this.isRightJoin) {
            if (this.whereConditions.length > 1) {
                return;
            }
            RangeVariable.addConditionsToList(hsqlArrayList, this.whereConditions[0].indexCond);
            if (this.whereConditions[0].indexCond != null && this.whereConditions[0].indexCond[0] != this.whereConditions[0].indexEndCond[0]) {
                RangeVariable.addConditionsToList(hsqlArrayList, this.whereConditions[0].indexEndCond);
            }
            RangeVariableResolver.decomposeAndConditions(session, this.whereConditions[0].nonIndexCondition, hsqlArrayList);
        } else {
            if (this.joinConditions.length > 1 || this.whereConditions.length > 1) {
                return;
            }
            RangeVariable.addConditionsToList(hsqlArrayList, this.joinConditions[0].indexCond);
            if (this.joinConditions[0].indexCond != null && this.joinConditions[0].indexCond[0] != this.joinConditions[0].indexEndCond[0]) {
                RangeVariable.addConditionsToList(hsqlArrayList, this.joinConditions[0].indexEndCond);
            }
            RangeVariable.addConditionsToList(hsqlArrayList, this.whereConditions[0].indexCond);
            RangeVariable.addConditionsToList(hsqlArrayList, this.whereConditions[0].indexEndCond);
            RangeVariableResolver.decomposeAndConditions(session, this.joinConditions[0].nonIndexCondition, hsqlArrayList);
            RangeVariableResolver.decomposeAndConditions(session, this.whereConditions[0].nonIndexCondition, hsqlArrayList);
        }
        for (int i = hsqlArrayList.size() - 1; i >= 0; --i) {
            Expression expression2 = (Expression)hsqlArrayList.get(i);
            if (expression2 != null && expression2 != ExpressionLogical.EXPR_TRUE && !expression2.hasReference(rangeVariableArray, n)) continue;
            hsqlArrayList.remove(i);
        }
        if (hsqlArrayList.size() == 0) {
            if (this.rangeTable.isView()) {
                ((TableDerived)this.rangeTable).resetToView();
            }
            return;
        }
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression[] expressionArray = ((QuerySpecification)queryExpression).exprColumns;
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Expression expression3 = (Expression)hsqlArrayList.get(i);
            if (expression3.hasReference(rangeVariableArray, n)) continue;
            expression3 = expression3.duplicate();
            if ((expression3 = expression3.replaceColumnReferences(this, expressionArray)).collectAllSubqueries(null) != null) {
                return;
            }
            expression = ExpressionLogical.andExpressions(expression, expression3);
        }
        queryExpression.addExtraConditions(expression);
    }

    private static void addConditionsToList(HsqlArrayList hsqlArrayList, Expression[] expressionArray) {
        if (expressionArray == null) {
            return;
        }
        for (int i = 0; i < expressionArray.length; ++i) {
            if (expressionArray[i] == null || !expressionArray[i].isSingleColumnCondition && !expressionArray[i].isSingleColumnNull && !expressionArray[i].isSingleColumnNotNull) continue;
            hsqlArrayList.add(expressionArray[i]);
        }
    }

    public String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "INNER";
        if (this.isLeftJoin) {
            string = "LEFT OUTER";
            if (this.isRightJoin) {
                string = "FULL";
            }
        } else if (this.isRightJoin) {
            string = "RIGHT OUTER";
        }
        stringBuffer2.append(stringBuffer).append("join type=").append(string).append("\n");
        stringBuffer2.append(stringBuffer).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            stringBuffer2.append(stringBuffer).append("alias=").append(this.tableAlias.name).append("\n");
        }
        RangeVariableConditions[] rangeVariableConditionsArray = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            rangeVariableConditionsArray = this.whereConditions;
        }
        stringBuffer2.append(stringBuffer).append("cardinality=");
        stringBuffer2.append(rangeVariableConditionsArray[0].rangeIndex.size(session, this.rangeTable.getRowStore(session))).append("\n");
        boolean bl = !rangeVariableConditionsArray[0].hasIndexCondition();
        stringBuffer2.append(stringBuffer);
        if (rangeVariableConditionsArray == this.whereConditions && this.joinConditions[0].nonIndexCondition != null) {
            stringBuffer2.append("join condition = [");
            stringBuffer2.append(this.joinConditions[0].nonIndexCondition.describe(session, n));
            stringBuffer2.append(stringBuffer).append("]\n");
            stringBuffer2.append(stringBuffer);
        }
        stringBuffer2.append("access=").append(bl ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < rangeVariableConditionsArray.length; ++i) {
            if (i > 0) {
                stringBuffer2.append(stringBuffer).append("OR condition = [");
            } else {
                stringBuffer2.append(stringBuffer);
                if (rangeVariableConditionsArray == this.whereConditions) {
                    stringBuffer2.append("where condition = [");
                } else {
                    stringBuffer2.append("join condition = [");
                }
            }
            stringBuffer2.append(rangeVariableConditionsArray[i].describe(session, n + 2));
            stringBuffer2.append(stringBuffer).append("]\n");
        }
        if (rangeVariableConditionsArray == this.joinConditions) {
            stringBuffer2.append(stringBuffer);
            if (this.whereConditions[0].nonIndexCondition != null) {
                stringBuffer2.append("where condition = [");
                stringBuffer2.append(this.whereConditions[0].nonIndexCondition.describe(session, n));
                stringBuffer2.append(stringBuffer).append("]\n");
                stringBuffer2.append(stringBuffer);
            }
        }
        return stringBuffer2.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain rangeIteratorMain = this.isRightJoin ? new RangeIteratorRight(session, this, null) : new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(rangeIteratorMain);
        return rangeIteratorMain;
    }

    public static RangeIterator getIterator(Session session, RangeVariable[] rangeVariableArray) {
        if (rangeVariableArray.length == 1) {
            return rangeVariableArray[0].getIterator(session);
        }
        RangeIteratorMain[] rangeIteratorMainArray = new RangeIteratorMain[rangeVariableArray.length];
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            rangeIteratorMainArray[i] = rangeVariableArray[i].getIterator(session);
        }
        return new RangeIteratorJoined(rangeIteratorMainArray);
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        RowIterator it;
        PersistentStore store;
        Object[] currentData;
        Row currentRow;
        boolean isBeforeFirst;
        RangeVariable rangeVar;

        private RangeIteratorBase() {
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            this.currentRow = this.it.getNextRow();
            if (this.currentRow == null) {
                return false;
            }
            this.currentData = this.currentRow.getData();
            return true;
        }

        @Override
        public Row getCurrentRow() {
            return this.currentRow;
        }

        @Override
        public Object[] getCurrent() {
            return this.currentData;
        }

        @Override
        public Object getCurrent(int n) {
            return this.currentData == null ? null : this.currentData[n];
        }

        @Override
        public void setCurrent(Object[] objectArray) {
            this.currentData = objectArray;
        }

        @Override
        public long getRowId() {
            return this.currentRow == null ? 0L : ((long)this.rangeVar.rangeTable.getId() << 32) + this.currentRow.getPos();
        }

        @Override
        public Object getRowidObject() {
            return this.currentRow == null ? null : ValuePool.getLong(this.getRowId());
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }

        @Override
        public Row getNextRow() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean hasNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public Object[] getNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean setRowColumns(boolean[] blArray) {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
        }
    }

    public static class RangeIteratorJoined
    extends RangeIteratorBase {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;

        public RangeIteratorJoined(RangeIteratorMain[] rangeIteratorMainArray) {
            this.rangeIterators = rangeIteratorMainArray;
            this.isBeforeFirst = true;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.currentIndex >= 0) {
                RangeIteratorMain rangeIteratorMain = this.rangeIterators[this.currentIndex];
                if (rangeIteratorMain.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    this.currentRow = this.rangeIterators[this.currentIndex].currentRow;
                    this.currentData = this.currentRow.getData();
                    return true;
                }
                rangeIteratorMain.reset();
                --this.currentIndex;
            }
            this.currentData = this.rangeIterators[this.rangeIterators.length - 1].rangeVar.emptyData;
            this.currentRow = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public int getRangePosition() {
            return 0;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasLeftOuterRow;
        boolean isFullIterator;
        RangeVariableConditions[] conditions;
        RangeVariableConditions[] whereConditions;
        RangeVariableConditions[] joinConditions;
        int condIndex = 0;
        OrderedLongHashSet lookup;
        Object[] currentJoinData = null;

        RangeIteratorMain() {
        }

        private RangeIteratorMain(Session session, RangeVariable rangeVariable) {
            this.rangePosition = rangeVariable.rangePosition;
            this.store = rangeVariable.rangeTable.getRowStore(session);
            this.session = session;
            this.rangeVar = rangeVariable;
            this.currentData = rangeVariable.emptyData;
            this.isBeforeFirst = true;
            this.whereConditions = rangeVariable.whereConditions;
            this.joinConditions = rangeVariable.joinConditions;
            if (rangeVariable.isRightJoin) {
                this.lookup = new OrderedLongHashSet();
            }
            this.conditions = rangeVariable.joinConditions;
            if (rangeVariable.whereConditions[0].hasIndexCondition()) {
                this.conditions = rangeVariable.whereConditions;
            }
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.condIndex < this.conditions.length) {
                boolean bl;
                if (this.isBeforeFirst) {
                    this.isBeforeFirst = false;
                    this.initialiseIterator();
                }
                if (bl = this.findNext()) {
                    return true;
                }
                this.reset();
                ++this.condIndex;
            }
            this.condIndex = 0;
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentData = this.rangeVar.emptyData;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            if (this.condIndex == 0) {
                this.hasLeftOuterRow = this.rangeVar.isLeftJoin;
            }
            if (this.conditions[this.condIndex].isFalse) {
                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                return;
            }
            this.rangeVar.rangeTable.materialiseCorrelated(this.session);
            if (this.conditions[this.condIndex].indexCond == null) {
                this.it = this.conditions[this.condIndex].reversed ? this.conditions[this.condIndex].rangeIndex.lastRow(this.session, this.store) : this.conditions[this.condIndex].rangeIndex.firstRow(this.session, this.store);
            } else {
                this.getFirstRow();
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            if (this.currentJoinData == null || this.currentJoinData.length < this.conditions[this.condIndex].indexedColumnCount) {
                this.currentJoinData = new Object[this.conditions[this.condIndex].indexedColumnCount];
            }
            for (int i = 0; i < this.conditions[this.condIndex].indexedColumnCount; ++i) {
                Object object;
                block11: {
                    int n;
                    int n2;
                    block12: {
                        int n3;
                        n2 = 0;
                        int n4 = n3 = i == this.conditions[this.condIndex].indexedColumnCount - 1 ? this.conditions[this.condIndex].opType : this.conditions[this.condIndex].indexCond[i].getType();
                        if (n3 == 47 || n3 == 48 || n3 == 74) {
                            this.currentJoinData[i] = null;
                            continue;
                        }
                        Type type = this.conditions[this.condIndex].indexCond[i].getRightNode().getDataType();
                        object = this.conditions[this.condIndex].indexCond[i].getRightNode().getValue(this.session);
                        Type type2 = this.conditions[this.condIndex].indexCond[i].getLeftNode().getDataType();
                        if (type2 != type && (n2 = type2.compareToTypeRange(object)) == 0 && type2.typeComparisonGroup != type.typeComparisonGroup) {
                            object = type2.convertToType(this.session, object, type);
                        }
                        if (i != 0) break block11;
                        n = this.conditions[this.condIndex].indexCond[0].getType();
                        if (n2 >= 0) break block12;
                        switch (n) {
                            case 42: 
                            case 43: {
                                object = null;
                                break block11;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                    if (n2 > 0) {
                        switch (n) {
                            case 48: {
                                object = null;
                                break;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                }
                this.currentJoinData[i] = object;
            }
            this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, this.currentJoinData, this.conditions[this.condIndex].indexedColumnCount, this.rangeVar.indexDistinctCount, this.conditions[this.condIndex].opType, this.conditions[this.condIndex].reversed, null);
        }

        private boolean findNext() {
            boolean bl;
            block5: {
                bl = false;
                while (true) {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block5;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].terminalCondition != null && !this.conditions[this.condIndex].terminalCondition.testCondition(this.session)) break block5;
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) {
                        if (!this.conditions[this.condIndex].isJoin) {
                            this.hasLeftOuterRow = false;
                        }
                        break block5;
                    }
                    if (this.joinConditions[this.condIndex].nonIndexCondition != null && !this.joinConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) continue;
                    if (this.whereConditions[this.condIndex].nonIndexCondition != null && !this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                        this.hasLeftOuterRow = false;
                        this.addFoundRow();
                        continue;
                    }
                    Expression expression = this.conditions[this.condIndex].excludeConditions;
                    if (expression == null || !expression.testCondition(this.session)) break;
                }
                this.addFoundRow();
                this.hasLeftOuterRow = false;
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            if (this.hasLeftOuterRow && this.condIndex == this.conditions.length - 1) {
                bl = this.whereConditions[this.condIndex].nonIndexCondition == null || this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session);
                this.hasLeftOuterRow = false;
            }
            return bl;
        }

        private void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                this.lookup.add(this.currentRow.getPos());
            }
        }
    }

    public static class RangeIteratorRight
    extends RangeIteratorMain {
        boolean isOnRightOuterRows;

        private RangeIteratorRight(Session session, RangeVariable rangeVariable, RangeIteratorMain rangeIteratorMain) {
            super(session, rangeVariable);
            this.isFullIterator = true;
        }

        public void setOnOuterRows() {
            this.conditions = this.rangeVar.whereConditions;
            this.isOnRightOuterRows = true;
            this.hasLeftOuterRow = false;
            this.condIndex = 0;
            this.initialiseIterator();
        }

        @Override
        public boolean next() {
            if (this.isOnRightOuterRows) {
                if (this.it == null) {
                    return false;
                }
                return this.findNextRight();
            }
            return super.next();
        }

        private boolean findNextRight() {
            boolean bl;
            block2: {
                bl = false;
                do {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block2;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) break block2;
                } while (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session) || !this.lookupAndTest());
                bl = true;
            }
            if (bl) {
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            return bl;
        }

        private boolean lookupAndTest() {
            boolean bl;
            boolean bl2 = bl = !this.lookup.contains(this.currentRow.getPos());
            if (bl) {
                this.currentData = this.currentRow.getData();
                if (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                    bl = false;
                }
            }
            return bl;
        }
    }

    public static class RangeVariableConditions {
        final RangeVariable rangeVar;
        Expression[] indexCond;
        Expression[] indexEndCond;
        int[] opTypes;
        int[] opTypesEnd;
        Expression indexEndCondition;
        int indexedColumnCount;
        Index rangeIndex;
        final boolean isJoin;
        Expression excludeConditions;
        Expression nonIndexCondition;
        Expression terminalCondition;
        int opType;
        int opTypeEnd;
        boolean isFalse;
        boolean reversed;
        boolean hasIndex;

        RangeVariableConditions(RangeVariable rangeVariable, boolean bl) {
            this.rangeVar = rangeVariable;
            this.isJoin = bl;
        }

        RangeVariableConditions(RangeVariableConditions rangeVariableConditions) {
            this.rangeVar = rangeVariableConditions.rangeVar;
            this.isJoin = rangeVariableConditions.isJoin;
            this.nonIndexCondition = rangeVariableConditions.nonIndexCondition;
        }

        boolean hasIndexCondition() {
            return this.indexedColumnCount > 0;
        }

        boolean hasIndex() {
            return this.hasIndex;
        }

        void addCondition(Expression expression) {
            if (expression == null) {
                return;
            }
            if (expression instanceof ExpressionLogical && ((ExpressionLogical)expression).isTerminal) {
                this.terminalCondition = expression;
            }
            this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, expression);
            if (Expression.EXPR_FALSE.equals(this.nonIndexCondition)) {
                this.isFalse = true;
            }
            if (this.rangeIndex == null || this.rangeIndex.getColumnCount() == 0) {
                return;
            }
            if (this.indexedColumnCount == 0) {
                return;
            }
            if (expression.getIndexableExpression(this.rangeVar) == null) {
                return;
            }
            int n = expression.getLeftNode().getColumnIndex();
            int[] nArray = this.rangeIndex.getColumns();
            switch (expression.getType()) {
                case 42: 
                case 43: {
                    if (this.opType == 48) {
                        if (nArray[this.indexedColumnCount - 1] != n) break;
                        this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, this.indexCond[this.indexedColumnCount - 1]);
                        this.indexCond[this.indexedColumnCount - 1] = expression;
                        this.opType = expression.opType;
                        this.opTypes[this.indexedColumnCount - 1] = expression.opType;
                        if (expression.exprSubType != 53 || this.indexedColumnCount != 1) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = ExpressionLogical.andExpressions(this.indexEndCond[this.indexedColumnCount - 1], expression.nodes[2]);
                        break;
                    }
                    this.addToIndexConditions(expression);
                    break;
                }
                case 44: 
                case 45: {
                    if (this.opType == 43 || this.opType == 42 || this.opType == 48) {
                        if (this.opTypeEnd != 74 || nArray[this.indexedColumnCount - 1] != n) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = expression;
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                        this.opTypeEnd = expression.opType;
                        this.opTypesEnd[this.indexedColumnCount - 1] = expression.opType;
                        break;
                    }
                    this.addToIndexEndConditions(expression);
                    break;
                }
            }
        }

        private boolean addToIndexConditions(Expression expression) {
            if ((this.opType == 41 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == expression.getLeftNode().getColumnIndex()) {
                this.indexCond[this.indexedColumnCount] = expression;
                this.opType = expression.opType;
                this.opTypes[this.indexedColumnCount] = expression.opType;
                this.opTypeEnd = 74;
                this.opTypesEnd[this.indexedColumnCount] = 74;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        private boolean addToIndexEndConditions(Expression expression) {
            if ((this.opType == 41 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == expression.getLeftNode().getColumnIndex()) {
                ExpressionLogical expressionLogical = ExpressionLogical.newNotNullCondition(expression.getLeftNode());
                this.indexCond[this.indexedColumnCount] = expressionLogical;
                this.indexEndCond[this.indexedColumnCount] = expression;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                this.opType = 48;
                this.opTypes[this.indexedColumnCount] = 48;
                this.opTypeEnd = expression.opType;
                this.opTypesEnd[this.indexedColumnCount] = expression.opType;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        public void addIndexCondition(Expression[] expressionArray, Index index, int n) {
            int n2 = index.getColumnCount();
            this.rangeIndex = index;
            this.indexCond = new Expression[n2];
            this.indexEndCond = new Expression[n2];
            this.opTypes = new int[n2];
            this.opTypesEnd = new int[n2];
            this.opType = expressionArray[0].opType;
            this.opTypes[0] = expressionArray[0].opType;
            switch (this.opType) {
                case 48: {
                    this.indexCond = expressionArray;
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 42: 
                case 43: {
                    this.indexCond = expressionArray;
                    if (expressionArray[0].exprSubType == 53) {
                        this.indexEndCond[0] = this.indexEndCondition = expressionArray[0].nodes[2];
                    }
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 44: 
                case 45: {
                    Expression expression = expressionArray[0].getLeftNode();
                    expression = new ExpressionLogical(47, expression);
                    this.indexCond[0] = expression = new ExpressionLogical(48, expression);
                    this.indexEndCond[0] = this.indexEndCondition = expressionArray[0];
                    this.opTypeEnd = this.opType;
                    this.opTypesEnd[0] = this.opType;
                    this.opType = 48;
                    this.opTypes[0] = 48;
                    break;
                }
                case 41: 
                case 47: {
                    this.indexCond = expressionArray;
                    for (int i = 0; i < n; ++i) {
                        Expression expression;
                        this.indexEndCond[i] = expression = expressionArray[i];
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                        this.opType = expression.opType;
                        this.opTypes[0] = expression.opType;
                    }
                    this.opTypeEnd = this.opType;
                    break;
                }
                default: {
                    Error.runtimeError(201, "RangeVariable");
                }
            }
            this.indexedColumnCount = n;
            this.hasIndex = true;
        }

        public void reverseIndexCondition() {
            if (this.opType == 41 || this.opType == 47) {
                return;
            }
            this.indexEndCondition = null;
            for (int i = 0; i < this.indexedColumnCount; ++i) {
                Expression expression = this.indexCond[i];
                this.indexCond[i] = this.indexEndCond[i];
                this.indexEndCond[i] = expression;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
            }
            this.opType = this.opTypeEnd;
            this.reversed = true;
        }

        String describe(Session session, int n) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer(n);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer2.append(' ');
            }
            stringBuffer.append("index=").append(this.rangeIndex.getName().name).append("\n");
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    stringBuffer.append(stringBuffer2).append("start conditions=[");
                    for (n2 = 0; n2 < this.indexedColumnCount; ++n2) {
                        if (this.indexCond == null || this.indexCond[n2] == null) continue;
                        stringBuffer.append(this.indexCond[n2].describe(session, n));
                    }
                    stringBuffer.append("]\n");
                }
                if (this.indexEndCondition != null) {
                    String string = this.indexEndCondition.describe(session, n);
                    stringBuffer.append(stringBuffer2).append("end condition=[").append(string).append("]\n");
                }
            }
            if (this.nonIndexCondition != null) {
                String string = this.nonIndexCondition.describe(session, n);
                stringBuffer.append(stringBuffer2).append("other condition=[").append(string).append("]\n");
            }
            return stringBuffer.toString();
        }

        public void replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
            int n;
            if (this.indexCond != null) {
                for (n = 0; n < this.indexCond.length; ++n) {
                    if (this.indexCond[n] == null) continue;
                    this.indexCond[n] = this.indexCond[n].replaceColumnReferences(rangeVariable, expressionArray);
                }
            }
            if (this.indexEndCond != null) {
                for (n = 0; n < this.indexEndCond.length; ++n) {
                    if (this.indexEndCond[n] == null) continue;
                    this.indexEndCond[n] = this.indexEndCond[n].replaceColumnReferences(rangeVariable, expressionArray);
                }
            }
            if (this.indexEndCondition != null) {
                this.indexEndCondition = this.indexEndCondition.replaceColumnReferences(rangeVariable, expressionArray);
            }
            if (this.excludeConditions != null) {
                this.excludeConditions = this.excludeConditions.replaceColumnReferences(rangeVariable, expressionArray);
            }
            if (this.nonIndexCondition != null) {
                this.nonIndexCondition = this.nonIndexCondition.replaceColumnReferences(rangeVariable, expressionArray);
            }
            if (this.terminalCondition != null) {
                this.terminalCondition = this.terminalCondition.replaceColumnReferences(rangeVariable, expressionArray);
            }
        }
    }
}

