/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.mapping.IChangeGroupingRequestor;
import org.eclipse.team.internal.core.IRepositoryProviderListener;
import org.eclipse.team.internal.core.RepositoryProviderManager;
import org.eclipse.team.internal.core.TeamPlugin;

public abstract class ChangeTracker {
    private Map<IProject, IChangeGroupingRequestor> trackedProjects = new HashMap<IProject, IChangeGroupingRequestor>();
    private boolean disposed;
    private ChangeListener changeListener = new ChangeListener();

    public void start() {
        IProject[] allProjects;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.changeListener, 1);
        RepositoryProviderManager.getInstance().addListener(this.changeListener);
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.isProjectOfInterest(project)) {
                this.trackProject(project);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.disposed = true;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.changeListener);
        RepositoryProviderManager.getInstance().removeListener(this.changeListener);
    }

    private IResource[] getProjectChanges(IProject project, IResourceDelta projectDelta) {
        ArrayList result = new ArrayList();
        try {
            projectDelta.accept(delta -> {
                if (this.isResourceOfInterest(delta.getResource()) & this.isChangeOfInterest(delta)) {
                    result.add(delta.getResource());
                }
                return true;
            });
        }
        catch (CoreException e) {
            TeamPlugin.log(e);
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected boolean isChangeOfInterest(IResourceDelta delta) {
        return (delta.getKind() & 7) > 0;
    }

    protected void stopTrackingProject(IProject project) {
        this.trackedProjects.remove(project);
    }

    protected final boolean isProjectTracked(IProject project) {
        return this.trackedProjects.containsKey(project);
    }

    protected boolean isProjectOfInterest(IProject project) {
        return project.isAccessible();
    }

    protected abstract boolean isResourceOfInterest(IResource var1);

    protected abstract void handleChanges(IProject var1, IResource[] var2);

    protected abstract void handleProjectChange(IProject var1);

    protected final boolean trackProject(IProject project) {
        if (RepositoryProvider.isShared(project)) {
            try {
                IChangeGroupingRequestor collector;
                RepositoryProviderType type;
                String currentId = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                if (currentId != null && (type = RepositoryProviderType.getProviderType(currentId)) != null && (collector = this.getCollector(type)) != null) {
                    this.trackedProjects.put(project, collector);
                    this.projectTracked(project);
                    return true;
                }
            }
            catch (CoreException e) {
                TeamPlugin.log(e);
            }
        }
        return false;
    }

    private IChangeGroupingRequestor getCollector(RepositoryProviderType type) {
        IChangeGroupingRequestor o;
        if (type != null && (o = (IChangeGroupingRequestor)type.getAdapter(IChangeGroupingRequestor.class)) != null) {
            return o;
        }
        return null;
    }

    protected void projectTracked(IProject project) {
        this.handleProjectChange(project);
    }

    protected void ensureGrouped(IProject project, String name, IFile[] files) throws CoreException {
        IChangeGroupingRequestor collector = this.getCollector(project);
        if (collector != null) {
            collector.ensureChangesGrouped(project, files, name);
        }
    }

    private IChangeGroupingRequestor getCollector(IProject project) {
        return this.trackedProjects.get(project);
    }

    protected boolean isModified(IFile file) throws CoreException {
        IChangeGroupingRequestor collector = this.getCollector(file.getProject());
        if (collector != null) {
            return collector.isModified(file);
        }
        return false;
    }

    private class ChangeListener
    implements IResourceChangeListener,
    IRepositoryProviderListener {
        private ChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] projectDeltas;
            if (ChangeTracker.this.disposed) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = projectDeltas = delta.getAffectedChildren(7);
            int n = projectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projectDelta = iResourceDeltaArray[n2];
                IResource resource = projectDelta.getResource();
                if (resource.getType() == 4) {
                    IProject project = (IProject)resource;
                    if (ChangeTracker.this.isProjectOfInterest(project)) {
                        if (ChangeTracker.this.isProjectTracked(project)) {
                            IResource[] resources = ChangeTracker.this.getProjectChanges(project, projectDelta);
                            if (resources.length > 0) {
                                ChangeTracker.this.handleChanges(project, resources);
                            }
                        } else {
                            ChangeTracker.this.trackProject(project);
                        }
                    } else {
                        ChangeTracker.this.stopTrackingProject(project);
                    }
                }
                ++n2;
            }
        }

        @Override
        public void providerMapped(RepositoryProvider provider) {
            if (ChangeTracker.this.disposed) {
                return;
            }
            if (ChangeTracker.this.isProjectOfInterest(provider.getProject())) {
                ChangeTracker.this.trackProject(provider.getProject());
            }
        }

        @Override
        public void providerUnmapped(IProject project) {
            if (ChangeTracker.this.disposed) {
                return;
            }
            ChangeTracker.this.stopTrackingProject(project);
        }
    }
}

