/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;

public interface UserService {
    public IUserGroup getUserGroup(IUserGroupArtifactToken var1);

    public Collection<IUserGroupArtifactToken> getMyUserGroups();

    public boolean isInUserGroup(IUserGroupArtifactToken ... var1);

    public boolean isUserMember(IUserGroupArtifactToken var1, Long var2);

    public boolean isUserMember(IUserGroupArtifactToken var1, ArtifactId var2);

    public boolean isBeforeUserCreation();

    public void setBeforeUserCreation(boolean var1);

    public Collection<UserToken> getUsers(IUserGroupArtifactToken var1);

    public IUserGroup getUserGroup(ArtifactToken var1);

    public UserToken getUser();

    public UserToken getUser(Long var1);

    default public UserToken getUserIfLoaded() {
        return UserToken.SENTINEL;
    }

    default public UserToken getUserIfLoaded(Long accountId) {
        return UserToken.SENTINEL;
    }

    default public void setUserLoading(boolean loading) {
    }

    public void setUserForCurrentThread(String var1);

    public TransactionId createUsers(Iterable<UserToken> var1, String var2);

    public void setUserForCurrentThread(UserId var1);

    default public IUserGroup getOseeAdmin() {
        return this.getUserGroup(CoreUserGroups.OseeAdmin);
    }

    default public IUserGroup getOseeAccessAdmin() {
        return this.getUserGroup(CoreUserGroups.OseeAccessAdmin);
    }

    default public void requireRole(IUserGroupArtifactToken ... userGroups) throws OseeAccessDeniedException {
        UserToken user = this.getUser();
        List<IUserGroupArtifactToken> roles = user.getRoles();
        IUserGroupArtifactToken[] iUserGroupArtifactTokenArray = userGroups;
        int n = userGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IUserGroupArtifactToken userGroup = iUserGroupArtifactTokenArray[n2];
            if (roles.contains(userGroup)) {
                return;
            }
            ++n2;
        }
        throw new OseeAccessDeniedException("User %s is not in any of the user groups %s", user.toStringWithId(), Arrays.deepToString(userGroups));
    }

    default public void clearCaches() {
    }

    public UserToken getUserByUserId(String var1);

    public IUserGroup getUserGroupOrNull(IUserGroupArtifactToken var1);
}

