/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class XViewerHtmlReport {
    protected final String title;
    protected final String html;

    public XViewerHtmlReport(String title) {
        this(title, null);
    }

    public XViewerHtmlReport(String title, String html) {
        this.title = title;
        this.html = html;
    }

    protected String getHtml() throws XViewerException {
        return this.html;
    }

    public void open() {
        this.open(null);
    }

    public void open(String defaultFilename) {
        try {
            String filename;
            String html = this.getHtml();
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.html"});
            if (defaultFilename != null && !defaultFilename.equals("")) {
                dialog.setFileName(defaultFilename);
            }
            if ((filename = dialog.open()) == null || filename.equals("")) {
                return;
            }
            try {
                XViewerLib.writeStringToFile(html, new File(filename));
            }
            catch (IOException ex) {
                XViewerLog.log(Activator.class, Level.SEVERE, ex);
                return;
            }
            Program.launch((String)filename);
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
    }
}

