/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.ArtifactLabelProvider;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.ArtifactTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Shell;

public class SprintReportAction
extends AbstractAtsAction {
    private final IAgileBacklog bLog;
    private final AtsApi atsApi;
    private final HashCollection<Long, IAgileItem> sprintToItem = new HashCollection();
    private final HashMap<Long, IAgileSprint> idToSprint = new HashMap();
    private XResultData rd;
    private final Map<String, Long> sprintNameToId = new HashMap<String, Long>();
    private final IAgileSprint sprint;
    private final boolean forBacklog;

    public SprintReportAction(IAgileSprint sprint) {
        this.sprint = sprint;
        this.bLog = null;
        this.forBacklog = false;
        this.setText("Generate Sprint Loading Report");
        this.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.REPORT));
        this.setToolTipText("Generate Sprint Loading Report for Agile Sprint");
        this.atsApi = AtsApiService.get();
    }

    public SprintReportAction(IAgileBacklog bLog, boolean forBacklog) {
        this.bLog = bLog;
        this.forBacklog = forBacklog;
        this.sprint = null;
        this.setText("Generate Sprint Loading Report");
        this.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.REPORT));
        this.setToolTipText("Generate Sprint Loading Report for Agile Team's Backlog");
        this.atsApi = AtsApiService.get();
    }

    @Override
    public void runWithException() {
        this.sprintToItem.clear();
        this.idToSprint.clear();
        this.sprintNameToId.clear();
        if (this.forBacklog) {
            this.loadItemsFromBacklog();
        } else {
            this.loadItemsFromSprint();
        }
        this.processSprints();
        XResultDataUI.report((XResultData)this.rd, (String)"Sprint Loading Report");
    }

    private void loadItemsFromSprint() {
        this.sprintNameToId.put(this.sprint.getName(), this.sprint.getId());
        for (IAgileItem item : this.atsApi.getAgileService().getItems(this.sprint)) {
            if (item.isCancelled()) continue;
            this.sprintToItem.put((Object)this.sprint.getId(), (Object)item);
            this.idToSprint.put(this.sprint.getId(), this.sprint);
        }
        this.rd = new XResultData();
        this.rd.logf("Sprint Loading Report for %s\n", new Object[]{this.sprint.getName()});
    }

    private void loadItemsFromBacklog() {
        IAgileBacklog useBLog = this.bLog;
        if (this.bLog == null && MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getText(), (String)"No Agile Backlog Specified\n\nNOTE: This report avaiable in Backlog Items Tab without having to choose Agile Team\n\nSelect Ok to Choose Backlog to Report or Cancel")) {
            LinkedList<Artifact> activeTeams = new LinkedList<Artifact>();
            for (Artifact agTeam : ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)AtsArtifactTypes.AgileTeam, (BranchId)AtsApiService.get().getAtsBranch())) {
                if (!((Boolean)agTeam.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue()) continue;
                activeTeams.add(agTeam);
            }
            FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog(this.getText(), "Select Agile Team", activeTeams, (ITreeContentProvider)new ArtifactTreeContentProvider(), (ILabelProvider)new ArtifactLabelProvider());
            if (dialog.open() == 0) {
                IAgileTeam aTeam = this.atsApi.getAgileService().getAgileTeam((ArtifactId)dialog.getSelectedFirst());
                useBLog = this.atsApi.getAgileService().getAgileBacklog(aTeam);
            } else {
                return;
            }
        }
        for (IAgileItem item : this.atsApi.getAgileService().getItems(useBLog)) {
            IAgileSprint sprint;
            if (item.isCancelled() || (sprint = this.atsApi.getAgileService().getSprint(item)) == null) continue;
            this.sprintToItem.put((Object)sprint.getId(), (Object)item);
            this.idToSprint.put(sprint.getId(), sprint);
            this.sprintNameToId.put(sprint.getName(), sprint.getId());
        }
        this.rd = new XResultData();
        this.rd.logf("Sprint Loading Report for Backlog %s\n", new Object[]{useBLog.getName()});
    }

    private void processSprints() {
        ArrayList<String> sprintNames = new ArrayList<String>();
        sprintNames.addAll(this.sprintNameToId.keySet());
        Collections.sort(sprintNames);
        for (String sprintName : sprintNames) {
            Long sprintId = this.sprintNameToId.get(sprintName);
            IAgileSprint sprint = this.idToSprint.get(sprintId);
            List sprintItems = (List)this.sprintToItem.getValues((Object)sprint.getId());
            this.rd.logf("\n======================================================\nSprint: %s\n======================================================\n", new Object[]{sprint.toString()});
            this.rd.logf("Num Items: %s\n\n", new Object[]{sprintItems.size()});
            double sprintPoints = 0.0;
            HashMap<String, Double> userNameToPoints = new HashMap<String, Double>();
            HashSet<String> names = new HashSet<String>();
            HashMap<String, Double> cat3ToPoints = new HashMap<String, Double>();
            HashSet<String> cat3s = new HashSet<String>();
            for (IAgileItem sprintItem : sprintItems) {
                String[] split;
                String itemPtsStr = this.atsApi.getAgileService().getPointsStr((IAtsWorkItem)sprintItem);
                double itemPts = 0.0;
                if (Strings.isNumeric((String)itemPtsStr)) {
                    itemPts = Double.valueOf(itemPtsStr);
                    sprintPoints += itemPts;
                }
                if (!(itemPts > 0.0)) continue;
                List assignees = null;
                assignees = this.forBacklog ? sprintItem.getStateMgr().getAssignees() : this.atsApi.getImplementerService().getImplementers((IAtsObject)sprintItem);
                if (assignees.size() > 0) {
                    Double pointsByAssignee = itemPts / (double)assignees.size();
                    for (AtsUser user : assignees) {
                        Double pts = (Double)userNameToPoints.get(user.getName());
                        if (pts == null) {
                            pts = 0.0;
                        }
                        pts = pts + pointsByAssignee;
                        userNameToPoints.put(user.getName(), pts);
                        names.add(user.getName());
                    }
                }
                String cat3 = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)sprintItem, (AttributeTypeToken)AtsAttributeTypes.Category3, (Object)"Not Set");
                String[] stringArray = split = cat3.split("/");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String splitCat = stringArray[n2];
                    Double pts = (Double)cat3ToPoints.get(splitCat);
                    if (pts == null) {
                        pts = 0.0;
                    }
                    Double ptsPerCat = itemPts / (double)split.length;
                    pts = pts + ptsPerCat;
                    cat3ToPoints.put(splitCat, pts);
                    cat3s.add(splitCat);
                    ++n2;
                }
            }
            Double totalPts = 0.0;
            this.rd.logf("Num Points: %s\n\n", new Object[]{sprintPoints});
            ArrayList<String> namesSorted = new ArrayList<String>();
            namesSorted.addAll(names);
            Collections.sort(namesSorted);
            for (String name : namesSorted) {
                Double pts = (Double)userNameToPoints.get(name);
                totalPts = totalPts + pts;
                if (!(pts > 0.0)) continue;
                this.rd.logf("Pts: %s - %s\n", new Object[]{name, pts});
            }
            this.rd.logf("\n\nPoints by Category\n\n", new Object[0]);
            ArrayList<String> cat3Sorted = new ArrayList<String>();
            cat3Sorted.addAll(cat3s);
            Collections.sort(cat3Sorted);
            for (String cat3 : cat3Sorted) {
                Double pts = (Double)cat3ToPoints.get(cat3);
                if (!(pts > 0.0)) continue;
                Double percent = 0.0;
                if (pts > 0.0) {
                    percent = pts / totalPts;
                }
                this.rd.logf("Cat3: %s - %s  -   Percent: %.2f\n", new Object[]{cat3, pts, percent});
            }
        }
    }
}

