/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.wizard;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AITreeContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsObjectNameSorter;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateFilteredTreeViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateTreeLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewActionUtil {
    private NewActionUtil() {
    }

    public static Pair<CheckBoxStateFilteredTreeViewer<IAtsActionableItem>, Text> createActionableItemTreeViewer(Composite comp, Collection<IAtsActionableItem> selectableAis) {
        Composite aiComp = new Composite(comp, 0);
        aiComp.setLayout((Layout)new GridLayout(1, false));
        aiComp.setLayoutData((Object)new GridData(1808));
        new Label(aiComp, 0).setText("Select Actionable Items:");
        final CheckBoxStateFilteredTreeViewer treeViewer = new CheckBoxStateFilteredTreeViewer(aiComp, 2824);
        treeViewer.getViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.getViewer().setContentProvider((IContentProvider)new AITreeContentProvider(Active.Active));
        treeViewer.getViewer().setLabelProvider((IBaseLabelProvider)new AITreeLabelProvider((ICheckBoxStateTreeViewer)treeViewer));
        try {
            if (selectableAis == null) {
                LinkedList<ActionableItem> activeActionableItemTree = new LinkedList<ActionableItem>();
                AtsConfigurations configs = AtsApiService.get().getConfigService().getConfigurations();
                for (Long aiId : ((ActionableItem)configs.getIdToAi().get(configs.getTopActionableItem().getId())).getChildren()) {
                    ActionableItem ai = (ActionableItem)configs.getIdToAi().get(aiId);
                    if (!ai.isActive()) continue;
                    activeActionableItemTree.add(ai);
                }
                treeViewer.getViewer().setInput(activeActionableItemTree);
                if (activeActionableItemTree.size() == 1) {
                    treeViewer.expandOneLevel();
                }
            } else {
                treeViewer.getViewer().setInput(selectableAis);
                if (selectableAis.size() == 1) {
                    treeViewer.expandOneLevel();
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        treeViewer.getViewer().setComparator((ViewerComparator)new AtsObjectNameSorter());
        GridData gridData1 = new GridData(1808);
        gridData1.heightHint = 400;
        treeViewer.setLayoutData((Object)gridData1);
        new Label(aiComp, 0).setText("Description of highlighted Actionable Item (if any):");
        Text descriptionLabel = new Text(aiComp, 2112);
        gridData1 = new GridData(1808);
        gridData1.heightHint = 15;
        descriptionLabel.setLayoutData((Object)gridData1);
        descriptionLabel.setEnabled(false);
        Button deselectAll = new Button(aiComp, 8);
        deselectAll.setText("De-Select All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                treeViewer.deSelectAll();
            }
        });
        return new Pair((Object)treeViewer, (Object)descriptionLabel);
    }

    public static class AITreeLabelProvider
    extends CheckBoxStateTreeLabelProvider {
        public AITreeLabelProvider(ICheckBoxStateTreeViewer treeViewer) {
            super(treeViewer);
        }

        protected boolean isEnabled(Object element) {
            IAtsActionableItem ai;
            boolean enabled = false;
            if (element instanceof IAtsActionableItem && (ai = (IAtsActionableItem)element).isActionable()) {
                enabled = true;
            }
            return enabled;
        }
    }
}

