/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.agile.SprintManager;
import org.eclipse.osee.ats.ide.agile.SprintXViewerFactory;
import org.eclipse.osee.ats.ide.column.AbstractMembersOrderColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.MembersManager;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SprintOrderColumn
extends AbstractMembersOrderColumn {
    public static final String COLUMN_ID = "ats.column.sprintOrder";
    public static SprintOrderColumn instance = new SprintOrderColumn();
    private SprintManager sprintManager;

    public static SprintOrderColumn getInstance() {
        return instance;
    }

    private SprintOrderColumn() {
        super(COLUMN_ID, "Sprint Order", 45, XViewerAlign.Left, false, SortDataType.Integer, true, "Order of item within displayed sprint.  Editing this field changes order.");
    }

    public SprintOrderColumn copy() {
        SprintOrderColumn newXCol = new SprintOrderColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            XViewer xViewer = (XViewer)this.getXViewer();
            IXViewerFactory xViewerFactory = xViewer.getXViewerFactory();
            SprintArtifact parentSprintArtifact = null;
            if (xViewerFactory instanceof SprintXViewerFactory) {
                parentSprintArtifact = ((SprintXViewerFactory)xViewerFactory).getSoleSprintArtifact();
            }
            if (parentSprintArtifact == null) {
                parentSprintArtifact = SprintOrderColumn.getParentSprintArtifact(treeItem);
            }
            SprintArtifact changedSprint = null;
            if (treeItem.getData() instanceof Artifact && (changedSprint = parentSprintArtifact != null ? new SprintManager().promptChangeMemberOrder(parentSprintArtifact, AtsApiService.get().getQueryServiceIde().getArtifact(treeItem)) : new SprintManager().promptChangeSprintOrder(AtsApiService.get().getQueryServiceIde().getArtifact(treeItem))) != null) {
                xViewer.refresh((Object)changedSprint);
                xViewer.update(treeItem.getData(), null);
            }
            return true;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public static SprintArtifact getParentSprintArtifact(TreeItem treeItem) {
        if (Widgets.isAccessible((Widget)treeItem) && Widgets.isAccessible((Widget)treeItem.getParentItem()) && Artifacts.isOfType((Object)treeItem.getParentItem().getData(), (ArtifactTypeToken)AtsArtifactTypes.AgileSprint)) {
            return (SprintArtifact)treeItem.getParentItem().getData();
        }
        return null;
    }

    @Override
    public Artifact getParentMembersArtifact(WorldXViewer worldXViewer) {
        return worldXViewer.getParentSprintArtifact();
    }

    @Override
    public MembersManager<?> getMembersManager() {
        if (this.sprintManager == null) {
            this.sprintManager = new SprintManager();
        }
        return this.sprintManager;
    }
}

