/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit.action;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxTeamWorkflow;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactState;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.bit.WfeBitTab;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitViewer;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ActionableItemTreeWithChildrenDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.TreeItem;

public class CreateSiblingAction
extends Action {
    private final IAtsTeamWorkflow teamWf;
    private final AtsApi atsApi;
    private final WorkflowEditor editor;

    public CreateSiblingAction(IAtsTeamWorkflow teamWf, WorkflowEditor editor) {
        this.teamWf = teamWf;
        this.editor = editor;
        this.atsApi = AtsApiService.get();
    }

    public void run() {
        WfeBitTab bitTab = this.editor.getBitTab();
        XBitViewer viewer = bitTab.getxViewer();
        TreeItem[] items = viewer.getTree().getSelection();
        if (items.length != 1) {
            AWorkbench.popup((String)"Must Select a Single Build Impact");
            return;
        }
        TreeItem item = items[0];
        Object obj = item.getData();
        if (obj instanceof BuildImpactData) {
            BuildImpactData bid = (BuildImpactData)obj;
            if (!bid.getState().equals(BuildImpactState.InWork.name())) {
                AWorkbench.popup((String)"Build Impact selected must be in InWork state");
                return;
            }
            ArtifactToken progArt = bid.getProgram();
            IAtsProgram program = this.atsApi.getProgramService().getProgramById((ArtifactId)progArt);
            Collection ais = this.atsApi.getProgramService().getAis(program);
            IAtsTeamDefinition teamDef = this.atsApi.getProgramService().getTeamDefHoldingVersions(program);
            IAtsActionableItem ai = (IAtsActionableItem)teamDef.getActionableItems().iterator().next();
            ais.remove(ai);
            ActionableItemTreeWithChildrenDialog dialog = new ActionableItemTreeWithChildrenDialog(Active.Active, ais);
            dialog.setAddIncludeAllCheckbox(false);
            if (dialog.open() == 0) {
                this.handleSelection(bid, dialog.getChecked());
            }
        } else {
            AWorkbench.popup((String)"Must Select a Single Build Impact");
            return;
        }
    }

    private void handleSelection(final BuildImpactData selBid, final Collection<IAtsActionableItem> aias) {
        Job createSiblingJob = new Job("Creating Sibling Workflows"){

            protected IStatus run(IProgressMonitor monitor) {
                BuildImpactDatas bids = new BuildImpactDatas();
                bids.setTeamWf(CreateSiblingAction.this.teamWf.getStoreObject());
                for (IAtsActionableItem ai : aias) {
                    BuildImpactData bid = new BuildImpactData();
                    bid.setBids(bids);
                    bid.setBidArt(selBid.getBidArt());
                    bid.setBuild(selBid.getBuild());
                    bid.setProgram(selBid.getProgram());
                    bid.setState(selBid.getState());
                    bids.addBuildImpactData(bid);
                    JaxTeamWorkflow jTeamWf = new JaxTeamWorkflow();
                    jTeamWf.setName(jTeamWf.getTitle());
                    jTeamWf.setNewAi(ai.getArtifactToken());
                    IAtsVersion version = CreateSiblingAction.this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)CreateSiblingAction.this.teamWf);
                    if (version != null) {
                        jTeamWf.setTargetVersion(version.getArtifactToken());
                    }
                    jTeamWf.setPriority((String)CreateSiblingAction.this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)CreateSiblingAction.this.teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)""));
                    bid.addTeamWorkflow(jTeamWf);
                }
                bids = CreateSiblingAction.this.atsApi.getServerEndpoints().getActionEndpoint().updateBids(CreateSiblingAction.this.teamWf.getAtsId(), bids);
                if (bids.getResults().isErrors()) {
                    XResultDataUI.report((XResultData)bids.getResults(), (String)"Error Creating Sibling Workflows");
                } else {
                    ((Artifact)CreateSiblingAction.this.teamWf).reloadAttributesAndRelations();
                    CreateSiblingAction.this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, Arrays.asList(CreateSiblingAction.this.teamWf), bids.getTransaction());
                }
                return Status.OK_STATUS;
            }
        };
        Operations.scheduleJob((Job)createSiblingJob, (boolean)true, (int)20, null);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.WORKFLOW);
    }

    public String getText() {
        return "Create New Sibling Team Workflow(s)";
    }

    public boolean isEnabled() {
        return this.teamWf.isInWork();
    }
}

