/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.journal;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.UserCheckTreeDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeJournalSubscribersComp
extends Composite {
    private static final String LABEL = "Journal Subscriber(s):";
    Label valueLabel;
    private final IAtsWorkItem workItem;

    public WfeJournalSubscribersComp(Composite parent, int style, final IAtsWorkItem workItem, final boolean isEditable, final WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.setLayoutData(new GridData(0, 0, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        this.setLayout((Layout)layout);
        editor.getToolkit().adapt((Composite)this);
        if (!workItem.isCancelled() && !workItem.isCompleted()) {
            Hyperlink link = editor.getToolkit().createHyperlink((Composite)this, LABEL, 0);
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        if (editor.isDirty()) {
                            editor.doSave(null);
                        }
                        if (!(isEditable || workItem.getStateMgr().getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER) || workItem.getStateMgr().getAssignees().contains(AtsApiService.get().getUserService().getCurrentUser()))) {
                            AWorkbench.popup((String)"ERROR", (String)"You must be assigned to modify assignees.\nContact current Assignee.");
                            return;
                        }
                        WfeJournalSubscribersComp.this.promptChangeJournalSubscribers(workItem);
                        WfeJournalSubscribersComp.this.refresh();
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
        } else {
            Label origLabel = editor.getToolkit().createLabel((Composite)this, LABEL);
            origLabel.setLayoutData((Object)new GridData());
        }
        this.valueLabel = editor.getToolkit().createLabel((Composite)this, "Not Set");
        this.valueLabel.setLayoutData((Object)new GridData());
        this.refresh();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.valueLabel)) {
            String value = "";
            try {
                value = AtsObjects.toString((String)"; ", (Collection)AtsApiService.get().getNotificationService().getJournalSubscribedUsers(this.workItem));
                this.valueLabel.setToolTipText(value);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                value = ex.getLocalizedMessage();
                this.valueLabel.setToolTipText(value);
            }
            this.valueLabel.setText(Strings.truncate((String)value, (int)300, (boolean)true));
            this.layout(true);
            this.getParent().layout(true);
        }
    }

    private boolean promptChangeJournalSubscribers(IAtsWorkItem workItem) {
        if (workItem.isCompleted()) {
            AWorkbench.popup((String)"ERROR", (String)("Can't subscribe to completed " + workItem.getArtifactTypeName() + " (" + workItem.getAtsId() + ")"));
            return false;
        }
        if (workItem.isCancelled()) {
            AWorkbench.popup((String)"ERROR", (String)("Can't subscribe to cancelled " + workItem.getArtifactTypeName() + " (" + workItem.getAtsId() + ")"));
            return false;
        }
        HashSet<AtsUser> users = new HashSet<AtsUser>();
        users.addAll(AtsApiService.get().getUserService().getUsers(Active.Active));
        Collection subscribedUsers = AtsApiService.get().getNotificationService().getJournalSubscribedUsers(workItem);
        users.addAll(subscribedUsers);
        users.remove(AtsCoreUsers.UNASSIGNED_USER);
        UserCheckTreeDialog uld = new UserCheckTreeDialog("Select Journal Subscribers", "Select to subscribe.\nDeSelect to un-subscribe.", users);
        uld.setIncludeAutoSelectButtons(false);
        IAtsTeamWorkflow parentWorklfow = workItem.getParentTeamWorkflow();
        if (parentWorklfow != null) {
            uld.setTeamMembers(AtsApiService.get().getTeamDefinitionService().getMembersAndLeads(parentWorklfow.getTeamDefinition()));
        }
        uld.setInitialSelections(subscribedUsers);
        if (uld.open() != 0) {
            return false;
        }
        Collection<AtsUser> selected = uld.getUsersSelected();
        AtsApiService.get().getNotificationService().setJournalSubscribedUsers(workItem, selected);
        return true;
    }
}

