/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.column.OriginatorColumn;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkArtifactImageProvider;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeOriginatorHeader
extends Composite {
    private static final String ORIGINATOR = "Originator:";
    private Label userIconLabel;
    private Label origLabel;
    private final IAtsWorkItem workItem;
    private Hyperlink origLink;
    private final WorkflowEditor editor;

    public WfeOriginatorHeader(Composite parent, int style, final IAtsWorkItem workItem, final WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.editor = editor;
        this.setLayoutData(new GridData());
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)3, (boolean)false));
        try {
            this.origLink = editor.getToolkit().createHyperlink((Composite)this, ORIGINATOR, 0);
            this.origLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        if (editor.isDirty()) {
                            editor.doSave(null);
                        }
                        OriginatorColumn.promptChangeOriginator(workItem, true);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
            this.userIconLabel = editor.getToolkit().createLabel((Composite)this, "");
            this.origLabel = editor.getToolkit().createLabel((Composite)this, "");
            this.origLabel.setLayoutData((Object)new GridData(768));
            this.refresh();
        }
        catch (OseeCoreException ex) {
            this.origLink.setText("Error: " + ex.getLocalizedMessage());
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refresh() {
        try {
            if (this.workItem.getCreatedBy() == null) {
                this.origLabel.setText("Error: No originator identified.");
                this.origLabel.setForeground(Displays.getSystemColor((int)3));
            } else {
                User origUser = UserManager.getUserByArtId((ArtifactId)this.workItem.getCreatedBy());
                this.userIconLabel.setImage(FrameworkArtifactImageProvider.getUserImage(Arrays.asList(origUser)));
                this.origLabel.setText(this.workItem.getCreatedBy().getName());
                this.origLabel.setForeground(Displays.getSystemColor((int)2));
            }
            this.origLabel.getParent().layout(true);
            this.origLabel.getParent().getParent().layout(true);
        }
        catch (OseeCoreException ex) {
            Label errorLabel = this.editor.getToolkit().createLabel((Composite)this, "Error: " + ex.getLocalizedMessage());
            errorLabel.setForeground(Displays.getSystemColor((int)3));
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }
}

