/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.OpenInAtsWorldAction;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.XRelatedWidget;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditor;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditorSimpleProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabel;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WfeRelatedComposite
extends Composite
implements XModifiedListener {
    private final WorkflowEditor editor;
    private final IAtsWorkItem workItem;
    private XRelatedWidget siblingWidget;
    private XRelatedWidget tasksWidget;
    private XRelatedWidget reviewsWidget;
    private XRelatedWidget parentTeamWfWidget;
    private XRelatedWidget parentActionWfWidget;
    private XRelatedWidget supportingWidget;
    private XRelatedWidget derivedFromWidget;
    private XRelatedWidget derivedToWidget;
    private final AtsApi atsApi;
    private final String SPACE = " ";

    public WfeRelatedComposite(Composite parent, int style, WorkflowEditor editor) {
        super(parent, style);
        this.editor = editor;
        this.workItem = editor.getWorkItem();
        this.atsApi = AtsApiService.get();
    }

    public void create() {
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)15, (boolean)false));
        GridData gd = new GridData(0, 0, false, false);
        this.setLayoutData(gd);
        this.editor.getToolkit().adapt((Composite)this);
        this.createRelated();
        this.refresh();
        this.layout(true, true);
        this.getParent().layout(true, true);
        this.editor.getWorkFlowTab().getManagedForm().reflow(true);
    }

    private void createRelated() {
        Collection derived;
        IAtsTeamWorkflow teamWf;
        Label label = new Label((Composite)this, 0);
        label.setText("Related: ");
        label.setBackground(Displays.getSystemColor((int)1));
        label.setFont(FontManager.getDefaultLabelFont());
        IAtsAction action = this.workItem.getParentAction();
        if (action != null) {
            this.parentActionWfWidget = new XRelatedWidget("Parent Action", this);
            this.parentActionWfWidget.setToolkit((FormToolkit)this.editor.getToolkit());
            this.parentActionWfWidget.setToolTip("Select to Open");
            this.parentActionWfWidget.setIncludeColon(false);
            this.parentActionWfWidget.createWidgets(this, 2);
            this.addSpaceWidget();
        }
        if ((this.workItem.isTask() || this.workItem.isReview()) && (teamWf = this.workItem.getParentTeamWorkflow()) != null) {
            this.parentTeamWfWidget = new XRelatedWidget("Parent Team WF", this);
            this.parentTeamWfWidget.setIncludeColon(false);
            this.parentTeamWfWidget.setToolTip("Select to Open");
            this.parentTeamWfWidget.setToolkit((FormToolkit)this.editor.getToolkit());
            this.parentTeamWfWidget.createWidgets(this, 2);
            this.addSpaceWidget();
        }
        if (this.workItem.isTeamWorkflow()) {
            this.siblingWidget = new XRelatedWidget("Siblings", this);
            this.siblingWidget.setToolkit((FormToolkit)this.editor.getToolkit());
            this.siblingWidget.setToolTip("Select to Open");
            this.siblingWidget.createWidgets(this, 2);
            this.addSpaceWidget();
            this.tasksWidget = new XRelatedWidget("Tasks", this);
            this.tasksWidget.setToolkit((FormToolkit)this.editor.getToolkit());
            this.tasksWidget.setToolTip("Select to Open");
            this.tasksWidget.createWidgets(this, 2);
            this.addSpaceWidget();
            this.reviewsWidget = new XRelatedWidget("Reviews", this);
            this.reviewsWidget.setToolkit((FormToolkit)this.editor.getToolkit());
            this.reviewsWidget.setToolTip("Select to Open");
            this.reviewsWidget.createWidgets(this, 2);
            this.addSpaceWidget();
        }
        this.supportingWidget = new XRelatedWidget("Supporting", this);
        this.supportingWidget.setToolkit((FormToolkit)this.editor.getToolkit());
        this.supportingWidget.setToolTip("Select to Open");
        this.supportingWidget.createWidgets(this, 2);
        this.addSpaceWidget();
        Collection derivedFrom = this.atsApi.getRelationResolver().getRelated((IAtsObject)this.workItem, AtsRelationTypes.Derive_From);
        if (!derivedFrom.isEmpty()) {
            this.derivedFromWidget = new XRelatedWidget("Derived From", this);
            this.derivedFromWidget.setToolkit((FormToolkit)this.editor.getToolkit());
            this.derivedFromWidget.setToolTip("Select to Open");
            this.derivedFromWidget.createWidgets(this, 2);
            this.addSpaceWidget();
        }
        if (!(derived = this.atsApi.getRelationResolver().getRelated((IAtsObject)this.workItem, AtsRelationTypes.Derive_To)).isEmpty()) {
            this.derivedToWidget = new XRelatedWidget("Derived", this);
            this.derivedToWidget.setToolkit((FormToolkit)this.editor.getToolkit());
            this.derivedToWidget.setToolTip("Select to Open");
            this.derivedToWidget.createWidgets(this, 2);
            this.addSpaceWidget();
        }
    }

    private void addSpaceWidget() {
        XLabel label = new XLabel(" ");
        label.createWidgets((Composite)this, 1);
        label.adaptControls(this.editor.getWorkFlowTab().getManagedForm().getToolkit());
    }

    public void widgetModified(XWidget widget) {
        IAtsAction action;
        if (this.parentActionWfWidget != null && widget.equals((Object)this.parentActionWfWidget) && (action = this.workItem.getParentAction()) != null) {
            new OpenInAtsWorldAction((AbstractWorkflowArtifact)this.workItem).run();
        }
        if (this.parentTeamWfWidget != null && widget.equals((Object)this.parentTeamWfWidget)) {
            IAtsTeamWorkflow teamWf = this.workItem.getParentTeamWorkflow();
            WorkflowEditor.edit((IAtsWorkItem)teamWf);
        }
        if (this.siblingWidget != null && widget.equals((Object)this.siblingWidget)) {
            new OpenInAtsWorldAction((AbstractWorkflowArtifact)this.workItem).run();
        }
        if (this.tasksWidget != null && widget.equals((Object)this.tasksWidget)) {
            Collection tasks = this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)this.workItem);
            if (tasks.isEmpty()) {
                AWorkbench.popup((String)"No Tasks Found");
                return;
            }
            TaskEditor.open(new TaskEditorSimpleProvider("Tasks for " + this.workItem.toStringWithAtsId(), Collections.castAll((Collection)tasks)));
        }
        if (this.reviewsWidget != null && widget.equals((Object)this.reviewsWidget)) {
            Collection reviews = this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)this.workItem);
            if (reviews.isEmpty()) {
                AWorkbench.popup((String)"No Reviews Found");
                return;
            }
            WorldEditor.open(new WorldEditorSimpleProvider("Reviews for " + this.workItem.toStringWithAtsId(), Collections.castAll((Collection)reviews)));
        }
        if (this.supportingWidget != null && widget.equals((Object)this.supportingWidget)) {
            Map<IRelationLink, Artifact> supporting = this.getSupporting();
            if (supporting.isEmpty()) {
                AWorkbench.popup((String)"No Supporting Items Found");
                return;
            }
            WorldEditor.open(new WorldEditorSimpleProvider("Supporting for " + this.workItem.toStringWithAtsId(), Collections.castAll(supporting.values())));
        }
        if (this.derivedFromWidget != null && widget.equals((Object)this.derivedFromWidget)) {
            Collection derivedFrom = this.atsApi.getRelationResolver().getRelated((IAtsObject)this.workItem, AtsRelationTypes.Derive_From);
            if (derivedFrom.isEmpty()) {
                AWorkbench.popup((String)"No Derived From Found");
                return;
            }
            if (derivedFrom.size() == 1) {
                WorkflowEditor.edit((IAtsWorkItem)derivedFrom.iterator().next());
            } else {
                WorldEditor.open(new WorldEditorSimpleProvider("Derived From " + this.workItem.toStringWithAtsId(), Collections.castAll((Collection)derivedFrom)));
            }
        }
        if (this.derivedToWidget != null && widget.equals((Object)this.derivedToWidget)) {
            Collection derivedTo = this.atsApi.getRelationResolver().getRelated((IAtsObject)this.workItem, AtsRelationTypes.Derive_To);
            if (derivedTo.isEmpty()) {
                AWorkbench.popup((String)"No Derived To Found");
                return;
            }
            if (derivedTo.size() == 1) {
                WorkflowEditor.edit((IAtsWorkItem)derivedTo.iterator().next());
            } else {
                WorldEditor.open(new WorldEditorSimpleProvider("Derived To From " + this.workItem.toStringWithAtsId(), Collections.castAll((Collection)derivedTo)));
            }
        }
    }

    private Map<IRelationLink, Artifact> getSupporting() {
        HashSet supportingLink = new HashSet();
        supportingLink.addAll(this.atsApi.getRelationResolver().getRelations((ArtifactId)this.workItem.getStoreObject(), CoreRelationTypes.SupportingInfo_SupportingInfo));
        supportingLink.addAll(this.atsApi.getRelationResolver().getRelations((ArtifactId)this.workItem.getStoreObject(), CoreRelationTypes.SupportingInfo_IsSupportedBy));
        HashMap<IRelationLink, Artifact> supporting = new HashMap<IRelationLink, Artifact>();
        for (IRelationLink iLink : supportingLink) {
            Artifact otherArt;
            RelationLink link = (RelationLink)iLink;
            if (this.workItem.getArtifactId().equals(link.getArtifactIdA())) {
                otherArt = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)link.getArtifactB());
                supporting.put((IRelationLink)link, otherArt);
                continue;
            }
            otherArt = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)link.getArtifactA());
            supporting.put((IRelationLink)link, otherArt);
        }
        return supporting;
    }

    public Collection<XWidget> getXWidgets(ArrayList<XWidget> widgets) {
        if (this.siblingWidget != null) {
            widgets.add((XWidget)this.siblingWidget);
        }
        if (this.tasksWidget != null) {
            widgets.add((XWidget)this.tasksWidget);
        }
        if (this.reviewsWidget != null) {
            widgets.add((XWidget)this.reviewsWidget);
        }
        if (this.parentActionWfWidget != null) {
            widgets.add((XWidget)this.parentActionWfWidget);
        }
        if (this.parentTeamWfWidget != null) {
            widgets.add((XWidget)this.parentTeamWfWidget);
        }
        if (this.siblingWidget != null) {
            widgets.add((XWidget)this.siblingWidget);
        }
        return widgets;
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this)) {
            if (this.workItem.isTeamWorkflow()) {
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)this.workItem;
                Collection workflows = this.atsApi.getActionService().getSiblingTeamWorkflows(teamWf);
                this.siblingWidget.setCurrentValue(String.valueOf(workflows.size()));
                this.siblingWidget.refresh();
                this.tasksWidget.setCurrentValue(String.valueOf(this.atsApi.getTaskService().getTasks(teamWf).size()));
                this.tasksWidget.refresh();
                this.reviewsWidget.setCurrentValue(String.valueOf(this.atsApi.getReviewService().getReviews(teamWf).size()));
                this.reviewsWidget.refresh();
            }
            if (this.supportingWidget != null) {
                Map<IRelationLink, Artifact> supporting = this.getSupporting();
                this.supportingWidget.setCurrentValue(String.valueOf(supporting.size()));
                this.supportingWidget.refresh();
            }
            if (this.derivedFromWidget != null) {
                Collection derivedFrom = this.atsApi.getRelationResolver().getRelated((IAtsObject)this.workItem, AtsRelationTypes.Derive_From);
                this.derivedFromWidget.setCurrentValue(String.valueOf(derivedFrom.size()));
                this.derivedFromWidget.refresh();
            }
            if (this.derivedToWidget != null) {
                Collection derivedTo = this.atsApi.getRelationResolver().getRelated((IAtsObject)this.workItem, AtsRelationTypes.Derive_To);
                this.derivedToWidget.setCurrentValue(String.valueOf(derivedTo.size()));
                this.derivedToWidget.refresh();
            }
        }
    }
}

