/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.WfeWorkFlowTab;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeDragAndDrop;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.AbstractArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.sections.RelationsFormSection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WfeRelationsSection
extends RelationsFormSection {
    IAtsWorkItem workItem;
    private static ViewerFilter userRelationsFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof RelationTypeToken) {
                return !filteredRelationTypeNames.contains(((RelationTypeToken)element).getName());
            }
            return true;
        }
    };
    private static List<String> filteredRelationTypeNames = Arrays.asList(AtsRelationTypes.ActionToWorkflow_Action.getName(), AtsRelationTypes.TeamWfToTask_TeamWorkflow.getName(), AtsRelationTypes.TeamActionableItem_ActionableItem.getName(), AtsRelationTypes.TeamWorkflowTargetedForVersion_Version.getName(), AtsRelationTypes.TeamLead_Lead.getName(), AtsRelationTypes.TeamMember_Member.getName(), AtsRelationTypes.TeamWorkflowToReview_Review.getName(), CoreRelationTypes.DefaultHierarchical_Child.getName(), CoreRelationTypes.Users_Artifact.getName());

    public WfeRelationsSection(WorkflowEditor editor, Composite parent, FormToolkit toolkit, int style) {
        super((AbstractArtifactEditor)editor, parent, toolkit, style | 2 | 0x100, true);
        this.workItem = editor.getWorkItem();
    }

    public WorkflowEditor getEditor() {
        return (WorkflowEditor)super.getEditor();
    }

    protected synchronized void createSection(Section section, FormToolkit toolkit) {
        super.createSection(section, toolkit);
        if (!AtsApiService.get().getUserService().isAtsAdmin()) {
            this.getRelationComposite().getTreeViewer().addFilter(userRelationsFilter);
        }
    }

    protected void handleExpandAndCollapse() {
        if (this.getEditor().getSelectedPage() != null) {
            ((WfeWorkFlowTab)this.getEditor().getSelectedPage()).getManagedForm().getForm().layout();
        }
    }

    protected void addDragAndDrop(Control dropArea) {
        new WfeDragAndDrop(dropArea, (AbstractWorkflowArtifact)this.getEditorInput().getArtifact(), "org.eclipse.osee.ats.ide.editor.WorkflowEditor");
    }

    public boolean isDisposed() {
        return this.getRelationComposite() == null || this.getRelationComposite().isDisposed();
    }
}

