/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SavedActionSearchNavigateItem;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public final class SaveAsSearchAction
extends Action {
    private final AtsSearchWorkflowSearchItem searchItem;

    public SaveAsSearchAction(AtsSearchWorkflowSearchItem searchItem) {
        this.searchItem = searchItem;
    }

    public String getText() {
        return "Save As Search";
    }

    public String getToolTipText() {
        return "Enter search criteria and select to save as";
    }

    public void run() {
        EntryDialog dialog = new EntryDialog("Save Search As", "Save Search?\n\nSearch Name");
        if (dialog.open() == 0) {
            if (!Strings.isValid((String)dialog.getEntry())) {
                AWorkbench.popup((String)"Invalid Search Name");
                return;
            }
            this.searchItem.setSearchName(dialog.getEntry());
            this.searchItem.setSearchId(Lib.generateId());
            String namespace = this.searchItem.getNamespace();
            AtsSearchData data = AtsApiService.get().getQueryService().createSearchData(namespace, this.searchItem.getSearchName());
            this.searchItem.loadSearchData(data);
            if (data.getId() <= 0L) {
                data.setId(Lib.generateArtifactIdAsInt().longValue());
            }
            Conditions.checkExpressionFailOnTrue((data.getId() <= 0L ? 1 : 0) != 0, (String)"searchId must be > 0, not %d", (Object[])new Object[]{data.getId()});
            Conditions.checkNotNullOrEmpty((String)data.getSearchName(), (String)"New Search Name");
            AtsApiService.get().getQueryService().saveSearch(data);
            SavedActionSearchNavigateItem.refreshItems();
            AWorkbench.popupf((String)"Search Saved as [%s]", (Object[])new Object[]{data.getSearchName()});
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.SAVE_AS);
    }
}

