/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkWfdForRelatedState;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;

public class XHyperlinkWfdForRelatedStateDam
extends XHyperlinkWfdForRelatedState
implements AttributeWidget {
    private static final String CLEAR = "-- clear --";
    private Artifact artifact;
    private AttributeTypeToken attributeTypeToken;

    public XHyperlinkWfdForRelatedStateDam() {
        super(Collections.emptyList());
    }

    public void handleSelectionPersist(String selected) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Set Related State");
        if (selected.equals(CLEAR)) {
            changes.deleteAttributes((ArtifactId)this.artifact, this.attributeTypeToken);
        } else {
            changes.setSoleAttributeValue((ArtifactId)this.artifact, this.attributeTypeToken, (Object)selected);
        }
        changes.executeIfNeeded();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeTypeToken) {
        this.artifact = artifact;
        this.attributeTypeToken = attributeTypeToken;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeTypeToken;
    }

    @Override
    public Collection<String> getSelectable() {
        IAtsTeamWorkflow teamWf;
        if (this.artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact}) && (teamWf = ((IAtsWorkItem)this.artifact).getParentTeamWorkflow()) != null) {
            Collection stateNames = AtsApiService.get().getWorkDefinitionService().getStateNames(teamWf.getWorkDefinition());
            stateNames.add(CLEAR);
            return stateNames;
        }
        return Collections.emptyList();
    }

    public String getCurrentValue() {
        if (this.artifact == null) {
            return "Not Set";
        }
        return this.artifact.getSoleAttributeValueAsString(this.attributeTypeToken, "Not Set");
    }
}

