/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionUtil;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.IsEnabled;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateFilteredTreeViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeListener;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ActionableItemCheckboxStateDialog
extends EntryDialog
implements IsEnabled {
    private final Collection<IAtsActionableItem> selectedAis;
    private final Collection<IAtsActionableItem> ais;
    private CheckBoxStateFilteredTreeViewer<IAtsActionableItem> treeViewer;

    public ActionableItemCheckboxStateDialog(String dialogTitle, String dialogMessage, Collection<IAtsActionableItem> ais) {
        super(dialogTitle, dialogMessage);
        this.ais = ais;
        this.selectedAis = new HashSet<IAtsActionableItem>();
    }

    protected void createExtendedArea(Composite parent) {
        this.text.dispose();
        Composite comboComp = new Composite(parent, 0);
        comboComp.setLayout((Layout)new GridLayout(6, false));
        GridData gd = new GridData(1536);
        gd.widthHint = 750;
        gd.horizontalSpan = 2;
        comboComp.setLayoutData((Object)gd);
        this.createAisSelection(parent);
    }

    private void createAisSelection(Composite parent) {
        Pair<CheckBoxStateFilteredTreeViewer<IAtsActionableItem>, Text> results = NewActionUtil.createActionableItemTreeViewer(parent, null);
        this.treeViewer = (CheckBoxStateFilteredTreeViewer)results.getFirst();
        this.treeViewer.setEnabledChecker((IsEnabled)this);
        this.treeViewer.addCheckListener(new ICheckBoxStateTreeListener(){

            public void checkStateNodesChanged() {
                ActionableItemCheckboxStateDialog.this.selectedAis.clear();
                for (Object obj : ActionableItemCheckboxStateDialog.this.treeViewer.getChecked()) {
                    ActionableItemCheckboxStateDialog.this.selectedAis.add((IAtsActionableItem)obj);
                }
                ActionableItemCheckboxStateDialog.this.handleModified();
            }
        });
        this.treeViewer.getViewer().setInput(this.ais);
    }

    public Set<IAtsActionableItem> getSelectedActionableItems() {
        HashSet<IAtsActionableItem> selected = new HashSet<IAtsActionableItem>();
        for (Object obj : this.treeViewer.getChecked()) {
            selected.add((IAtsActionableItem)obj);
        }
        return selected;
    }

    public boolean isEntryValid() {
        if (!super.isEntryValid()) {
            return false;
        }
        if (this.treeViewer != null) {
            if (this.selectedAis.isEmpty()) {
                this.setErrorString("Must select Actionable Item");
                return false;
            }
            if (this.selectedAis.size() > 1) {
                this.setErrorString("Only select 1 Actionable Item");
                return false;
            }
            IAtsActionableItem ai = this.selectedAis.iterator().next();
            IAtsTeamDefinition teamDef = ai.getAtsApi().getActionableItemService().getTeamDefinitionInherited(ai);
            if (teamDef == null) {
                AWorkbench.popup((String)"No related Team Definition for selected Actionable Item.  Choose another");
                this.treeViewer.setChecked((Object)ai, false);
            }
        }
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.handleModified();
        return control;
    }

    public boolean isEnabled(Object obj) {
        if (obj instanceof IAtsActionableItem) {
            return ((IAtsActionableItem)obj).isActive() && ((IAtsActionableItem)obj).isActionable();
        }
        return false;
    }
}

