/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.search.UserSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class UserRelatedToAtsObjectSearch
extends UserSearchItem {
    private final boolean activeObjectsOnly;

    public UserRelatedToAtsObjectSearch(String name, AtsUser user, boolean activeObjectsOnly, WorldSearchItem.LoadView loadView) {
        super(name, user);
        this.activeObjectsOnly = activeObjectsOnly;
        this.setLoadView(loadView);
        this.setActive(Active.Both);
    }

    public UserRelatedToAtsObjectSearch(UserRelatedToAtsObjectSearch userRelatedToAtsObjectSearch) {
        super(userRelatedToAtsObjectSearch);
        this.activeObjectsOnly = userRelatedToAtsObjectSearch.activeObjectsOnly;
        this.setActive(Active.Both);
    }

    @Override
    protected Collection<Artifact> searchIt(AtsUser atsUser) {
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        ArrayList arts = new ArrayList();
        if (this.activeObjectsOnly) {
            arts.addAll(ArtifactQuery.getArtifactListFromAttributeKeywords((BranchId)AtsApiService.get().getAtsBranch(), (String)this.user.getUserId(), (boolean)false, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED, (boolean)false, (AttributeTypeId[])new AttributeTypeId[]{AtsAttributeTypes.CurrentState}));
        } else {
            arts.addAll(ArtifactQuery.getArtifactListFromAttributeKeywords((BranchId)AtsApiService.get().getAtsBranch(), (String)this.user.getUserId(), (boolean)false, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED, (boolean)false, (AttributeTypeId[])new AttributeTypeId[]{AtsAttributeTypes.CurrentState, AtsAttributeTypes.State, AtsAttributeTypes.Log}));
        }
        arts.addAll(AtsApiService.get().getRelationResolver().getRelated((IAtsObject)this.user, AtsRelationTypes.TeamLead_Team));
        arts.addAll(AtsApiService.get().getRelationResolver().getRelated((IAtsObject)this.user, AtsRelationTypes.TeamMember_Team));
        arts.addAll(AtsApiService.get().getRelationResolver().getRelated((IAtsObject)this.user, AtsRelationTypes.FavoriteUser_Artifact));
        arts.addAll(AtsApiService.get().getRelationResolver().getRelated((IAtsObject)this.user, AtsRelationTypes.SubscribedUser_Artifact));
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        return Collections.castAll(arts);
    }

    @Override
    public WorldUISearchItem copy() {
        return new UserRelatedToAtsObjectSearch(this);
    }
}

