/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookReader;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookWriter;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.MimImportApi;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.MimImportSummary;
import org.eclipse.osee.mim.types.PlatformTypeImportToken;

public class PlatformTypeImportApiImpl
implements MimImportApi {
    private final ExcelWorkbookReader reader;
    private final MimApi mimApi;
    private MimImportSummary summary;
    private Long id = 1L;

    public PlatformTypeImportApiImpl(InputStream inputStream, MimApi mimApi) {
        this.reader = new ExcelWorkbookReader(inputStream, ExcelWorkbookWriter.WorkbookFormat.XLSX);
        this.mimApi = mimApi;
    }

    @Override
    public MimImportSummary getSummary() {
        this.summary = new MimImportSummary();
        this.reader.setActiveSheet(0);
        HashMap<String, PlatformTypeImportToken> platformTypes = new HashMap<String, PlatformTypeImportToken>();
        LinkedList<String> usedNames = new LinkedList<String>();
        int rowIndex = 1;
        while (this.reader.rowExists(rowIndex)) {
            String name = this.reader.getCellStringValue(rowIndex, 1);
            int bitSize = (int)this.reader.getCellNumericValue(rowIndex, 2);
            String logicalType = this.reader.getCellStringValue(rowIndex, 3);
            String minVal = this.reader.getCellStringValue(rowIndex, 4);
            String maxVal = this.reader.getCellStringValue(rowIndex, 5);
            String defaultVal = this.reader.getCellStringValue(rowIndex, 6);
            String units = this.reader.getCellStringValue(rowIndex, 7);
            String validRange = this.reader.getCellStringValue(rowIndex, 14);
            String description = this.reader.getCellStringValue(rowIndex, 15);
            String suggestedName = this.reader.getCellStringValue(rowIndex, 16);
            if (!logicalType.equals("boolean")) {
                if (logicalType.equals("enumeration")) {
                    String[] enumerations;
                    PlatformTypeImportToken pType = new PlatformTypeImportToken(this.id, name, logicalType, String.valueOf(bitSize), minVal, maxVal, units, description, defaultVal, validRange);
                    this.incrementId();
                    this.summary.getPlatformTypes().add(pType);
                    InterfaceEnumerationSet enumSet = new InterfaceEnumerationSet(this.id, name);
                    enumSet.setDescription(description);
                    enumSet.setApplicability(ApplicabilityToken.BASE);
                    this.incrementId();
                    this.summary.getEnumSets().add(enumSet);
                    this.summary.getPlatformTypeEnumSetRelations().put(pType.getIdString(), new LinkedList<String>(Arrays.asList(enumSet.getIdString())));
                    String[] stringArray = enumerations = description.split("\n");
                    int n = enumerations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String enumeration = stringArray[n2];
                        String[] split = enumeration.split(" = ");
                        if (!enumeration.isEmpty() && split.length >= 2) {
                            InterfaceEnumeration enumToken = new InterfaceEnumeration(this.id, split[1]);
                            enumToken.setOrdinal(Integer.parseInt(split[0]));
                            enumToken.setApplicability(ApplicabilityToken.BASE);
                            this.incrementId();
                            this.summary.getEnums().add(enumToken);
                            List rels = this.summary.getEnumSetEnumRelations().getOrDefault(enumSet.getIdString(), new LinkedList());
                            rels.add(enumToken.getIdString());
                            this.summary.getEnumSetEnumRelations().put(enumSet.getIdString(), rels);
                        }
                        ++n2;
                    }
                } else {
                    String[] range = validRange.replace("---", "").replace("--", "").split(" - ");
                    if (range.length == 1) {
                        range = range[0].split(" to ");
                    }
                    validRange = range.length == 2 ? String.valueOf(range[0]) + " to " + range[1] : range[0].trim();
                    String ident = this.mimApi.getInterfacePlatformTypeApi().getUniqueIdentifier(logicalType, minVal, maxVal, validRange, units, bitSize);
                    if (!suggestedName.isEmpty() && !platformTypes.containsKey(ident)) {
                        if (usedNames.contains(suggestedName)) {
                            suggestedName = String.valueOf(suggestedName) + "_" + this.id;
                        }
                        PlatformTypeImportToken pType = new PlatformTypeImportToken(this.id, suggestedName, logicalType, String.valueOf(bitSize), minVal, maxVal, units, description, defaultVal, validRange);
                        this.incrementId();
                        this.summary.getPlatformTypes().add(pType);
                        platformTypes.put(ident, pType);
                        usedNames.add(suggestedName);
                    }
                }
            }
            ++rowIndex;
        }
        return this.summary;
    }

    private void incrementId() {
        this.id = this.id + 1L;
    }
}

