/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.handlers;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaAttribute;
import org.eclipse.osee.orcs.db.internal.loader.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class AttributeSqlHandler
extends SqlHandler<CriteriaAttribute> {
    private CriteriaAttribute criteria;
    private String jIdAlias;
    private String jTypeIdAlias;
    private String jArtAlias;
    private String attrAlias;
    private String txsAlias;
    private AbstractJoinQuery joinIdQuery;
    private AbstractJoinQuery joinTypeQuery;

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_LOADER.ordinal();
    }

    @Override
    public void setData(CriteriaAttribute criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        writer.writeCommaIfNotFirst();
        writer.write("%s.attr_id, %s.attr_type_id, %s.value, %s.uri", this.attrAlias, this.attrAlias, this.attrAlias, this.attrAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.jArtAlias = writer.addTable(OseeDb.OSEE_JOIN_ID4_TABLE);
        if (this.criteria.getIds().size() > 1) {
            this.jIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        if (this.criteria.getTypes().size() > 1) {
            this.jTypeIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        this.attrAlias = writer.addTable(OseeDb.ATTRIBUTE_TABLE);
        this.txsAlias = writer.addTable(OseeDb.TXS_TABLE, ObjectType.ATTRIBUTE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        Collection<? extends AttributeTypeId> types;
        writer.write(this.attrAlias);
        writer.write(".art_id = ");
        writer.write(this.jArtAlias);
        writer.write(".id2");
        writer.writeAnd();
        writer.write(this.jArtAlias);
        writer.write(".query_id = ?");
        writer.addParameter(this.criteria.getQueryId());
        Collection<AttributeId> ids = this.criteria.getIds();
        if (!ids.isEmpty()) {
            writer.writeAnd();
            if (ids.size() > 1) {
                this.joinIdQuery = writer.writeJoin(ids);
                writer.write(this.attrAlias);
                writer.write(".attr_id = ");
                writer.write(this.jIdAlias);
                writer.write(".id");
                writer.writeAnd();
                writer.write(this.jIdAlias);
                writer.write(".query_id = ?");
                writer.addParameter(this.joinIdQuery.getQueryId());
            } else {
                writer.write(this.attrAlias);
                writer.write(".attr_id = ?");
                writer.addParameter(ids.iterator().next());
            }
        }
        if (!(types = this.criteria.getTypes()).isEmpty()) {
            writer.writeAnd();
            if (types.size() > 1) {
                this.joinTypeQuery = writer.writeJoin(types);
                writer.write(this.attrAlias);
                writer.write(".attr_type_id = ");
                writer.write(this.jTypeIdAlias);
                writer.write(".id");
                writer.writeAnd();
                writer.write(this.jTypeIdAlias);
                writer.write(".query_id = ?");
                writer.addParameter(this.joinTypeQuery.getQueryId());
            } else {
                writer.write(this.attrAlias);
                writer.write(".attr_type_id = ?");
                writer.addParameter(types.iterator().next());
            }
        }
        writer.writeAnd();
        writer.write(this.attrAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id");
        writer.writeAndLn();
        writer.writeTxBranchFilter(this.txsAlias);
    }
}

