/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeSort;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class AttributeSortSqlHandler
extends SqlHandler<CriteriaAttributeSort> {
    private String txsAlias;
    private String attrAlias;
    private CriteriaAttributeSort criteria;

    @Override
    public void setData(CriteriaAttributeSort criteria) {
        this.criteria = criteria;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_SORT.ordinal();
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        writer.writeCommaIfNotFirst();
        writer.write(this.attrAlias);
        writer.write(".value order_value");
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.txsAlias = writer.addTable(OseeDb.TXS_TABLE, ObjectType.ATTRIBUTE);
        this.attrAlias = writer.addTable(OseeDb.ATTRIBUTE_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeTxBranchFilter(this.txsAlias);
        writer.write(" ");
        writer.writeAnd();
        writer.writeEqualsAnd(this.attrAlias, this.txsAlias, "gamma_id");
        List<String> aliases = writer.getAliases(OseeDb.ARTIFACT_TABLE);
        if (!aliases.isEmpty()) {
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(this.attrAlias);
                writer.write(".art_id = ");
                writer.write(artAlias);
                writer.write(".art_id");
                if (index + 1 < aSize) {
                    writer.writeAnd();
                }
                ++index;
            }
            writer.writeAndLn();
        }
        writer.write(this.attrAlias);
        writer.write(".attr_type_id = ");
        writer.write(String.valueOf(this.criteria.getAttributeTypeId()));
    }
}

