/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.BranchCategoryData;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.OrcsVisitor;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionWriter;
import org.eclipse.osee.orcs.db.internal.transaction.TxSqlBuilder;

public class TxSqlBuilderImpl
implements OrcsVisitor,
TxSqlBuilder {
    private final SqlJoinFactory sqlJoinFactory;
    private final IdentityManager idManager;
    private final JdbcClient jdbcClient;
    private TransactionToken txId;
    private List<DataProxy<?>> binaryStores;
    private HashCollection<TransactionWriter.SqlOrderEnum, Object[]> dataItemInserts;
    private Map<TransactionWriter.SqlOrderEnum, IdJoinQuery> txNotCurrentsJoin;
    private Map<TransactionWriter.SqlOrderEnum, Id4JoinQuery> txNotCurrentsJoin4;

    public TxSqlBuilderImpl(SqlJoinFactory sqlJoinFactory, IdentityManager idManager, JdbcClient jdbcClient) {
        this.sqlJoinFactory = sqlJoinFactory;
        this.idManager = idManager;
        this.jdbcClient = jdbcClient;
        this.clear();
    }

    @Override
    public Set<Map.Entry<TransactionWriter.SqlOrderEnum, IdJoinQuery>> getTxNotCurrents() {
        return this.txNotCurrentsJoin != null ? this.txNotCurrentsJoin.entrySet() : Collections.emptySet();
    }

    @Override
    public Set<Map.Entry<TransactionWriter.SqlOrderEnum, Id4JoinQuery>> getTxNotCurrents4() {
        return this.txNotCurrentsJoin4 != null ? this.txNotCurrentsJoin4.entrySet() : Collections.emptySet();
    }

    @Override
    public List<Object[]> getInsertData(TransactionWriter.SqlOrderEnum key) {
        List toReturn = null;
        if (this.dataItemInserts != null) {
            toReturn = (List)this.dataItemInserts.getValues((Object)key);
        }
        return toReturn != null ? toReturn : Collections.emptyList();
    }

    @Override
    public List<DataProxy<?>> getBinaryStores() {
        return this.binaryStores != null ? this.binaryStores : Collections.emptyList();
    }

    @Override
    public void clear() {
        this.txId = TransactionToken.SENTINEL;
        this.dataItemInserts = null;
        this.txNotCurrentsJoin = null;
        this.binaryStores = null;
    }

    @Override
    public void accept(TransactionReadable tx, OrcsChangeSet changeSet) {
        this.txId = tx;
        this.binaryStores = new ArrayList();
        this.dataItemInserts = new HashCollection();
        this.txNotCurrentsJoin = new HashMap<TransactionWriter.SqlOrderEnum, IdJoinQuery>();
        this.txNotCurrentsJoin4 = new HashMap<TransactionWriter.SqlOrderEnum, Id4JoinQuery>();
        this.addRow(TransactionWriter.SqlOrderEnum.TXS_DETAIL, tx.getBranch(), this.txId, tx.getAuthor(), tx.getDate(), tx.getComment(), tx.getTxType(), -1, OseeCodeVersion.getVersionId());
        changeSet.accept((OrcsVisitor)this);
    }

    public void visit(ArtifactData data) {
        boolean isOtherChange = !data.getVersion().isInStorage() || data.hasTypeUuidChange() || data.hasModTypeChange() || data.isExistingVersionUsed();
        boolean isApplicOnly = data.getDirtyState().isApplicOnly();
        if (!this.isNewAndDeleted((OrcsData)data) && (isOtherChange || isApplicOnly)) {
            boolean reuseGamma = this.reuseGamma((OrcsData)data);
            this.updateTxValues((OrcsData)data);
            if (!isApplicOnly && !reuseGamma) {
                this.updateGamma((OrcsData)data);
                this.addRow(TransactionWriter.SqlOrderEnum.ARTIFACTS, data.getId(), data.getVersion().getGammaId(), data.getType(), data.getGuid());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.ARTIFACTS, (OrcsData)data);
        }
    }

    public <T> void visit(AttributeData<T> data) {
        if (!this.isNewAndDeleted((OrcsData)data)) {
            boolean createNewGamma = !this.reuseGamma((OrcsData)data);
            this.updateTxValues((OrcsData)data);
            if (createNewGamma && !data.getDirtyState().isApplicOnly()) {
                this.updateGamma((OrcsData)data);
                DataProxy dataProxy = data.getDataProxy();
                dataProxy.setGamma(data.getVersion().getGammaId(), createNewGamma);
                this.binaryStores.add(dataProxy);
                if (data.isInvalid()) {
                    AttributeId id = this.idManager.getNextAttributeId();
                    data.setLocalId((Id)id);
                }
                this.addRow(TransactionWriter.SqlOrderEnum.ATTRIBUTES, data.getId(), data.getVersion().getGammaId(), data.getArtifactId(), data.getType(), dataProxy.getStorageString(), dataProxy.getUri());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.ATTRIBUTES, (OrcsData)data);
        }
    }

    public void visit(TupleData data) {
        this.updateTxValues((OrcsData)data);
        TupleTypeId tupleType = data.getTupleType();
        if (tupleType instanceof Tuple2Type) {
            if (!data.isExistingVersionUsed()) {
                this.addRow(TransactionWriter.SqlOrderEnum.TUPLES2, tupleType, data.getElement1(), data.getElement2(), data.getVersion().getGammaId());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.TUPLES2, (OrcsData)data);
        } else if (tupleType instanceof Tuple3Type) {
            if (!data.isExistingVersionUsed()) {
                this.addRow(TransactionWriter.SqlOrderEnum.TUPLES3, tupleType, data.getElement1(), data.getElement2(), data.getElement3(), data.getVersion().getGammaId());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.TUPLES3, (OrcsData)data);
        } else {
            if (!data.isExistingVersionUsed()) {
                this.addRow(TransactionWriter.SqlOrderEnum.TUPLES4, tupleType, data.getElement1(), data.getElement2(), data.getElement3(), data.getElement4(), data.getVersion().getGammaId());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.TUPLES4, (OrcsData)data);
        }
    }

    public void deleteTuple(BranchId branch, SqlTable tupleTable, GammaId gammaId) {
        TransactionWriter.SqlOrderEnum sqlEnum;
        if (tupleTable.equals(OseeDb.TUPLE2)) {
            sqlEnum = TransactionWriter.SqlOrderEnum.TUPLES2;
        } else if (tupleTable.equals(OseeDb.TUPLE3)) {
            sqlEnum = TransactionWriter.SqlOrderEnum.TUPLES3;
        } else if (tupleTable.equals(OseeDb.TUPLE4)) {
            sqlEnum = TransactionWriter.SqlOrderEnum.TUPLES4;
        } else {
            throw new OseeStateException("Unexpected table enum [%s]", new Object[]{tupleTable});
        }
        this.deleteTuple(branch, sqlEnum, gammaId);
    }

    private void deleteTuple(BranchId branch, TransactionWriter.SqlOrderEnum tupleTable, GammaId gammaId) {
        ApplicabilityId applicability = (ApplicabilityId)this.jdbcClient.fetch((Object)ApplicabilityId.SENTINEL, "SELECT app_id from osee_txs where branch_id = ? and gamma_id = ?", new Object[]{branch, gammaId});
        if (applicability.isInvalid()) {
            throw new ItemDoesNotExist("Tuple not found on branch [%s] with gammaId [%s]", new Object[]{branch, gammaId});
        }
        this.addRow(TransactionWriter.SqlOrderEnum.TXS, branch, gammaId, this.txId, TxCurrent.DELETED, ModificationType.DELETED, applicability);
        IdJoinQuery join = this.txNotCurrentsJoin.get((Object)tupleTable);
        if (join == null) {
            join = this.createJoin();
            this.txNotCurrentsJoin.put(tupleTable, join);
        }
        join.add((Id)gammaId);
    }

    public void deleteBranchCategory(BranchId branch, GammaId gammaId) {
        ApplicabilityId applicability = (ApplicabilityId)this.jdbcClient.fetch((Object)ApplicabilityId.SENTINEL, "SELECT app_id from osee_txs where branch_id = ? and gamma_id = ?", new Object[]{branch, gammaId});
        this.addRow(TransactionWriter.SqlOrderEnum.TXS, this.txId, gammaId, ModificationType.DELETED, TxCurrent.DELETED, branch, applicability);
        IdJoinQuery join = this.txNotCurrentsJoin.get((Object)TransactionWriter.SqlOrderEnum.BRANCH_CATEGORY);
        if (join == null) {
            join = this.createJoin();
            this.txNotCurrentsJoin.put(TransactionWriter.SqlOrderEnum.BRANCH_CATEGORY, join);
        }
        join.add((Id)gammaId);
    }

    public void visit(BranchCategoryData data) {
        this.updateTxValues((OrcsData)data);
        if (!data.isExistingVersionUsed()) {
            this.addRow(TransactionWriter.SqlOrderEnum.BRANCH_CATEGORY, data.getBranchId(), data.getCategory(), data.getVersion().getGammaId());
        }
        this.addTxs(TransactionWriter.SqlOrderEnum.BRANCH_CATEGORY, (OrcsData)data);
    }

    @Override
    public void updateAfterBinaryStorePersist() {
        List<Object[]> insertData = this.getInsertData(TransactionWriter.SqlOrderEnum.ATTRIBUTES);
        int index = 0;
        while (index < this.binaryStores.size() && index < insertData.size()) {
            DataProxy<?> proxy = this.binaryStores.get(index);
            Object[] rowData = insertData.get(index);
            int end = rowData.length;
            rowData[end - 2] = proxy.getStorageString();
            rowData[end - 1] = proxy.getUri();
            ++index;
        }
    }

    public void visit(RelationData data) {
        if (!this.isNewAndDeleted((OrcsData)data)) {
            boolean reuseGamma = this.reuseGamma((OrcsData)data);
            this.updateTxValues((OrcsData)data);
            if (!reuseGamma && !data.getDirtyState().isApplicOnly()) {
                this.updateGamma((OrcsData)data);
                if (data.isInvalid()) {
                    RelationId id = this.idManager.getNextRelationId();
                    data.setLocalId((Id)id);
                }
                if (((RelationTypeToken)data.getType()).isNewRelationTable()) {
                    this.addRow(TransactionWriter.SqlOrderEnum.RELATIONS2, data.getType(), data.getArtifactIdA(), data.getArtifactIdB(), data.getRelationArtifact(), data.getRelOrder(), data.getVersion().getGammaId());
                } else {
                    this.addRow(TransactionWriter.SqlOrderEnum.RELATIONS, data.getType(), data.getArtifactIdA(), data.getArtifactIdB(), data.getVersion().getGammaId(), data.getId(), data.getRationale());
                }
            }
            if (((RelationTypeToken)data.getType()).isNewRelationTable()) {
                this.addTxs(TransactionWriter.SqlOrderEnum.RELATIONS2, (OrcsData)data);
            } else {
                this.addTxs(TransactionWriter.SqlOrderEnum.RELATIONS, (OrcsData)data);
            }
        }
    }

    private void addTxs(TransactionWriter.SqlOrderEnum key, OrcsData orcsData) {
        VersionData data = orcsData.getVersion();
        ModificationType modType = orcsData.getModType();
        this.addRow(TransactionWriter.SqlOrderEnum.TXS, this.txId.getBranch(), data.getGammaId(), this.txId, TxCurrent.getCurrent((ModificationType)modType), modType, orcsData.getApplicabilityId());
        if (key.hasTxNotCurrentQuery()) {
            if (key.toString().equals("RELATIONS2")) {
                Id4JoinQuery join4 = this.txNotCurrentsJoin4.get((Object)key);
                if (join4 == null) {
                    join4 = this.sqlJoinFactory.createId4JoinQuery();
                    this.txNotCurrentsJoin4.put(key, join4);
                }
                join4.add(((RelationData)orcsData).getType(), (Id)((RelationData)orcsData).getArtifactIdA(), (Id)((RelationData)orcsData).getArtifactIdB());
            } else {
                IdJoinQuery join = this.txNotCurrentsJoin.get((Object)key);
                if (join == null) {
                    join = this.createJoin();
                    this.txNotCurrentsJoin.put(key, join);
                }
                if (key.toString().startsWith("TUPLE") || key.toString().equals("BRANCH_CATEGORY")) {
                    join.add((Id)orcsData.getVersion().getGammaId());
                } else {
                    join.add(orcsData.getLocalId());
                }
            }
        }
    }

    private boolean isNewAndDeleted(OrcsData data) {
        return !data.getVersion().isInStorage() && data.getModType().isDeleted();
    }

    private void updateTxValues(OrcsData orcsData) {
        orcsData.setModType(this.computeModType(orcsData.getModType()));
        orcsData.getVersion().setTransactionId((TransactionId)this.txId);
    }

    private void updateGamma(OrcsData data) {
        VersionData version = data.getVersion();
        version.setGammaId(this.idManager.getNextGammaId());
    }

    private ModificationType computeModType(ModificationType original) {
        ModificationType toReturn = original;
        if (ModificationType.REPLACED_WITH_VERSION == toReturn) {
            toReturn = ModificationType.MODIFIED;
        }
        return toReturn;
    }

    protected IdJoinQuery createJoin() {
        return this.sqlJoinFactory.createIdJoinQuery();
    }

    protected Id4JoinQuery create4Join() {
        return this.sqlJoinFactory.createId4JoinQuery();
    }

    protected boolean reuseGamma(OrcsData data) {
        return data.getModType().isExistingVersionUsed() || data.isExistingVersionUsed();
    }

    private void addRow(TransactionWriter.SqlOrderEnum sqlKey, Object ... data) {
        this.dataItemInserts.put((Object)sqlKey, (Object)data);
    }
}

