/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.api.ArtifactUrlServer;
import org.eclipse.osee.define.api.AttributeAlphabeticalComparator;
import org.eclipse.osee.define.api.OseeHierarchyComparator;
import org.eclipse.osee.define.api.OseeLinkBuilder;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.api.publishing.AttributeOptions;
import org.eclipse.osee.define.api.publishing.LinkType;
import org.eclipse.osee.define.api.publishing.MetadataOptions;
import org.eclipse.osee.define.api.publishing.OutliningOptions;
import org.eclipse.osee.define.api.publishing.PublishingOptions;
import org.eclipse.osee.define.api.publishing.TemplatePublishingData;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.api.publishing.templatemanager.RendererOptions;
import org.eclipse.osee.define.operations.publishing.PublishingErrorLog;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.define.rest.DataRightsOperationsImpl;
import org.eclipse.osee.define.rest.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUtilities;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DataRightsClassification;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.model.datarights.DataRightResult;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.core.util.WordMLWriter;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class MSWordTemplatePublisher {
    protected static final String ARTIFACT = "Artifact";
    protected static final Object ARTIFACT_ID = "Artifact Id";
    protected static final String ARTIFACT_TYPE = "Artifact Type";
    protected static final String APPLICABILITY = "Applicability";
    protected static final String INSERT_ARTIFACT_HERE = "INSERT_ARTIFACT_HERE";
    protected static final String INSERT_LINK = "INSERT_LINK_HERE";
    protected static final String PGNUMTYPE_START_1 = "<w:pgNumType [^>]*w:start=\"1\"/>";
    protected static final String FONT = "Times New Roman";
    protected static final String LANDSCAPE = "Landscape";
    protected static final String CHANGE_TAG = "[*] ";
    protected static final OseeLinkBuilder linkBuilder = new OseeLinkBuilder();
    private static final String LABEL_EMPTY = "<w:r><w:t> </w:t></w:r>";
    private static final String LABEL_START = "<w:r><w:t>";
    private static final String LABEL_END = "</w:t></w:r>";
    protected static final Pattern headElementsPattern = Pattern.compile("(INSERT_ARTIFACT_HERE)|INSERT_LINK_HERE", 42);
    protected PublishingTemplate publishingTemplate;
    protected TemplatePublishingData templatePublishingData;
    protected AttributeTypeToken headingAttributeType;
    protected String outlineNumber = "";
    protected DataRightResult response = null;
    protected String overrideClassification;
    protected final PublishingOptions publishingOptions;
    protected final Set<ArtifactReadable> processedArtifacts = new HashSet<ArtifactReadable>();
    protected final Set<ArtifactId> emptyFolders = new HashSet<ArtifactId>();
    protected final Map<ArtifactReadable, CharSequence> artParagraphNumbers = new HashMap<ArtifactReadable, CharSequence>();
    protected final List<ArtifactTypeToken> excludeArtifactTypes = new LinkedList<ArtifactTypeToken>();
    protected final Map<ApplicabilityId, Boolean> applicabilityMap = new HashMap<ApplicabilityId, Boolean>();
    protected final List<ArtifactReadable> headerArtifacts = new LinkedList<ArtifactReadable>();
    protected final Map<ArtifactTypeToken, List<ArtifactReadable>> oseeLinkedArtifactMap = new HashMap<ArtifactTypeToken, List<ArtifactReadable>>();
    protected List<ArtifactId> changedArtifacts = new LinkedList<ArtifactId>();
    protected final Map<ArtifactId, String> wordContentMap = new HashMap<ArtifactId, String>();
    protected final Set<String> headerGuids = new HashSet<String>();
    protected HashMap<ApplicabilityId, ApplicabilityToken> applicabilityTokens;
    protected final PublishingErrorLog publishingErrorLog = new PublishingErrorLog();
    protected Set<String> bookmarkedIds = new HashSet<String>();
    protected HashMap<String, ArtifactReadable> hyperlinkedIds = new HashMap();
    protected final Writer writer;
    protected final OrcsApi orcsApi;
    protected final AtsApi atsApi;
    protected final Log logger;
    protected final ActivityLog activityLog;
    protected final OrcsTokenService tokenService;
    protected final OseeHierarchyComparator hierarchyComparator;
    protected final PublishingUtils publishingUtils;

    public MSWordTemplatePublisher(PublishingOptions publishingOptions, PublishingTemplate publishingTemplate, Writer writer, OrcsApi orcsApi, AtsApi atsApi) {
        this.publishingOptions = publishingOptions;
        this.publishingTemplate = publishingTemplate;
        this.writer = writer;
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.logger = atsApi.getLogger();
        this.activityLog = orcsApi.getActivityLog();
        this.tokenService = orcsApi.tokenService();
        this.hierarchyComparator = new OseeHierarchyComparator(this.activityLog);
        this.publishingUtils = new PublishingUtils(this.orcsApi);
    }

    public void publish(List<ArtifactId> publishArtifactIds) {
        if (Objects.isNull(publishArtifactIds) || publishArtifactIds.isEmpty()) {
            return;
        }
        String templateContent = Objects.nonNull(this.publishingTemplate) ? this.publishingTemplate.getTemplateContent().getTemplateString() : "";
        this.setUpOptions();
        if (!ARTIFACT.equals(this.templatePublishingData.getElementType())) {
            return;
        }
        List<ArtifactReadable> publishArtifacts = this.getSelectedArtifacts(publishArtifactIds);
        this.applyContentToTemplate(publishArtifacts, templateContent);
    }

    protected void applyContentToTemplate(List<ArtifactReadable> artifacts, String templateContent) {
        WordMLWriter wordMl = new WordMLWriter(this.writer);
        templateContent = this.setUpTemplateContent(wordMl, artifacts.get(0), templateContent, this.publishingOptions.msWordHeadingDepth);
        int lastEndIndex = 0;
        Matcher matcher = headElementsPattern.matcher(templateContent);
        while (matcher.find()) {
            lastEndIndex = this.handleStartOfTemplate(wordMl, templateContent, matcher);
            this.processContent(artifacts, wordMl);
            this.addLinkNotInPublishErrors(wordMl);
            this.publishingErrorLog.publishErrorLog(wordMl);
        }
        this.handleEndOfTemplate(wordMl, templateContent, lastEndIndex);
    }

    protected void processContent(List<ArtifactReadable> artifacts, WordMLWriter wordMl) {
        artifacts.forEach(artifact -> this.processArtifact((ArtifactReadable)artifact, wordMl));
    }

    protected void processArtifact(ArtifactReadable artifact, WordMLWriter wordMl) {
        if (!this.processedArtifacts.contains(artifact)) {
            boolean startedSection = false;
            if (this.checkIncluded(artifact)) {
                startedSection = this.renderArtifact(artifact, wordMl);
            }
            if (this.templatePublishingData.getOutliningOptions().isRecurseChildren()) {
                List children = new LinkedList();
                try {
                    children = artifact.getChildren();
                }
                catch (OseeCoreException oseeCoreException) {
                    this.publishingErrorLog.error(artifact, "There is an error when finding children for this artifact. Possible Cause: Empty Relation Order Attribute");
                }
                for (ArtifactReadable childArtifact : children) {
                    if (childArtifact != null) {
                        this.processArtifact(childArtifact, wordMl);
                        continue;
                    }
                    this.publishingErrorLog.error(artifact, "Artifact has an empty child relation");
                }
            }
            if (startedSection) {
                wordMl.endOutlineSubSection();
            }
            this.processedArtifacts.add(artifact);
        }
    }

    protected boolean renderArtifact(ArtifactReadable artifact, WordMLWriter wordMl) {
        boolean outlining = this.templatePublishingData.getOutliningOptions().isOutlining();
        Boolean publishInline = (Boolean)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PublishInline, (Object)false);
        boolean startedSection = false;
        if (outlining && !publishInline.booleanValue()) {
            this.setArtifactOutlining(artifact, wordMl);
            startedSection = true;
        }
        this.renderMetadata(artifact, wordMl);
        this.renderAttributes(artifact, wordMl);
        return startedSection;
    }

    private List<ArtifactReadable> getArtifactsAndDescendants(List<ArtifactReadable> artifactReadables) {
        return (this.templatePublishingData.getOutliningOptions().isRecurseChildren() ? artifactReadables.stream().flatMap(artifactReadable -> Stream.concat(Stream.of(artifactReadable), artifactReadable.getDescendants().stream())) : artifactReadables.stream()).collect(Collectors.toList());
    }

    protected List<ArtifactReadable> getSelectedArtifacts(List<ArtifactId> artifactIds) {
        List artifacts = this.orcsApi.getQueryFactory().fromBranch(this.publishingOptions.branch).andIds(artifactIds).getResults().getList();
        artifacts.sort(this.hierarchyComparator);
        return artifacts;
    }

    private void setUpOptions() {
        this.templatePublishingData = TemplatePublishingData.create((RendererOptions)this.publishingTemplate.getRendererOptions(), (PublishingOptions)this.publishingOptions);
        if (!ARTIFACT.equals(this.templatePublishingData.getElementType())) {
            return;
        }
        OutliningOptions outliningOptions = this.templatePublishingData.getOutliningOptions();
        this.outlineNumber = outliningOptions.getOutlineNumber();
        this.headingAttributeType = this.tokenService.getAttributeType(outliningOptions.getHeadingAttributeType());
    }

    protected String setUpTemplateContent(WordMLWriter wordMl, ArtifactReadable artifact, String templateContent, int maxOutline) {
        templateContent = templateContent.replaceAll(PGNUMTYPE_START_1, "");
        if (this.outlineNumber.equals("")) {
            this.outlineNumber = this.getParagraphNumber(artifact, templateContent);
        }
        templateContent = wordMl.setHeadingNumbers(this.outlineNumber, templateContent, null);
        if (maxOutline != 9) {
            wordMl.setMaxOutlineLevel(maxOutline);
        }
        return templateContent;
    }

    protected String setUpTemplateContent(WordMLWriter wordMl, ArtifactReadable artifact, String templateContent) {
        return this.setUpTemplateContent(wordMl, artifact, templateContent, 9);
    }

    protected String getParagraphNumber(ArtifactReadable artifact, String templateContent) {
        String paragraphNum;
        String elementType;
        String startParagraphNumber = "1";
        Matcher matcher = headElementsPattern.matcher(templateContent);
        if (matcher.find() && (elementType = matcher.group(0)) != null && elementType.equals(INSERT_ARTIFACT_HERE) && Strings.isValid((String)(paragraphNum = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)"")))) {
            startParagraphNumber = paragraphNum;
        }
        return startParagraphNumber;
    }

    protected int handleStartOfTemplate(WordMLWriter wordMl, String templateContent, Matcher matcher) {
        wordMl.addWordMl((CharSequence)templateContent.substring(0, matcher.start()));
        return matcher.end();
    }

    protected void handleEndOfTemplate(WordMLWriter wordMl, String templateContent, int lastEndIndex) {
        String endOfTemplate = templateContent.substring(lastEndIndex);
        wordMl.addWordMl((CharSequence)this.updateFooter(endOfTemplate));
    }

    protected String updateFooter(String endOfTemplate) {
        endOfTemplate = endOfTemplate.replaceAll("<w:ftr[\\s\\S]+?</w:ftr>", "");
        endOfTemplate = endOfTemplate.replaceFirst("<w:pgSz [^>]*/>", "<w:type w:val=\"continuous\"/><w:pgSz w:w=\"12240\" w:h=\"15840\" w:code=\"1\"/>");
        return endOfTemplate;
    }

    protected boolean populateEmptyHeaders(List<ArtifactReadable> artifacts) {
        boolean hasIncludedChildren = false;
        boolean includeParent = false;
        List children = null;
        for (ArtifactReadable artifact : artifacts) {
            children = artifact.getChildren();
            if (!children.isEmpty()) {
                hasIncludedChildren = this.populateEmptyHeaders(children);
                if (!hasIncludedChildren && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                    this.emptyFolders.add((ArtifactId)artifact);
                }
            } else if (children.isEmpty() && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                this.emptyFolders.add((ArtifactId)artifact);
            }
            if (!this.excludeArtifactTypes.contains(artifact.getArtifactType()) && !artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                includeParent = true;
            }
            if (!hasIncludedChildren) continue;
            includeParent = true;
        }
        return includeParent;
    }

    protected void setUpDataRights(List<ArtifactReadable> artifacts) {
        this.overrideClassification = DataRightsClassification.isValid((String)this.publishingOptions.overrideDataRights) ? (this.overrideClassification = this.publishingOptions.overrideDataRights) : "invalid";
        List<ArtifactReadable> allArtifactIds = this.getArtifactsAndDescendants(artifacts);
        DataRightsOperationsImpl dataRightsOps = new DataRightsOperationsImpl(this.orcsApi);
        this.response = dataRightsOps.getDataRights(allArtifactIds, this.publishingOptions.branch, this.overrideClassification);
    }

    protected void updateParagraphNumbers() {
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.publishingOptions.branch, "Update paragraph number on artifact");
        int count = 0;
        for (Map.Entry<ArtifactReadable, CharSequence> art : this.artParagraphNumbers.entrySet()) {
            if (art.getKey().isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.ParagraphNumber)) {
                transaction.setSoleAttributeValue((ArtifactId)art.getKey(), (AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)art.getValue());
            }
            if (count++ <= 500) continue;
            transaction.commit();
            count = 0;
        }
        transaction.commit();
        this.artParagraphNumbers.clear();
    }

    protected void sortQueryListByHierarchy(List<ArtifactReadable> artifacts) {
        artifacts.sort((Comparator<ArtifactReadable>)this.hierarchyComparator);
        for (Map.Entry entry : this.hierarchyComparator.errors.entrySet()) {
            ArtifactReadable art = (ArtifactReadable)entry.getKey();
            String description = (String)entry.getValue();
            this.publishingErrorLog.error(art, description);
        }
    }

    protected void sortQueryListByAttributeAlphabetical(List<ArtifactReadable> artifacts, AttributeTypeToken attributeToken) {
        try {
            artifacts.sort((Comparator<ArtifactReadable>)new AttributeAlphabeticalComparator(this.activityLog, attributeToken));
        }
        catch (Exception exception) {
            String errorMessage = String.format("There was an error when sorting the list on %s by alphabetical order", attributeToken.getName());
            this.publishingErrorLog.error(errorMessage);
        }
    }

    protected List<ArtifactReadable> filterArtifactsNotRecursivelyRelated(List<ArtifactReadable> artifacts) {
        LinkedList<ArtifactReadable> artifactUnderHeaders = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable artifact : artifacts) {
            List ancestors = artifact.getAncestors();
            for (ArtifactReadable headFolder : this.headerArtifacts) {
                if (!ancestors.contains(headFolder)) continue;
                artifactUnderHeaders.add(artifact);
            }
        }
        return artifactUnderHeaders;
    }

    protected List<ArtifactReadable> addContextToArtifactList(List<ArtifactReadable> changedArtifacts) {
        LinkedList<ArtifactReadable> artifactsWithContext = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable artifact : changedArtifacts) {
            if (!artifactsWithContext.contains(artifact)) {
                artifactsWithContext.add(artifact);
            }
            List ancestors = artifact.getAncestors();
            for (ArtifactReadable ancestor : ancestors) {
                if (artifactsWithContext.contains(ancestor) || !ancestor.notEqual((Id)CoreArtifactTokens.DefaultHierarchyRoot)) break;
                artifactsWithContext.add(ancestor);
            }
            List siblings = artifact.getParent().getChildren();
            for (ArtifactReadable sibling : siblings) {
                if (artifactsWithContext.contains(sibling) || sibling.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) continue;
                artifactsWithContext.add(sibling);
            }
        }
        return artifactsWithContext;
    }

    protected Map<ArtifactReadable, List<ArtifactReadable>> getSortedArtifactsInHeaderMap(List<ArtifactReadable> artifacts) {
        HashMap<ArtifactReadable, List<ArtifactReadable>> headerMap = new HashMap<ArtifactReadable, List<ArtifactReadable>>();
        ArtifactReadable lastHeader = null;
        LinkedList<ArtifactReadable> artList = new LinkedList<ArtifactReadable>();
        for (ArtifactReadable art : artifacts) {
            if (this.headerArtifacts.contains(art)) {
                if (lastHeader == null) {
                    lastHeader = art;
                    artList = new LinkedList();
                    continue;
                }
                headerMap.put(lastHeader, artList);
                lastHeader = art;
                artList = new LinkedList();
                continue;
            }
            artList.add(art);
        }
        headerMap.put(lastHeader, artList);
        return headerMap;
    }

    protected boolean checkIncluded(ArtifactReadable artifact) {
        boolean excludeFolder;
        boolean validWordTemplateContent = !artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.WholeWordContent) && !artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.NativeContent);
        boolean bl = excludeFolder = this.publishingOptions.excludeFolders && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder});
        if (!excludeFolder && this.checkIsArtifactApplicable(artifact)) {
            if (validWordTemplateContent) {
                return true;
            }
            this.publishingErrorLog.error(artifact, "Only artifacts of type Word Template Content are supported in this case");
            return false;
        }
        return false;
    }

    protected boolean checkIsArtifactApplicable(ArtifactReadable artifact) {
        boolean isApplicable = this.publishingOptions.view.equals(ArtifactId.SENTINEL);
        if (isApplicable) {
            return isApplicable;
        }
        ApplicabilityId applicability = artifact.getApplicability();
        if (this.applicabilityMap.containsKey(applicability)) {
            isApplicable = this.applicabilityMap.get(applicability);
        } else {
            List validViews = this.orcsApi.getQueryFactory().applicabilityQuery().getBranchViewsForApplicability(this.publishingOptions.branch, applicability);
            if (validViews.contains(this.publishingOptions.view)) {
                isApplicable = true;
            }
            this.applicabilityMap.put(applicability, isApplicable);
        }
        return isApplicable;
    }

    protected Map<ApplicabilityId, ApplicabilityToken> getApplicabilityTokens() {
        if (this.applicabilityTokens == null) {
            this.applicabilityTokens = new HashMap();
            HashMap tokens = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(this.publishingOptions.branch);
            for (Map.Entry entry : tokens.entrySet()) {
                this.applicabilityTokens.put(ApplicabilityId.valueOf((Long)((Long)entry.getKey())), (ApplicabilityToken)entry.getValue());
            }
        }
        return this.applicabilityTokens;
    }

    protected String getArtifactFooter(ArtifactReadable artifact) {
        return "";
    }

    protected void setArtifactOutlining(ArtifactReadable artifact, WordMLWriter wordMl) {
        AttributeTypeToken attrToken = AttributeTypeToken.valueOf((String)this.headingAttributeType.getIdString());
        String headingText = artifact.getSoleAttributeAsString(attrToken, "");
        if (this.changedArtifacts.contains(artifact)) {
            headingText = CHANGE_TAG.concat(headingText);
        }
        CharSequence paragraphNumber = null;
        paragraphNumber = wordMl.startOutlineSubSection((CharSequence)FONT, (CharSequence)headingText, null);
        if (paragraphNumber == null) {
            paragraphNumber = wordMl.startOutlineSubSection();
        }
        if (this.publishingOptions.updateParagraphNumbers) {
            this.artParagraphNumbers.put(artifact, paragraphNumber);
        }
    }

    protected void renderMetadata(ArtifactReadable artifact, WordMLWriter wordMl) {
        this.templatePublishingData.getMetadataElements().stream().forEach(metadataElement -> this.renderMetadata(artifact, wordMl, (MetadataOptions)metadataElement));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void renderMetadata(ArtifactReadable artifact, WordMLWriter wordMl, MetadataOptions element) {
        wordMl.startParagraph();
        String name = element.getType();
        String format = element.getFormat();
        String label = element.getLabel();
        String value = "";
        if (name.equals(APPLICABILITY)) {
            ApplicabilityToken applicToken = this.getApplicabilityTokens().get(artifact.getApplicability());
            if (!applicToken.isValid()) {
                wordMl.endParagraph();
                return;
            }
            value = applicToken.getName();
        } else if (name.equals(ARTIFACT_TYPE)) {
            value = artifact.getArtifactType().getName();
        } else if (name.equals(ARTIFACT_ID)) {
            value = artifact.getIdString();
        }
        if (!format.isEmpty() || !label.isEmpty()) {
            if (label.contains(">x<")) {
                wordMl.addWordMl((CharSequence)label.replace(">x<", ">" + Xml.escape((CharSequence)(String.valueOf(name) + ": ")).toString() + "<"));
            }
            if (format.contains(">x<")) {
                wordMl.addWordMl((CharSequence)format.replace(">x<", ">" + Xml.escape((CharSequence)value).toString() + "<"));
            }
        } else {
            wordMl.addTextInsideParagraph((CharSequence)(String.valueOf(name) + ": " + value));
        }
        wordMl.endParagraph();
    }

    protected void renderAttributes(ArtifactReadable artifact, WordMLWriter wordMl) {
        boolean outlining = this.templatePublishingData.getOutliningOptions().isOutlining();
        for (AttributeOptions attributeOptions : this.templatePublishingData.getAttributeElements()) {
            String attributeName = attributeOptions.getAttributeName();
            if (this.publishingOptions.allAttributes || attributeName.equals("*")) {
                for (AttributeTypeToken attributeTypeToken : this.getOrderedAttributeTypes(artifact.getValidAttributeTypes())) {
                    if (outlining && !attributeTypeToken.notEqual((Id)this.headingAttributeType)) continue;
                    this.renderAttribute(artifact, wordMl, attributeOptions, attributeTypeToken, true, PresentationType.PREVIEW);
                }
                continue;
            }
            AttributeTypeGeneric attributeTypeGeneric = this.tokenService.getAttributeType(attributeName);
            if (!artifact.isAttributeTypeValid((AttributeTypeId)attributeTypeGeneric)) continue;
            this.renderAttribute(artifact, wordMl, attributeOptions, (AttributeTypeToken)attributeTypeGeneric, false, PresentationType.PREVIEW);
        }
    }

    protected List<AttributeTypeToken> getOrderedAttributeTypes(Collection<AttributeTypeToken> attributeTypes) {
        ArrayList<AttributeTypeToken> orderedAttributeTypes = new ArrayList<AttributeTypeToken>(attributeTypes.size());
        AttributeTypeToken contentType = null;
        for (AttributeTypeToken attributeType : attributeTypes) {
            if (attributeType.matches(new Id[]{CoreAttributeTypes.WholeWordContent, CoreAttributeTypes.WordTemplateContent, CoreAttributeTypes.PlainTextContent})) {
                contentType = attributeType;
                continue;
            }
            orderedAttributeTypes.add(attributeType);
        }
        Collections.sort(orderedAttributeTypes);
        if (contentType != null) {
            orderedAttributeTypes.add(contentType);
        }
        return orderedAttributeTypes;
    }

    protected void renderAttribute(ArtifactReadable artifact, WordMLWriter wordMl, AttributeOptions attributeOptions, AttributeTypeToken attributeType, boolean allAttrs, PresentationType presentationType) {
        if (attributeType.equals(CoreAttributeTypes.WordOleData) || attributeType.equals(CoreAttributeTypes.RelationOrder)) {
            return;
        }
        if (attributeType.equals(CoreAttributeTypes.WordTemplateContent)) {
            this.renderWordTemplateContent(attributeType, artifact, presentationType, wordMl, attributeOptions.getFormat(), attributeOptions.getLabel());
            return;
        }
        if (artifact.isAttributeTypeValid((AttributeTypeId)attributeType)) {
            String attrValues = artifact.getAttributeValuesAsString(attributeType);
            if (attrValues.isEmpty()) {
                return;
            }
            String label = this.generateAttributeLabel(attributeOptions.getLabel(), "*".equals(attributeOptions.getAttributeName()), attributeType);
            this.renderSpecifiedAttribute(attributeType, attrValues, wordMl, attributeOptions.getFormat(), label);
        }
    }

    protected void populateArtifactWordContent(AttributeTypeToken attributeType, ArtifactReadable artifact, PresentationType presentationType, WordMLWriter wordMl, String format, String label) {
        String footer = this.getArtifactFooter(artifact);
        String data = this.getWordTemplateContentData(attributeType, artifact, presentationType, wordMl, format, label, footer);
        this.wordContentMap.put((ArtifactId)artifact, data);
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
            this.headerGuids.add(artifact.getGuid());
        }
    }

    protected void renderWordTemplateContent(AttributeTypeToken attributeType, ArtifactReadable artifact, PresentationType presentationType, WordMLWriter wordMl, String format, String label) {
        String footer = this.getArtifactFooter(artifact);
        String data = this.getWordTemplateContentData(attributeType, artifact, presentationType, wordMl, format, label, footer);
        if (data != null) {
            wordMl.addWordMl((CharSequence)data);
        } else if (footer != null) {
            wordMl.addWordMl((CharSequence)footer);
        }
        if (data != null && WordCoreUtil.containsLists((String)data)) {
            wordMl.resetListValue();
        }
    }

    protected String getWordTemplateContentData(AttributeTypeToken attributeType, ArtifactReadable artifact, PresentationType presentationType, WordMLWriter producer, String format, String label, String footer) {
        WordMLWriter wordMl = producer;
        String data = null;
        LinkType linkType = this.publishingOptions.linkType;
        if (label.length() > 0) {
            wordMl.addParagraph((CharSequence)label);
        }
        Object txId = null;
        txId = artifact.isHistorical() ? this.orcsApi.getTransactionFactory().getTx(artifact.getTransaction()) : TransactionToken.SENTINEL;
        WordTemplateContentData wtcData = new WordTemplateContentData();
        wtcData.setArtId((ArtifactId)artifact);
        wtcData.setBranch((BranchId)artifact.getBranch());
        wtcData.setFooter(footer);
        wtcData.setIsEdit(presentationType == PresentationType.SPECIALIZED_EDIT);
        wtcData.setLinkType(linkType != null ? linkType.toString() : null);
        wtcData.setTxId(txId);
        wtcData.setPresentationType(presentationType);
        wtcData.setViewId(this.publishingOptions.view);
        wtcData.setPermanentLinkUrl(new ArtifactUrlServer(this.orcsApi).getSelectedPermanentLinkUrl());
        wtcData.setArtIsChanged(this.changedArtifacts.contains(artifact));
        Pair<String, Set<String>> content = null;
        try {
            WordTemplateContentRendererHandler rendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.logger);
            content = rendererHandler.renderWordML(wtcData);
        }
        catch (Exception ex) {
            this.publishingErrorLog.error(artifact, ex.toString());
        }
        if (content != null) {
            data = (String)content.getFirst();
            this.processLinkErrors(artifact, data, (Set)content.getSecond());
        }
        return data;
    }

    private String generateAttributeLabel(String label, boolean allAttributes, AttributeTypeToken attributeTypeToken) {
        if (Objects.nonNull(label) && !label.isBlank()) {
            return label;
        }
        if (!allAttributes || attributeTypeToken.matches(new Id[]{CoreAttributeTypes.PlainTextContent})) {
            return LABEL_EMPTY;
        }
        return new StringBuilder(1024).append(LABEL_START).append(Xml.escape((CharSequence)attributeTypeToken.getName())).append(": ").append(LABEL_END).toString();
    }

    private void renderSpecifiedAttribute(AttributeTypeToken attributeType, String attrValues, WordMLWriter wordMlWriter, String format, String label) {
        wordMlWriter.startParagraph();
        wordMlWriter.addWordMl((CharSequence)label);
        if (format.contains(">x<")) {
            wordMlWriter.addWordMl((CharSequence)format.replace(">x<", ">" + Xml.escape((CharSequence)attrValues).toString() + "<"));
        } else {
            wordMlWriter.addTextInsideParagraph((CharSequence)attrValues);
        }
        wordMlWriter.endParagraph();
    }

    protected String getAttributeValueAsString(AttributeTypeToken token, ArtifactReadable artifact) {
        return artifact.getAttributeValuesAsString(token);
    }

    protected void processLinkErrors(ArtifactReadable artifact, String data, Set<String> unknownIds) {
        Pattern bookmarkHyperlinkPattern = Pattern.compile("(" + WordCoreUtil.OSEE_BOOKMARK_REGEX + ")|(" + WordCoreUtil.OSEE_HYPERLINK_REGEX + ")");
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        String id = "";
        if (!unknownIds.isEmpty()) {
            String description = String.format("Artifact contains the following unknown GUIDs: %s (Delete or fix OSEE Link from Artifact)", unknownIds);
            this.publishingErrorLog.error(artifact, description);
        }
        while (match.find()) {
            String bookmarkMatch = match.group(1);
            String hyperlinkMatch = match.group(3);
            if (bookmarkMatch != null) {
                id = match.group(2);
                if (this.bookmarkedIds.contains(id)) continue;
                this.bookmarkedIds.add(id);
                continue;
            }
            if (hyperlinkMatch == null || this.hyperlinkedIds.containsKey(id = match.group(4))) continue;
            this.hyperlinkedIds.put(id, artifact);
        }
    }

    protected void addLinkNotInPublishErrors(WordMLWriter wordMl) {
        if (!this.hyperlinkedIds.isEmpty()) {
            for (Map.Entry<String, ArtifactReadable> link : this.hyperlinkedIds.entrySet()) {
                String description;
                String idString = link.getKey();
                if (this.bookmarkedIds.contains(idString)) continue;
                ArtifactReadable artWithLink = link.getValue();
                try {
                    ArtifactReadable linkedArt = this.orcsApi.getQueryFactory().fromBranch(this.publishingOptions.branch).andGuid(idString).getArtifact();
                    description = String.format("Artifact is linking to the following Artifact Id that is not contained in this document: %s (Guid: %s)", linkedArt.getId(), idString);
                }
                catch (Exception exception) {
                    description = String.format("Artifact contains the following unknown GUID: %s (Delete or fix OSEE Link from Artifact)", idString);
                }
                this.publishingErrorLog.error(artWithLink, description);
            }
        }
    }

    protected String removeUnusedBookmark(String data) {
        Pattern bookmarkHyperlinkPattern = Pattern.compile(WordCoreUtil.OSEE_BOOKMARK_REGEX);
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        String id = "";
        while (match.find()) {
            String foundMatch = match.group(0);
            if (!Strings.isValid((String)foundMatch) || this.hyperlinkedIds.containsKey(id = match.group(1))) continue;
            data = data.substring(match.end(0));
        }
        return data;
    }

    protected void populateOseeLinkedArtifacts(ArtifactTypeToken ... typeTokens) {
        List linkedArts = this.orcsApi.getQueryFactory().fromBranch(this.publishingOptions.branch).andGuids(this.hyperlinkedIds.keySet()).getResults().getList();
        for (ArtifactReadable artifact : linkedArts) {
            if (!artifact.isOfType((ArtifactTypeId[])typeTokens)) continue;
            ArtifactTypeToken artifactType = artifact.getArtifactType();
            if (this.oseeLinkedArtifactMap.containsKey(artifactType)) {
                this.oseeLinkedArtifactMap.get(artifactType).add(artifact);
            } else {
                LinkedList<ArtifactReadable> artList = new LinkedList<ArtifactReadable>();
                artList.add(artifact);
                this.oseeLinkedArtifactMap.put(artifactType, artList);
            }
            this.hyperlinkedIds.remove(artifact.getGuid());
        }
    }

    protected String[] getSplitWordMlBookmark(ArtifactReadable artifact) {
        String wordMlBookmark = this.getWordMlBookmark(artifact);
        return wordMlBookmark.split("(?<=>)", 2);
    }

    protected String getWordMlBookmark(ArtifactReadable artifact) {
        String bookmark = linkBuilder.getWordMlBookmark(artifact);
        bookmark = WordUtilities.reassignBookMarkID(bookmark);
        String guid = artifact.getGuid();
        this.bookmarkedIds.add(guid);
        if (this.hyperlinkedIds.containsKey(guid)) {
            this.hyperlinkedIds.remove(guid);
        }
        return bookmark;
    }

    protected String addChapterNumToCaption(String data) {
        String[] emptySplitBookmark = new String[]{"", ""};
        return this.addChapterNumToCaptionAndBookmark(data, emptySplitBookmark);
    }

    protected String addChapterNumToCaptionAndBookmark(String data, String[] splitBookmark) {
        Pattern oldCaptionPattern = Pattern.compile("(<w:p(( [^>]*?>)|>))(.*?)<w:fldSimple w:instr=\" SEQ (Figure|Table) \\\\\\* ARABIC \">.*?</w:fldSimple>(.*?)(</w:p[^>]*?>)");
        String newCaptionTemplate = "%s%s%s<w:fldSimple w:instr=\" STYLEREF 1 \\s \"><w:r><w:rPr><w:noProof/></w:rPr><w:t> #</w:t></w:r></w:fldSimple><w:r><w:noBreakHyphen/></w:r><w:fldSimple w:instr=\" SEQ %s \\* ARABIC \\s 1 \"><w:r><w:rPr><w:noProof/></w:rPr><w:t> #</w:t></w:r></w:fldSimple>%s<w:r><w:t>%s</w:t></w:r>%s";
        Matcher matcher = oldCaptionPattern.matcher(data);
        int matcherIndex = 0;
        while (matcher.find(matcherIndex)) {
            String paraStart = matcher.group(1);
            String preStyleRefTags = matcher.group(4);
            String seqType = matcher.group(5);
            String captionText = Strings.xmlToText((String)matcher.group(6));
            captionText = Xml.escape((CharSequence)captionText).toString();
            String paraEnd = matcher.group(7);
            String newCaption = String.format(newCaptionTemplate, paraStart, splitBookmark[0], preStyleRefTags, seqType, splitBookmark[1], captionText, paraEnd);
            data = data.replace(matcher.group(0), newCaption);
            matcherIndex = matcher.start() + newCaption.length();
            matcher = oldCaptionPattern.matcher(data);
        }
        return data;
    }

    protected String changeHyperlinksToReferences(String data) {
        Pattern internalDocLinkRegex = Pattern.compile("<w:r><w:fldChar w:fldCharType=\"begin\"/>.*?<w:instrText>\\s+HYPERLINK[^<>]+\"OSEE\\.([^\"]*)\"\\s+</w:instrText>.*?<w:fldChar w:fldCharType=\"separate\"/>.*?<w:rStyle w:val=\"Hyperlink\"/>(.*?)<w:fldChar w:fldCharType=\"end\"/></w:r>");
        Matcher matcher = internalDocLinkRegex.matcher(data);
        int matcherIndex = 0;
        while (matcher.find(matcherIndex)) {
            String guid = matcher.group(1);
            String referenceText = Strings.xmlToText((String)matcher.group(2));
            referenceText = Xml.escape((CharSequence)referenceText).toString();
            boolean isHeader = this.headerGuids.contains(guid);
            String newReference = linkBuilder.getWordMlReference(guid, isHeader, referenceText);
            data = data.replace(matcher.group(0), newReference);
            matcherIndex = matcher.start() + newReference.length();
            matcher = internalDocLinkRegex.matcher(data);
        }
        return data;
    }

    protected void startOutlineSubSectionAndBookmark(WordMLWriter wordMl, ArtifactReadable artifact) {
        String[] splitBookmark = this.getSplitWordMlBookmark(artifact);
        wordMl.addWordMl((CharSequence)splitBookmark[0]);
        wordMl.startOutlineSubSection((CharSequence)FONT, (CharSequence)artifact.getName(), null);
        wordMl.addWordMl((CharSequence)splitBookmark[1]);
    }
}

