/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authorization.admin.internal;

import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.authorization.admin.Authority;
import org.eclipse.osee.authorization.admin.Authorization;
import org.eclipse.osee.authorization.admin.AuthorizationAdmin;
import org.eclipse.osee.authorization.admin.AuthorizationConfiguration;
import org.eclipse.osee.authorization.admin.AuthorizationConfigurationBuilder;
import org.eclipse.osee.authorization.admin.AuthorizationData;
import org.eclipse.osee.authorization.admin.AuthorizationOverride;
import org.eclipse.osee.authorization.admin.AuthorizationProvider;
import org.eclipse.osee.authorization.admin.AuthorizationRequest;
import org.eclipse.osee.authorization.admin.internal.AuthorizationImpl;
import org.eclipse.osee.authorization.admin.internal.AuthorizationUtil;
import org.eclipse.osee.authorization.admin.internal.DenyAllAuthority;
import org.eclipse.osee.authorization.admin.internal.PermitAllAuthority;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class AuthorizationAdminImpl
implements AuthorizationAdmin {
    private static final Authority PERMIT_ALL_OVERRIDE = new PermitAllAuthority();
    private static final Authority DENY_ALL_OVERRIDE = new DenyAllAuthority();
    private final Map<String, AuthorizationProvider> providers = new ConcurrentHashMap<String, AuthorizationProvider>();
    private Log logger;
    private AuthorizationConfiguration config;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(Map<String, Object> properties) {
        this.logger.trace("Starting AuthorizationAdminImpl...", new Object[0]);
        this.update(properties);
    }

    public void stop() {
        this.logger.trace("Stopping AuthorizationAdminImpl...", new Object[0]);
        this.config = null;
    }

    public void update(Map<String, Object> properties) {
        this.logger.trace("Updating AuthorizationAdminImpl...", new Object[0]);
        this.config = AuthorizationConfigurationBuilder.newBuilder().properties(properties).build();
    }

    public void addAuthorizationProvider(AuthorizationProvider provider) {
        String providerId = provider.getScheme();
        providerId = AuthorizationUtil.normalize(providerId);
        this.providers.put(providerId, provider);
    }

    public void removeAuthorizationProvider(AuthorizationProvider provider) {
        String providerId = provider.getScheme();
        providerId = AuthorizationUtil.normalize(providerId);
        this.providers.remove(providerId);
    }

    @Override
    public Iterable<String> getAvailableSchemes() {
        return AuthorizationUtil.unmodifiableSortedIterable(this.providers.keySet());
    }

    @Override
    public Iterable<String> getAllowedSchemes() {
        return this.config.getAllowedSchemes();
    }

    @Override
    public boolean isSchemeAllowed(String schemeType) {
        boolean isAllowed = false;
        if (Strings.isValid((String)schemeType)) {
            String toMatch = AuthorizationUtil.normalize(schemeType);
            for (String scheme : this.getAllowedSchemes()) {
                isAllowed = scheme.equals(toMatch);
                if (isAllowed) break;
            }
        }
        return isAllowed;
    }

    @Override
    public Authorization authorize(AuthorizationRequest request) {
        this.logger.debug("Authorization Requested: [%s]", new Object[]{request});
        String scheme = this.getScheme(request);
        this.checkSchemeAllowed(scheme);
        AuthorizationProvider provider = this.getAuthorizationProvider(scheme);
        this.checkProvider(scheme, provider);
        AuthorizationData data = provider.authorize(request);
        this.checkAuthorizationData(provider.getScheme(), data);
        Authority authority = this.getAuthority(this.config.getOverride(), data);
        this.checkAuthority(provider.getScheme(), authority);
        String authScheme = authority.getScheme();
        Date date = request.getRequestDate();
        boolean secure = request.isSecure();
        Principal principal = data != null ? data.getPrincipal() : null;
        return new AuthorizationImpl(authScheme, date, secure, principal, authority);
    }

    @Override
    public String getDefaultScheme() {
        String toReturn = this.config.getDefaultScheme();
        if (!Strings.isValid((String)toReturn)) {
            Iterator<String> iterator = this.getAllowedSchemes().iterator();
            toReturn = iterator.hasNext() ? iterator.next() : "";
        }
        return toReturn;
    }

    private String getScheme(AuthorizationRequest request) {
        String toReturn = request.getAuthorizationType();
        if (!Strings.isValid((String)toReturn) || this.isNoneAllowed()) {
            toReturn = this.getDefaultScheme();
        }
        return toReturn;
    }

    private boolean isNoneAllowed() {
        boolean result = false;
        String toFind = "None";
        for (String allowed : this.getAllowedSchemes()) {
            result = toFind.equalsIgnoreCase(allowed);
            if (result) break;
        }
        return result;
    }

    private AuthorizationProvider getAuthorizationProvider(String scheme) {
        String toGet = AuthorizationUtil.normalize(scheme);
        return this.providers.get(toGet);
    }

    private Authority getAuthority(AuthorizationOverride override, AuthorizationData data) {
        Authority toReturn = null;
        switch (override) {
            case DENY_ALL: {
                toReturn = DENY_ALL_OVERRIDE;
                break;
            }
            case PERMIT_ALL: {
                toReturn = PERMIT_ALL_OVERRIDE;
                break;
            }
            default: {
                toReturn = data.getAuthority();
            }
        }
        return toReturn;
    }

    private void checkSchemeAllowed(String schemeType) {
        Conditions.checkExpressionFailOnTrue((!this.isSchemeAllowed(schemeType) ? 1 : 0) != 0, (String)"Authorization Error - scheme [%s] is not allowed. Schemes available %s.", (Object[])new Object[]{schemeType, this.getAllowedSchemes()});
    }

    private void checkProvider(String scheme, AuthorizationProvider provider) {
        Conditions.checkExpressionFailOnTrue((provider == null ? 1 : 0) != 0, (String)"Authentication Error - scheme [%s] returned null provider", (Object[])new Object[]{scheme});
    }

    private void checkAuthorizationData(String scheme, AuthorizationData data) {
        Conditions.checkExpressionFailOnTrue((data == null ? 1 : 0) != 0, (String)"Authentication Error - scheme [%s] returned null authorization", (Object[])new Object[]{scheme});
    }

    private void checkAuthority(String scheme, Authority data) {
        Conditions.checkExpressionFailOnTrue((data == null ? 1 : 0) != 0, (String)"Authentication Error - scheme [%s] returned null authority", (Object[])new Object[]{scheme});
    }
}

