/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.branch;

import java.util.function.Consumer;
import org.apache.commons.lang.mutable.MutableLong;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.KeyValueStore;

public class KeyValueModule {
    private final JdbcClient jdbcClient;
    private static final String SELECT_KEY_WITH_KEY = "select * from osee_key_value where key = ?";
    private static final String SELECT_KEY_WITH_VALUE = "select * from osee_key_value where value = ?";

    public KeyValueModule(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public KeyValueStore createKeyValueStore() {
        return new KeyValueStore(){

            public Long putIfAbsent(String value) {
                Long key = this.getByValue(value);
                if (key.equals(0L)) {
                    key = Lib.generateUuid();
                    KeyValueModule.this.jdbcClient.runPreparedUpdate(OseeDb.OSEE_KEY_VALUE_TABLE.getInsertSql(), new Object[]{key, value});
                }
                return key;
            }

            public String getByKey(Long key) {
                final MutableString toReturn = new MutableString();
                KeyValueModule.this.jdbcClient.runQuery((Consumer)new Consumer<JdbcStatement>(){

                    @Override
                    public void accept(JdbcStatement chStmt) {
                        toReturn.setValue(chStmt.getString("value"));
                    }
                }, KeyValueModule.SELECT_KEY_WITH_KEY, new Object[]{key});
                return toReturn.getValue();
            }

            public Long getByValue(String value) {
                final MutableLong toReturn = new MutableLong(0L);
                KeyValueModule.this.jdbcClient.runQuery((Consumer)new Consumer<JdbcStatement>(){

                    @Override
                    public void accept(JdbcStatement chStmt) {
                        toReturn.setValue(chStmt.getLong("key"));
                    }
                }, KeyValueModule.SELECT_KEY_WITH_VALUE, new Object[]{value});
                return (Long)toReturn.getValue();
            }

            public boolean putByKey(Long key, String value) {
                String existingValue = this.getByKey(key);
                if (!Strings.isValid((String)existingValue)) {
                    KeyValueModule.this.jdbcClient.runPreparedUpdate(OseeDb.OSEE_KEY_VALUE_TABLE.getInsertSql(), new Object[]{key, value});
                    return true;
                }
                return false;
            }
        };
    }

    private class MutableString {
        private String value;

        private MutableString() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

