/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.GetAllMIMRelatedObjectsEndpoint;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.ResolvedStructurePath;
import org.eclipse.osee.mim.types.StructurePath;

public class GetAllMIMRelatedObjectsEndpointImpl
implements GetAllMIMRelatedObjectsEndpoint {
    private final BranchId branch;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;
    private final InterfaceMessageApi messageApi;
    private final InterfaceSubMessageApi subMessageApi;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi elementApi;
    private final InterfaceElementArrayApi elementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public GetAllMIMRelatedObjectsEndpointImpl(BranchId branch, InterfaceStructureApi interfaceStructureApi, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.branch = branch;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
        this.messageApi = interfaceMessageApi;
        this.subMessageApi = interfaceSubMessageApi;
        this.interfaceStructureApi = interfaceStructureApi;
        this.elementApi = interfaceElementApi;
        this.elementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<StructurePath> getAllStructureNames() {
        List<StructurePath> structures = this.interfaceStructureApi.getAllWithoutRelations(this.branch).stream().map(a -> new StructurePath(a.getId(), a.getName())).collect(Collectors.toList());
        structures = this.getStructureNames(structures);
        return structures;
    }

    private List<StructurePath> getStructureNames(List<StructurePath> structures) {
        try {
            for (StructurePath structure : structures) {
                for (InterfaceSubMessageToken submessage : this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceSubMessageToken.class)) {
                    for (InterfaceMessageToken message : this.messageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage, ArtifactId.valueOf((Long)submessage.getId()), InterfaceMessageToken.class)) {
                        for (InterfaceConnection connection : this.interfaceConnectionApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceConnectionContent_Message, ArtifactId.valueOf((Long)message.getId()), InterfaceConnection.class)) {
                            structure.addPath(new ResolvedStructurePath(String.valueOf(message.getName()) + " > " + submessage.getName(), "/" + connection.getIdString() + "/messages/" + message.getIdString() + "/" + submessage.getIdString() + "/elements/" + structure.getIdString()));
                        }
                    }
                }
            }
            Collections.sort(structures, new Comparator<StructurePath>(){

                @Override
                public int compare(StructurePath o1, StructurePath o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return structures;
        }
        catch (Exception exception) {
            return new LinkedList<StructurePath>();
        }
    }

    @Override
    public Collection<StructurePath> getFilteredStructureNames(String filter) {
        List<StructurePath> structures = this.interfaceStructureApi.getFilteredWithoutRelations(this.branch, filter).stream().map(a -> new StructurePath(a.getId(), a.getName())).collect(Collectors.toList());
        structures = this.getStructureNames(structures);
        return structures;
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements() {
        return this.elementApi.getAll(this.branch);
    }
}

