/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookReader;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookWriter;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.MimImportApi;
import org.eclipse.osee.mim.types.InterfaceElementImportToken;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimImportSummary;
import org.eclipse.osee.mim.types.PlatformTypeImportToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class IcdImportApiImpl
implements MimImportApi {
    private final ExcelWorkbookReader reader;
    private final MimApi mimApi;
    private final BranchId branch;
    private MimImportSummary summary;
    private Long id = 1L;

    public IcdImportApiImpl(BranchId branch, InputStream inputStream, MimApi mimApi) {
        this.reader = new ExcelWorkbookReader(inputStream, ExcelWorkbookWriter.WorkbookFormat.XLSX);
        this.mimApi = mimApi;
        this.branch = branch;
    }

    @Override
    public MimImportSummary getSummary() {
        int end;
        int start;
        String[] split;
        this.summary = new MimImportSummary();
        this.reader.setActiveSheet("Message and Submessage Summary");
        String nodeName = this.reader.getCellStringValue(0, 0).split(" ")[0];
        final InterfaceNode primaryNode = new InterfaceNode(this.id, nodeName);
        primaryNode.setApplicability(ApplicabilityToken.BASE);
        primaryNode.setAddress("");
        primaryNode.setColor("");
        primaryNode.setDescription("");
        this.summary.setPrimaryNode(primaryNode);
        this.incrementId();
        nodeName = this.reader.getCellStringValue(0, 5).split(" ")[0];
        InterfaceNode secondaryNode = new InterfaceNode(this.id, nodeName);
        secondaryNode.setApplicability(ApplicabilityToken.BASE);
        secondaryNode.setAddress("");
        secondaryNode.setColor("");
        secondaryNode.setDescription("");
        this.summary.setSecondaryNode(secondaryNode);
        this.incrementId();
        List primaryRegions = this.reader.getMergedRegions().stream().filter(r -> r.split(":")[0].charAt(0) == 'A' && r.split(":")[1].charAt(0) == 'A').collect(Collectors.toList());
        List secondaryRegions = this.reader.getMergedRegions().stream().filter(r -> r.split(":")[0].charAt(0) == 'F' && r.split(":")[1].charAt(0) == 'F').collect(Collectors.toList());
        HashMap<String, Long> submessageIds = new HashMap<String, Long>();
        for (String region : primaryRegions) {
            split = region.split(":");
            start = Integer.parseInt(split[0].substring(1)) - 1;
            end = Integer.parseInt(split[1].substring(1)) - 1;
            this.readMessage(primaryNode, start, end, 0, submessageIds);
        }
        for (String region : secondaryRegions) {
            split = region.split(":");
            start = Integer.parseInt(split[0].substring(1)) - 1;
            end = Integer.parseInt(split[1].substring(1)) - 1;
            this.readMessage(secondaryNode, start, end, 5, submessageIds);
        }
        this.reader.setActiveSheet("Structure Summary");
        LinkedList<String> structureSheetNames = new LinkedList<String>();
        int rowIndex = 4;
        while (this.reader.rowExists(rowIndex)) {
            String nameFormula = this.reader.getCellHyperlinkString(rowIndex, 1);
            String sheetName = nameFormula.split("!")[0].replace("'", "");
            if (!sheetName.contains(" Header")) {
                structureSheetNames.add(sheetName);
            }
            ++rowIndex;
        }
        List<PlatformTypeToken> existingPlatformTypes = this.mimApi.getInterfacePlatformTypeApi().getAllWithRelations(this.branch, Arrays.asList(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet, CoreRelationTypes.InterfaceEnumeration_EnumerationState));
        HashMap<String, InterfaceElementImportToken> elements = new HashMap<String, InterfaceElementImportToken>();
        HashMap<String, PlatformTypeImportToken> platformTypes = new HashMap<String, PlatformTypeImportToken>();
        LinkedList<PlatformTypeImportToken> platformTypesToCreate = new LinkedList<PlatformTypeImportToken>();
        for (PlatformTypeToken type : existingPlatformTypes) {
            String typeKey = "";
            if (type.getInterfaceLogicalType().equals("enumeration")) {
                InterfaceEnumerationSet enumSet = type.getEnumSet();
                if (enumSet != null && enumSet.getEnumerations().size() > 0) {
                    for (InterfaceEnumeration en : enumSet.getEnumerations()) {
                        typeKey = String.valueOf(typeKey) + en.getOrdinal() + "=" + en.getName() + ";";
                    }
                } else {
                    typeKey = type.getName();
                }
            } else {
                typeKey = this.mimApi.getInterfacePlatformTypeApi().getUniqueIdentifier(type.getInterfaceLogicalType(), type.getInterfacePlatformTypeMinval(), type.getInterfacePlatformTypeMaxval(), type.getInterfacePlatformTypeValidRangeDescription(), type.getInterfacePlatformTypeUnits(), Integer.parseInt(type.getInterfacePlatformTypeBitSize()) / 8);
            }
            platformTypes.put(typeKey, new PlatformTypeImportToken(type.getId(), type.getName()));
        }
        if (!platformTypes.containsKey("boolean")) {
            PlatformTypeImportToken boolToken = new PlatformTypeImportToken(this.id, "Boolean", "boolean", "8", "0", "1", "", "", "", "0 to 1");
            platformTypes.put("boolean", boolToken);
            this.incrementId();
            platformTypesToCreate.add(boolToken);
        }
        for (String sheetName : structureSheetNames) {
            this.reader.setActiveSheet(sheetName);
            InterfaceStructureToken structure = this.readStructure(primaryNode, secondaryNode, submessageIds);
            this.readStructureElements(structure, elements, platformTypes, platformTypesToCreate);
        }
        for (PlatformTypeImportToken pTypeToken : platformTypesToCreate) {
            this.summary.getPlatformTypes().add(pTypeToken);
        }
        Collections.sort(this.summary.getMessages(), new Comparator<InterfaceMessageToken>(){

            @Override
            public int compare(InterfaceMessageToken o1, InterfaceMessageToken o2) {
                if (o1.getInitiatingNode().getName().equals(o2.getInitiatingNode().getName())) {
                    if (Integer.parseInt(o1.getInterfaceMessageNumber()) > Integer.parseInt(o2.getInterfaceMessageNumber())) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.getInitiatingNode().getName().equals(primaryNode.getName())) {
                    return -1;
                }
                return 1;
            }
        });
        this.reader.closeWorkbook();
        return this.summary;
    }

    private void readMessage(InterfaceNode node, int firstRow, int lastRow, int colOffset, Map<String, Long> subMessageIdMap) {
        String messageNumber = this.reader.getCellStringValue(firstRow, 0 + colOffset);
        String rate = this.reader.getCellStringValue(firstRow, 1 + colOffset);
        String write = this.reader.getCellStringValue(firstRow, 2 + colOffset);
        String name = this.reader.getCellStringValue(firstRow, 3 + colOffset);
        if (messageNumber.equals("0")) {
            return;
        }
        String periodicity = rate.equals("Aperiodic") ? rate : "Periodic";
        rate = rate.equals("Aperiodic") ? "1" : rate.split(" ")[0];
        InterfaceMessageToken message = new InterfaceMessageToken(this.id, name);
        message.setInterfaceMessageNumber(messageNumber);
        message.setInterfaceMessageRate(rate);
        message.setInterfaceMessagePeriodicity(periodicity);
        message.setInterfaceMessageWriteAccess(write.equals("W"));
        message.setApplicability(ApplicabilityToken.BASE);
        message.setInitiatingNode(node);
        message.setInterfaceMessageType("Operational");
        message.setDescription("");
        this.incrementId();
        LinkedList<String> subMessageIds = new LinkedList<String>();
        int subMsgNum = 1;
        int i = firstRow + 2;
        while (i <= lastRow) {
            String label = this.reader.getCellStringValue(i, 3 + colOffset);
            if (label == null || !label.contains("Submessage")) break;
            String subMessageName = this.reader.getCellStringValue(i, 4 + colOffset);
            InterfaceSubMessageToken subMessage = new InterfaceSubMessageToken(this.id, subMessageName);
            subMessage.setApplicability(ApplicabilityToken.BASE);
            subMessage.setInterfaceSubMessageNumber("" + subMsgNum);
            subMessage.setDescription("");
            subMessageIds.add("" + this.id);
            subMessageIdMap.put(this.getSubMessageMapKey(messageNumber, String.valueOf(subMsgNum), node.getName()), this.id);
            this.incrementId();
            this.summary.getSubMessages().add(subMessage);
            ++subMsgNum;
            ++i;
        }
        this.summary.getMessageSubmessageRelations().put(message.getIdString(), subMessageIds);
        this.summary.getMessages().add(message);
    }

    private InterfaceStructureToken readStructure(InterfaceNode primaryNode, InterfaceNode secondaryNode, Map<String, Long> subMessageIdMap) {
        int taskFile;
        int structureRow = 1;
        String name = this.reader.getCellStringValue(structureRow, 1);
        String category = this.reader.getCellStringValue(structureRow, 4);
        String txRate = this.reader.getCellValue(structureRow, 5).toString();
        String minSim = this.reader.getCellValue(structureRow, 6).toString();
        String maxSim = this.reader.getCellValue(structureRow, 7).toString();
        String nodeName = this.reader.getCellStringValue(structureRow, 10);
        String msgNum = this.reader.getCellStringValue(structureRow, 11);
        String subMsgNum = this.reader.getCellStringValue(structureRow, 12);
        String taskfileType = this.reader.getCellValue(structureRow, 13).toString();
        String description = this.reader.getCellStringValue(structureRow, 14);
        InterfaceStructureToken structure = new InterfaceStructureToken(this.id, name);
        this.incrementId();
        structure.setApplicability(ApplicabilityToken.BASE);
        structure.setInterfaceStructureCategory(category);
        structure.setInterfaceMinSimultaneity(this.toIntString(minSim));
        structure.setInterfaceMaxSimultaneity(this.toIntString(maxSim));
        structure.setDescription(description);
        try {
            taskFile = Integer.parseInt(taskfileType);
        }
        catch (NumberFormatException numberFormatException) {
            taskFile = 0;
        }
        structure.setInterfaceTaskFileType(taskFile);
        InterfaceMessageToken message = InterfaceMessageToken.SENTINEL;
        for (InterfaceMessageToken msg : this.summary.getMessages()) {
            if (!msg.getInterfaceMessageNumber().equals(String.valueOf(msgNum)) || !msg.getInitiatingNode().getName().equals(nodeName)) continue;
            message = msg;
            break;
        }
        if (!message.isValid()) {
            message = new InterfaceMessageToken(this.id, "Message " + msgNum);
            message.setInterfaceMessageNumber(msgNum);
            message.setInterfaceMessageWriteAccess(false);
            message.setApplicability(ApplicabilityToken.BASE);
            message.setInitiatingNode(primaryNode.getName().equals(nodeName) ? primaryNode : secondaryNode);
            message.setInterfaceMessageType("Connection");
            message.setDescription("");
            this.incrementId();
            this.summary.getMessages().add(message);
        }
        String[] txRateSplit = txRate.split("-");
        String txRateInt = txRateSplit[0].split("[.]")[0];
        String periodicity = txRateSplit.length == 2 && txRateSplit[1].equals("A") ? "Aperiodic" : "Periodic";
        message.setInterfaceMessageRate(txRateInt);
        message.setInterfaceMessagePeriodicity(periodicity);
        String subMsgKey = this.getSubMessageMapKey(msgNum, subMsgNum, nodeName);
        if (!subMessageIdMap.containsKey(subMsgKey)) {
            InterfaceSubMessageToken subMessage = new InterfaceSubMessageToken(this.id, "SubMessage " + subMsgNum);
            this.incrementId();
            subMessage.setInterfaceSubMessageNumber(String.valueOf(subMsgNum));
            subMessage.setApplicability(ApplicabilityToken.BASE);
            subMessage.setDescription("");
            this.summary.getSubMessages().add(subMessage);
            List msgRels = this.summary.getMessageSubmessageRelations().getOrDefault(message.getIdString(), new LinkedList());
            msgRels.add(subMessage.getIdString());
            this.summary.getMessageSubmessageRelations().put(message.getIdString(), msgRels);
            subMessageIdMap.put(this.getSubMessageMapKey(msgNum, subMsgNum, nodeName), subMessage.getId());
        }
        Long subMsgId = subMessageIdMap.get(subMsgKey);
        List rels = this.summary.getSubMessageStructureRelations().getOrDefault(subMsgId.toString(), new LinkedList());
        rels.add(structure.getIdString());
        this.summary.getSubMessageStructureRelations().put(subMsgId.toString(), rels);
        this.summary.getStructures().add(structure);
        return structure;
    }

    private void readStructureElements(InterfaceStructureToken structure, Map<String, InterfaceElementImportToken> elements, Map<String, PlatformTypeImportToken> platformTypes, List<PlatformTypeImportToken> platformTypesToCreate) {
        int rowIndex = 4;
        InterfaceElementImportToken previousElement = InterfaceElementImportToken.SENTINEL;
        PlatformTypeImportToken previousPType = PlatformTypeImportToken.SENTINEL;
        while (this.reader.rowExists(rowIndex)) {
            boolean possibleArray;
            int numBytes = (int)this.reader.getCellNumericValue(rowIndex, 2);
            String logicalType = this.reader.getCellStringValue(rowIndex, 5);
            String name = this.reader.getCellStringValue(rowIndex, 6);
            String units = this.reader.getCellStringValue(rowIndex, 7);
            String validRange = this.reader.getCellStringValue(rowIndex, 8);
            boolean alterable = this.reader.getCellStringValue(rowIndex, 9).equals("Yes");
            String description = this.reader.getCellStringValue(rowIndex, 10);
            String enumDesc = this.reader.getCellStringValue(rowIndex, 11);
            String notes = this.reader.getCellStringValue(rowIndex, 12);
            if (name.isEmpty() && numBytes == 0 && logicalType.toLowerCase().contains("instrumentation message")) {
                name = structure.getName();
            }
            PlatformTypeImportToken pType = PlatformTypeImportToken.SENTINEL;
            if (logicalType.equals("boolean")) {
                pType = platformTypes.get("boolean");
            } else if (logicalType.equals("enumeration")) {
                String[] splitLine;
                String enumName = enumDesc.split("\n")[0].split(":")[0].replaceAll("[()]", "").trim();
                enumName = name.equals("Taskfile Type") ? (structure.getDescription().toLowerCase().contains("command taskfile") ? "Command Taskfiles" : "Status Taskfiles") : enumName;
                enumName = enumName.isEmpty() || enumName.split("[-=]").length > 1 && enumName.split("[-=]")[0].matches("^\\d+\\s*") ? name : enumName;
                String[] enumDescLines = enumDesc.split("\n");
                String key = "";
                String[] stringArray = enumDescLines;
                int n = enumDescLines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.trim().matches("^\\s*\\d+\\s*[-=].*")) {
                        splitLine = line.trim().split("\\s*[-=]\\s*", 2);
                        int ordinal = Integer.parseInt(splitLine[0]);
                        String enumerationName = splitLine[1].trim();
                        key = String.valueOf(key) + ordinal + "=" + enumerationName + ";";
                    }
                    ++n2;
                }
                String string = key = key.isEmpty() ? enumName : key;
                if (platformTypes.containsKey(key)) {
                    pType = platformTypes.get(key);
                } else {
                    pType = new PlatformTypeImportToken(this.id, enumName, logicalType, String.valueOf(numBytes * 8), "", "", "", "", "", validRange);
                    this.incrementId();
                    platformTypes.put(enumName, pType);
                    platformTypesToCreate.add(pType);
                    InterfaceEnumerationSet enumSet = new InterfaceEnumerationSet(this.id, enumName);
                    this.incrementId();
                    enumSet.setDescription(enumDesc);
                    enumSet.setApplicability(ApplicabilityToken.BASE);
                    this.summary.getEnumSets().add(enumSet);
                    this.summary.getPlatformTypeEnumSetRelations().put(pType.getIdString(), new LinkedList<String>(Arrays.asList(enumSet.getIdString())));
                    splitLine = enumDescLines;
                    int n3 = enumDescLines.length;
                    n = 0;
                    while (n < n3) {
                        String line = splitLine[n];
                        if (line.trim().matches("^\\s*\\d+\\s*[-=].*")) {
                            String[] splitLine2 = line.trim().split("\\s*[-=]\\s*", 2);
                            int ordinal = Integer.parseInt(splitLine2[0]);
                            InterfaceEnumeration enumeration = new InterfaceEnumeration(this.id, splitLine2[1].trim());
                            this.incrementId();
                            enumeration.setApplicability(ApplicabilityToken.BASE);
                            enumeration.setOrdinal(ordinal);
                            this.summary.getEnums().add(enumeration);
                            List rels = this.summary.getEnumSetEnumRelations().getOrDefault(enumSet.getIdString(), new LinkedList());
                            rels.add(enumeration.getIdString());
                            this.summary.getEnumSetEnumRelations().put(enumSet.getIdString(), rels);
                        }
                        ++n;
                    }
                }
            } else {
                units = units.contains("n/a") ? "" : units;
                validRange = validRange.contains("n/a") ? "" : validRange;
                String minVal = "";
                String maxVal = "";
                String[] range = validRange.split(" to ");
                if (range.length == 1 && range[0].split(" ").length == 1) {
                    minVal = range[0].trim();
                    maxVal = range[0].trim();
                    validRange = range[0].trim();
                } else if (range.length == 2) {
                    minVal = range[0].trim();
                    maxVal = range[1].trim();
                    validRange = String.valueOf(range[0]) + " to " + range[1];
                }
                String pTypeName = this.mimApi.getInterfacePlatformTypeApi().getUniqueIdentifier(logicalType, minVal, maxVal, validRange, units, numBytes);
                if (platformTypes.containsKey(pTypeName)) {
                    pType = platformTypes.get(pTypeName);
                } else {
                    pType = new PlatformTypeImportToken(this.id, pTypeName, logicalType, String.valueOf(numBytes * 8), minVal, maxVal, units, "", "", validRange);
                    this.incrementId();
                    platformTypes.put(pTypeName, pType);
                    platformTypesToCreate.add(pType);
                }
            }
            String elementKey = this.getElementKey(name, alterable, description, notes, pType.getId());
            InterfaceElementImportToken element = InterfaceElementImportToken.SENTINEL;
            boolean relateElement = true;
            boolean bl = possibleArray = name.matches(".*\\s\\d+$") && !name.matches(".*\\s(and)\\s\\d+$");
            if (!possibleArray && elements.containsKey(elementKey)) {
                previousElement = element = elements.get(elementKey);
                previousPType = pType;
            } else if (possibleArray && name.matches(".*\\s\\d+$") && !name.matches(".*\\s(and)\\s\\d+$") && previousElement.isValid() && previousPType.isValid() && this.compareElementsForArray(previousElement.getName(), name, previousPType.getId(), pType.getId())) {
                String[] nameSplit = name.split(" ");
                int arrayNum = Integer.parseInt(nameSplit[nameSplit.length - 1]);
                if (previousElement.getInterfaceElementIndexStart() == 0) {
                    String[] prevNameSplit = previousElement.getName().split(" ");
                    int prevArrayNum = Integer.parseInt(prevNameSplit[prevNameSplit.length - 1]);
                    previousElement.setInterfaceElementIndexStart(prevArrayNum);
                }
                previousElement.setInterfaceElementIndexEnd(arrayNum);
                relateElement = false;
            } else {
                element = new InterfaceElementImportToken(this.id, name);
                this.incrementId();
                element.setInterfaceElementAlterable(alterable);
                element.setDescription(description);
                element.setNotes(notes);
                elements.put(elementKey, element);
                this.summary.getElements().add(element);
                this.summary.getElementPlatformTypeRelations().put(element.getIdString(), new LinkedList<String>(Arrays.asList(pType.getIdString())));
                previousElement = element;
                previousPType = pType;
            }
            if (relateElement) {
                List rels = this.summary.getStructureElementRelations().getOrDefault(structure.getIdString(), new LinkedList());
                rels.add(element.getIdString());
                this.summary.getStructureElementRelations().put(structure.getIdString(), rels);
            }
            ++rowIndex;
        }
    }

    private String toIntString(String str) {
        String result = "";
        try {
            int val = (int)Double.parseDouble(str);
            result = String.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {
            result = str;
        }
        return result;
    }

    private boolean compareElementsForArray(String name1, String name2, Long pTypeId1, Long pTypeId2) {
        String n2;
        String n1 = name1.split("\\s\\d+$")[0];
        return n1.equals(n2 = name2.split("\\s\\d+$")[0]) && pTypeId1 == pTypeId2;
    }

    private String getSubMessageMapKey(String messageNum, String subMessageNum, String nodeName) {
        return String.valueOf(nodeName) + messageNum + subMessageNum;
    }

    private String getElementKey(String name, boolean alterable, String description, String notes, Long pTypeId) {
        return String.valueOf(name) + "_" + alterable + "_" + description.hashCode() + "_" + notes.hashCode() + "_" + pTypeId;
    }

    private void incrementId() {
        this.id = this.id + 1L;
    }
}

