/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCache;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCacheKey;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateInternal;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.RankHashMap;
import org.eclipse.osee.framework.jdk.core.util.RankMap;
import org.eclipse.osee.logger.Log;

abstract class AbstractPublishingTemplateCache
implements PublishingTemplateCache {
    protected RankMap<List<PublishingTemplateInternal>> keyMap;
    protected List<PublishingTemplateInternal> list;
    protected Log logger;

    AbstractPublishingTemplateCache(Log logger) {
        this.logger = logger;
        this.deleteCache();
    }

    private void addToKeyMap(final PublishingTemplateInternal publishingTemplateInternal) {
        PublishingTemplateCacheKey[] publishingTemplateCacheKeyArray = PublishingTemplateCacheKey.values();
        int n = publishingTemplateCacheKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            final PublishingTemplateCacheKey primaryKey = publishingTemplateCacheKeyArray[n2];
            Iterable<String> secondaryKeyIterable = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return primaryKey.extractKey(publishingTemplateInternal);
                }
            };
            for (String secondaryKey : secondaryKeyIterable) {
                Optional publishingTemplateInternalListOptional = this.keyMap.get(new Object[]{primaryKey, secondaryKey});
                if (!publishingTemplateInternalListOptional.isPresent()) {
                    ArrayList<PublishingTemplateInternal> publishingTemplateInternalList = new ArrayList<PublishingTemplateInternal>();
                    publishingTemplateInternalList.add(publishingTemplateInternal);
                    this.keyMap.associate(publishingTemplateInternalList, new Object[]{primaryKey, secondaryKey});
                    continue;
                }
                ((List)publishingTemplateInternalListOptional.get()).add(publishingTemplateInternal);
            }
            ++n2;
        }
    }

    private void sortMatchCritera() {
        this.keyMap.stream(new Object[]{PublishingTemplateCacheKey.MATCH_CRITERIA}).filter(publishingTemplateInternalList -> publishingTemplateInternalList.size() > 1).forEach(publishingTemplateInternalList -> publishingTemplateInternalList.sort(new Comparator<PublishingTemplateInternal>(){

            @Override
            public int compare(PublishingTemplateInternal o1, PublishingTemplateInternal o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }));
    }

    private void logDuplicateMatchCritera() {
        this.keyMap.streamEntries(new Object[]{PublishingTemplateCacheKey.MATCH_CRITERIA}).filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            Object matchCriteria = entry.getKey(1);
            List publishingTemplateInternalList = (List)entry.getValue();
            String primaryTemplateName = ((PublishingTemplateInternal)publishingTemplateInternalList.get(0)).getName();
            String primaryTemplateIdentifier = ((PublishingTemplateInternal)publishingTemplateInternalList.get(0)).getIdentifier();
            Message message = new Message().blank().title((CharSequence)"PublishingTemplateProvider has detected a conflict with a Match Criteria.").indentInc().segment((CharSequence)"Match Criteria", matchCriteria).title((CharSequence)"The Publishing Template That Will Be Used").indentInc().segment((CharSequence)"Name", (Object)primaryTemplateName).segment((CharSequence)"Identifier", (Object)primaryTemplateIdentifier).indentDec().segmentIndexedList((CharSequence)"Matching Publishing Templates", publishingTemplateInternalList);
            this.logger.error(message.toString().replace("%", "%%"), new Object[0]);
        });
    }

    private synchronized void cacheTemplates() {
        RankHashMap keyMap;
        if (this.isCacheLoaded()) {
            return;
        }
        this.loadTemplates();
        this.keyMap = keyMap = new RankHashMap("KeyMap", 2, 256, 0.75f, new Predicate[]{o -> o instanceof PublishingTemplateCacheKey, o -> o instanceof String});
        this.list.stream().forEach(this::addToKeyMap);
        this.sortMatchCritera();
        this.logDuplicateMatchCritera();
    }

    @Override
    public void deleteCache() {
        this.list = null;
        this.keyMap = null;
    }

    @Override
    public Optional<PublishingTemplateInternal> findFirstTemplate(PublishingTemplateCacheKey key, String identifier) {
        this.loadCacheIfNeeded();
        if (Objects.isNull((Object)key) || Objects.isNull(identifier)) {
            return Optional.empty();
        }
        Optional<PublishingTemplateInternal> firstTemplate = this.keyMap.get(new Object[]{key, identifier}).map(templateList -> templateList.size() > 0 ? (PublishingTemplateInternal)templateList.get(0) : null);
        return firstTemplate;
    }

    @Override
    public Optional<PublishingTemplateInternal> findFirstTemplateByMatchCriteria(List<String> matchCriteria) {
        this.loadCacheIfNeeded();
        Optional<PublishingTemplateInternal> firstTemplate = matchCriteria.stream().map(matchCriterion -> this.keyMap.get(new Object[]{PublishingTemplateCacheKey.MATCH_CRITERIA, matchCriterion})).filter(Optional::isPresent).map(Optional::get).findFirst().map(publishingTemplateInternalList -> publishingTemplateInternalList.isEmpty() ? null : (PublishingTemplateInternal)publishingTemplateInternalList.get(0));
        return firstTemplate;
    }

    @Override
    public List<String> getPublishingTemplateSafeNames() {
        this.loadCacheIfNeeded();
        List<String> publishingTemplateSafeNames = this.list.stream().map(PublishingTemplateInternal::getSafeName).collect(Collectors.toUnmodifiableList());
        return publishingTemplateSafeNames;
    }

    protected boolean isCacheLoaded() {
        return Objects.nonNull(this.list);
    }

    protected void loadCacheIfNeeded() {
        if (!this.isCacheLoaded()) {
            this.cacheTemplates();
        }
    }

    protected abstract void loadTemplates();
}

