/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.HashMap;
import java.util.Map;

public enum DoorsDataType {
    HEADING("Heading", true),
    HEADER("Header", true),
    INFORMATION("Information", false),
    REQUIREMENT("Requirement", false),
    DESIGN_REQ("Design Req", true),
    FUNCTIONAL_REQ("Functional Req", true),
    PERFORMANCE_REQ("Performance Req", true),
    PHYSICAL_REQ("Physical Req", true),
    SAFETY_REQ("Safety Req", true),
    ENVIRONMENT_REQ("Environment Req", true),
    INTERFACE_REQ("Interface Req", true),
    TABLE("Table", false),
    FIGURE("Figure", false),
    LIST("List", false),
    NOT_DEFINED("Not Defined", false),
    OTHER("", false);

    private final String _dataType;
    private final Boolean isSingle;
    private static final Map<String, DoorsDataType> rawStringToDataType;

    static {
        rawStringToDataType = new HashMap<String, DoorsDataType>();
        DoorsDataType[] doorsDataTypeArray = DoorsDataType.values();
        int n = doorsDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DoorsDataType enumStatus = doorsDataTypeArray[n2];
            rawStringToDataType.put(enumStatus._dataType, enumStatus);
            ++n2;
        }
    }

    private DoorsDataType(String dataType, Boolean single) {
        this._dataType = dataType;
        this.isSingle = single;
    }

    public static synchronized DoorsDataType fromString(String value) {
        DoorsDataType returnVal = rawStringToDataType.get(value);
        return returnVal != null ? returnVal : OTHER;
    }

    public Boolean isSingle() {
        return this.isSingle;
    }
}

