/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;

public class ConvertCreateUpdateAtsConfig
implements IAtsDatabaseConversion {
    private final OrcsApi orcsApi;

    public ConvertCreateUpdateAtsConfig(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void run(XResultData data, boolean reportOnly, AtsApi atsApi) {
        if (reportOnly) {
            data.log("No REPORT-ONLY available for this conversion.\n");
        } else {
            UpdateAtsConfiguration update = new UpdateAtsConfiguration(atsApi, this.orcsApi);
            update.createUpdateConfig(data);
            data.log("Complete");
        }
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Updates AtsConfig artifact (optional but recommended conversion)\n\n");
        data.append("This will:\n   - Create AtsConfig artifact, if not created\n   - Create Rule Definitions from OSEE-INF/atsConfig/ruleDefinitions.ats, if not created\n   - Create/Update Views from OSEE-INF/atsConfig/views.json\n   - Create Color Team Column, if not created.\n   - Create/Update Valid State Names\n\nCan be run multiple times without corruption.\nShould be run after each release.");
        return data.toString();
    }

    public String getName() {
        return "Create or Update AtsConfig";
    }
}

