/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.account.rest.internal.AccountOps;
import org.eclipse.osee.account.rest.model.AccountPreferencesData;
import org.eclipse.osee.account.rest.model.AccountPreferencesInput;
import org.eclipse.osee.framework.core.data.ArtifactId;

public class AccountPreferencesResource {
    private final AccountOps accountOps;
    private final ArtifactId accountId;

    public AccountPreferencesResource(AccountOps accountOps, ArtifactId accountId) {
        this.accountOps = accountOps;
        this.accountId = accountId;
    }

    @GET
    @RolesAllowed(value={"authenticated"})
    @Produces(value={"application/json", "application/xml"})
    public AccountPreferencesData getAccountPreferences() {
        return this.accountOps.getAccountPreferencesDataById(this.accountId);
    }

    @PUT
    @RolesAllowed(value={"authenticated"})
    @Consumes(value={"application/json", "application/xml"})
    public Response setAccountPreferences(AccountPreferencesInput input) {
        boolean modified = this.accountOps.setAccountPreferences(this.accountId, input);
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }
}

