/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.parts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.GraphCache;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;
import org.eclipse.osee.framework.ui.branch.graph.parts.BranchDataEditPart;
import org.eclipse.osee.framework.ui.branch.graph.parts.BranchEditPart;
import org.eclipse.osee.framework.ui.branch.graph.parts.GraphEditPart;
import org.eclipse.osee.framework.ui.branch.graph.parts.LabelEditPart;
import org.eclipse.osee.framework.ui.branch.graph.parts.TxEditPart;

public class GraphEditPartFactory
implements EditPartFactory {
    private final GraphicalViewer viewer;

    public GraphEditPartFactory(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        AbstractGraphicalEditPart editPart = null;
        if (model instanceof String) {
            editPart = new LabelEditPart((String)model);
        } else if (model instanceof GraphCache) {
            editPart = new GraphEditPart(this.viewer);
        } else if (model instanceof BranchModel) {
            editPart = new BranchEditPart();
        } else if (model instanceof BranchId) {
            editPart = new BranchDataEditPart();
        } else if (model instanceof TxModel) {
            editPart = new TxEditPart();
        }
        if (editPart == null) {
            throw new RuntimeException(String.format("Error no EditPart defined for: [%s]", model.getClass().getName()));
        }
        editPart.setModel(model);
        return editPart;
    }
}

