/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;
import org.eclipse.osee.framework.skynet.core.linking.WordMlLinkHandler;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.swt.program.Program;

public class FindErroneousEmbeddedLinksBlam
extends AbstractBlam {
    private static final String BRANCH = "Branch Input";
    private static final String ARTIFACT_TYPES = "Artifact Types";

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<xWidgets><XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"%s\"/>", BRANCH));
        builder.append(String.format("<XWidget xwidgetType=\"XArtifactTypeMultiChoiceSelect\" displayName=\"%s\" />", ARTIFACT_TYPES));
        builder.append("</xWidgets>");
        return builder.toString();
    }

    public String getDescriptionUsage() {
        return "For a given branch, locate all WordTemplateContent attributes and list those artifacts with invalid hyperlinks";
    }

    public String getName() {
        return "Find Erroneous Hyperlinks";
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        File file = OseeData.getFile((String)("INVALID_LINKS_" + dateFormat.format(date) + ".xml"));
        ExcelXmlWriter excelWriter = new ExcelXmlWriter(file);
        BranchToken branch = variableMap.getBranch(BRANCH);
        ArtifactTypeToken[] artifactTypes = (ArtifactTypeToken[])variableMap.getArtifactTypes(ARTIFACT_TYPES).stream().toArray(ArtifactTypeToken[]::new);
        QueryBuilderArtifact queryBuilder = ArtifactQuery.createQueryBuilder((BranchId)branch);
        queryBuilder.andExists(new AttributeTypeId[]{CoreAttributeTypes.WordTemplateContent});
        ResultSet arts = queryBuilder.getResults();
        Iterator artIter = arts.iterator();
        excelWriter.startSheet("Invalid Links", 6);
        excelWriter.writeRow(new Object[]{"Type", "Artifact", "Artifact Type", "Guid", "Subsystem", "Invalid Link Guid"});
        while (artIter.hasNext()) {
            Artifact artifact = (Artifact)artIter.next();
            if (artifact.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.WordTemplateContent) && artifact.isOfType((ArtifactTypeId[])artifactTypes)) {
                try {
                    String content = artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, "");
                    if (Strings.isValid((String)content)) {
                        this.findIncorrectLinks(artifact, content, (ISheetWriter)excelWriter);
                    }
                }
                catch (OseeCoreException ex) {
                    this.logf("Artifact: [%s]: [%s]", new Object[]{artifact.getName(), ex});
                }
            }
            artIter.remove();
        }
        excelWriter.endSheet();
        excelWriter.endWorkbook();
        Program.launch((String)file.getAbsolutePath());
    }

    private void findIncorrectLinks(Artifact artifact, String content, ISheetWriter excelWriter) throws IOException {
        HashSet<String> unknownGuids = new HashSet<String>();
        HashCollection errorMap = new HashCollection();
        HashCollection links = WordMlLinkHandler.getLinks((String)content, (HashCollection)errorMap);
        if (!links.isEmpty()) {
            unknownGuids.addAll(links.keySet());
        }
        this.findInvalid(artifact, excelWriter, unknownGuids);
        unknownGuids.clear();
        if (!errorMap.isEmpty()) {
            unknownGuids.addAll(errorMap.keySet());
        }
        this.findInvalid(artifact, excelWriter, unknownGuids);
    }

    private void findInvalid(Artifact artifact, ISheetWriter excelWriter, Set<String> unknownGuids) throws IOException {
        Iterator<String> guidIter = unknownGuids.iterator();
        while (guidIter.hasNext()) {
            String linkGuid = guidIter.next();
            this.logLinksToSelf(artifact, linkGuid, excelWriter);
            this.logInvalidGuidLink(artifact, linkGuid, excelWriter);
            guidIter.remove();
        }
    }

    private void logInvalidGuidLink(Artifact artifact, String linkGuid, ISheetWriter excelWriter) throws IOException {
        try {
            ArtifactQuery.getArtifactFromId((String)linkGuid, (BranchId)artifact.getBranch());
        }
        catch (Exception exception) {
            String subsystem = artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, "");
            excelWriter.writeRow(new Object[]{"Invalid", artifact.getName(), artifact.getArtifactType().getName(), artifact.getGuid(), subsystem, linkGuid == null ? "NULL" : linkGuid});
        }
    }

    private void logLinksToSelf(Artifact artifact, String linkGuid, ISheetWriter excelWriter) throws IOException {
        String subsystem = artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, "");
        if (linkGuid != null && linkGuid.equals(artifact.getGuid())) {
            excelWriter.writeRow(new Object[]{"Link to Self", artifact.getName(), artifact.getArtifactType().getName(), artifact.getGuid(), subsystem, linkGuid});
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_HEALTH);
    }
}

