/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.blam;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.data.BaseTraceDataCache;
import org.eclipse.osee.define.ide.traceability.data.CodeUnitData;
import org.eclipse.osee.define.ide.traceability.data.RequirementData;
import org.eclipse.osee.define.ide.traceability.data.TestUnitData;
import org.eclipse.osee.define.ide.traceability.report.AbstractArtifactRelationReport;
import org.eclipse.osee.define.ide.traceability.report.ArtifactToRelatedArtifact;
import org.eclipse.osee.define.ide.traceability.report.ArtifactTraceCount;
import org.eclipse.osee.define.ide.traceability.report.ArtifactsWithoutRelations;
import org.eclipse.osee.define.ide.traceability.report.IReportDataCollector;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.html.ResultsEditorHtmlTab;
import org.eclipse.osee.framework.ui.skynet.results.table.IResultsXViewerRow;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TraceReportBlam
extends AbstractBlam {
    private static final String BRANCH = "Branch";
    private final List<IResultsEditorTab> resultsTabs = new ArrayList<IResultsEditorTab>();
    private XCombo branchViewWidget;
    private XBranchSelectWidget branchWidget;

    public String getName() {
        return "Trace Report";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.TRACE);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.TRACE);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.TRACE);
    }

    public String getDescriptionUsage() {
        return "Generates a trace report by scanning the selected branch for the selected trace unit types.";
    }

    private String getOperationsCheckBoxes(String value) {
        StringBuilder builder = new StringBuilder();
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"");
        builder.append(value);
        builder.append("\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
        return builder.toString();
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Requirements Branch\" />");
        builder.append("<XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/>");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select Trace Types:\"/>");
        TraceTypeEnum[] traceTypeEnumArray = TraceTypeEnum.values();
        int n = traceTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceTypeEnum traceType = traceTypeEnumArray[n2];
            builder.append(this.getOperationsCheckBoxes(traceType.asLabel()));
            ++n2;
        }
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select Report Output:\"/>");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Result Editor\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Excel\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    private List<TraceTypeEnum> getCheckedTraceItems(VariableMap variableMap) {
        ArrayList<TraceTypeEnum> toReturn = new ArrayList<TraceTypeEnum>();
        TraceTypeEnum[] traceTypeEnumArray = TraceTypeEnum.values();
        int n = traceTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceTypeEnum traceType = traceTypeEnumArray[n2];
            if (variableMap.getBoolean(traceType.asLabel())) {
                toReturn.add(traceType);
            }
            ++n2;
        }
        return toReturn;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        boolean isResultEditorOutput;
        BranchToken branch = variableMap.getBranch("Requirements Branch");
        if (branch == null) {
            throw new OseeArgumentException("Branch cannot be null", new Object[0]);
        }
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        List<TraceTypeEnum> traceTypes = this.getCheckedTraceItems(variableMap);
        if (traceTypes.isEmpty()) {
            throw new OseeArgumentException("Please select a trace type", new Object[0]);
        }
        boolean isExcelOutput = variableMap.getBoolean("Excel");
        OutputType output = OutputType.asType(isExcelOutput, isResultEditorOutput = variableMap.getBoolean("Result Editor"));
        if (output == null) {
            throw new OseeArgumentException("Please select a report output type", new Object[0]);
        }
        ExcelXmlWriter writer = null;
        CharBackedInputStream excelInputStream = null;
        LinkedHashMap<String, AbstractArtifactRelationReport> reports = new LinkedHashMap<String, AbstractArtifactRelationReport>();
        ArrayList<BaseTraceDataCache> traceCache = new ArrayList<BaseTraceDataCache>();
        RequirementData reqData = new RequirementData((BranchId)branch, (ArtifactId)this.viewId);
        CodeUnitData codeUnit = null;
        TestUnitData testUnit = null;
        try {
            int TOTAL_WORK = Integer.MAX_VALUE;
            int TASK_WORK = TOTAL_WORK / 5;
            monitor.beginTask("Generate Trace Report", TOTAL_WORK);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, TASK_WORK);
            reqData.initialize((IProgressMonitor)subMonitor);
            traceCache.add(reqData);
            subMonitor = new SubProgressMonitor(monitor, TASK_WORK);
            if (TraceTypeEnum.Code_Unit_Trace.isIn(traceTypes)) {
                codeUnit = new CodeUnitData((BranchId)branch);
                codeUnit.initialize((IProgressMonitor)subMonitor);
                traceCache.add(codeUnit);
            } else {
                subMonitor.done();
            }
            subMonitor = new SubProgressMonitor(monitor, TASK_WORK);
            if (TraceTypeEnum.containsTestEnum(traceTypes)) {
                testUnit = new TestUnitData((BranchId)branch);
                testUnit.initialize((IProgressMonitor)subMonitor);
                traceCache.add(testUnit);
            } else {
                subMonitor.done();
            }
            if (!monitor.isCanceled()) {
                if (this.isExcelOutput(output)) {
                    excelInputStream = new CharBackedInputStream();
                    writer = new ExcelXmlWriter(excelInputStream.getWriter());
                }
                this.buildReport(reports, "Trace Unit <-> Requirement", output, (ISheetWriter)writer, this.getTraceUnitToReqReport(codeUnit, testUnit, traceTypes));
                this.buildReport(reports, "Trace Unit with No Valid Traceability", output, (ISheetWriter)writer, this.getDisconnectedTraceUnitReport(codeUnit, testUnit, traceTypes));
                this.buildReport(reports, "Requirement Trace Counts", output, (ISheetWriter)writer, this.getTraceCountReport(reqData, traceTypes));
                subMonitor = new SubProgressMonitor(monitor, TASK_WORK);
                this.executeReports((IProgressMonitor)subMonitor, reports);
            }
            subMonitor = new SubProgressMonitor(monitor, TASK_WORK);
            this.displayReports((IProgressMonitor)subMonitor, (ISheetWriter)writer, excelInputStream, output);
        }
        finally {
            try {
                for (AbstractArtifactRelationReport report : reports.values()) {
                    report.clear();
                }
                for (BaseTraceDataCache cache : traceCache) {
                    cache.reset();
                }
                reports.clear();
                traceCache.clear();
                this.resultsTabs.clear();
            }
            finally {
                monitor.done();
            }
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(BRANCH)) {
            this.branchWidget = (XBranchSelectWidget)xWidget;
            this.branchWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (TraceReportBlam.this.branchViewWidget != null) {
                        TraceReportBlam.this.branchViewWidget.setEditable(true);
                        BranchToken branch = TraceReportBlam.this.branchWidget.getSelection();
                        if (branch != null && branch.isValid()) {
                            TraceReportBlam.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            TraceReportBlam.this.branchViewWidget.setDataStrings(TraceReportBlam.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    private void executeReports(IProgressMonitor monitor, Map<String, AbstractArtifactRelationReport> reports) {
        try {
            monitor.beginTask("Create Reports", reports.size());
            for (String key : reports.keySet()) {
                monitor.subTask(String.format("Creating [%s]", key));
                if (monitor.isCanceled()) {
                    break;
                }
                AbstractArtifactRelationReport report = reports.get(key);
                report.process(monitor);
                report.clear();
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void displayReports(IProgressMonitor monitor, ISheetWriter excelWriter, CharBackedInputStream excelInputStream, OutputType outputType) throws IOException {
        try {
            boolean excelValid;
            boolean wasEmpty = this.resultsTabs == null || this.resultsTabs.isEmpty();
            monitor.beginTask("Open Reports", 2);
            boolean createReport = true;
            boolean bl = excelValid = excelInputStream != null && excelInputStream.available() > 0;
            if (wasEmpty && !excelValid) {
                if (this.resultsTabs != null) {
                    this.resultsTabs.add((IResultsEditorTab)new ResultsEditorHtmlTab(this.getName(), this.getName(), "Nothing Reported"));
                }
                createReport = false;
            }
            this.openReport(this.resultsTabs);
            monitor.worked(1);
            if (createReport && excelWriter != null && this.isExcelOutput(outputType)) {
                excelWriter.endWorkbook();
                this.openExcel((InputStream)excelInputStream);
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private boolean isExcelOutput(OutputType output) {
        return output == OutputType.Excel || output == OutputType.Both;
    }

    private boolean isEditorOutput(OutputType output) {
        return output == OutputType.ResultsEditor || output == OutputType.Both;
    }

    private void buildReport(Map<String, AbstractArtifactRelationReport> reports, String title, OutputType output, ISheetWriter writer, AbstractArtifactRelationReport report) {
        if (this.isExcelOutput(output)) {
            report.addReportDataCollector(new ExcelReport(title, writer));
        }
        if (this.isEditorOutput(output)) {
            report.addReportDataCollector(new ResultEditorReport(title));
        }
        reports.put(title, report);
    }

    private void openExcel(InputStream inputStream) {
        IFile iFile = OseeData.getIFile((String)("Trace_Report_" + Lib.getDateTimeString() + ".xml"));
        AIFile.writeToFile((IFile)iFile, (InputStream)inputStream);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        Program.launch((String)iFile.getLocation().toOSString());
    }

    private void openReport(List<IResultsEditorTab> resultsTabs) {
        final ArrayList<IResultsEditorTab> results = new ArrayList<IResultsEditorTab>(resultsTabs);
        if (!results.isEmpty()) {
            IExceptionableRunnable runnable = new IExceptionableRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){

                        public String getEditorName() {
                            return TraceReportBlam.this.getName();
                        }

                        public List<IResultsEditorTab> getResultsEditorTabs() {
                            return results;
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            Jobs.runInJob((String)this.getName(), (IExceptionableRunnable)runnable, Activator.class, (String)"org.eclipse.osee.define.ide");
        }
    }

    private void addRelationToCheck(List<TraceTypeEnum> traceTypes, AbstractArtifactRelationReport report, boolean fromTraceUnit) {
        for (TraceTypeEnum traceTypeEnum : traceTypes) {
            RelationTypeSide relation = fromTraceUnit ? traceTypeEnum.getRelatedToRequirement() : traceTypeEnum.getRelatedToTraceUnit();
            report.addRelationToCheck(relation);
        }
    }

    private void addArtifacts(CodeUnitData codeUnit, TestUnitData testUnit, List<TraceTypeEnum> traceTypes, AbstractArtifactRelationReport report) {
        if (TraceTypeEnum.Code_Unit_Trace.isIn(traceTypes)) {
            report.setArtifacts(codeUnit.getAllCodeUnits());
        }
        if (TraceTypeEnum.Verified_By_Test_Unit_Trace.isIn(traceTypes)) {
            report.setArtifacts(testUnit.getTestCases());
        }
        if (TraceTypeEnum.Used_By_Test_Unit_Trace.isIn(traceTypes)) {
            report.setArtifacts(testUnit.getTestSupportItems());
        }
        if (TraceTypeEnum.Validation_By_TestProcedure.isIn(traceTypes)) {
            report.setArtifacts(testUnit.getTestProcedures());
        }
    }

    private AbstractArtifactRelationReport getTraceCountReport(RequirementData reqData, List<TraceTypeEnum> traceTypes) {
        ArtifactTraceCount report = new ArtifactTraceCount();
        report.setArtifacts(reqData.getDirectRequirements());
        this.addRelationToCheck(traceTypes, report, false);
        return report;
    }

    private AbstractArtifactRelationReport getDisconnectedTraceUnitReport(CodeUnitData codeUnit, TestUnitData testUnit, List<TraceTypeEnum> traceTypes) {
        ArtifactsWithoutRelations report = new ArtifactsWithoutRelations();
        this.addArtifacts(codeUnit, testUnit, traceTypes, report);
        this.addRelationToCheck(traceTypes, report, true);
        return report;
    }

    private AbstractArtifactRelationReport getTraceUnitToReqReport(CodeUnitData codeUnit, TestUnitData testUnit, List<TraceTypeEnum> traceTypes) {
        ArtifactToRelatedArtifact report = new ArtifactToRelatedArtifact();
        this.addArtifacts(codeUnit, testUnit, traceTypes, report);
        this.addRelationToCheck(traceTypes, report, true);
        return report;
    }

    private static final class ExcelReport
    implements IReportDataCollector {
        private final String title;
        private final ISheetWriter sheetWriter;

        public ExcelReport(String title, ISheetWriter sheetWriter) {
            this.sheetWriter = sheetWriter;
            this.title = title;
        }

        @Override
        public void addRow(Object data, String ... row) {
            try {
                this.sheetWriter.writeRow((Object[])row);
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }

        @Override
        public void addTableHeader(String ... header) {
            try {
                this.sheetWriter.startSheet(this.title, header.length);
                this.sheetWriter.writeRow((Object[])header);
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }

        @Override
        public void endTable() {
            try {
                this.sheetWriter.endSheet();
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    private static enum OutputType {
        ResultsEditor,
        Excel,
        Both;


        public static OutputType asType(boolean isExcel, boolean isEditor) {
            if (isExcel && isEditor) {
                return Both;
            }
            if (isExcel) {
                return Excel;
            }
            if (isEditor) {
                return ResultsEditor;
            }
            return null;
        }
    }

    private final class ResultEditorReport
    implements IReportDataCollector {
        private final String title;
        private List<XViewerColumn> columns;
        private List<IResultsXViewerRow> rows;

        public ResultEditorReport(String title) {
            this.title = title;
            this.columns = null;
            this.rows = null;
        }

        @Override
        public void addRow(Object data, String ... row) {
            if (this.rows == null) {
                this.rows = new ArrayList<IResultsXViewerRow>();
            }
            this.rows.add((IResultsXViewerRow)new ResultsXViewerRow(row, data));
        }

        @Override
        public void addTableHeader(String ... header) {
            this.columns = new ArrayList<XViewerColumn>();
            String[] stringArray = header;
            int n = header.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.columns.add(new XViewerColumn(name, name, 80, XViewerAlign.Left, true, SortDataType.String, false, ""));
                ++n2;
            }
        }

        @Override
        public void endTable() {
            TraceReportBlam.this.resultsTabs.add((IResultsEditorTab)new ResultsEditorTableTab(this.title, this.columns, this.rows));
        }
    }

    private static enum TraceTypeEnum {
        Code_Unit_Trace(CoreRelationTypes.CodeRequirement_Requirement, CoreRelationTypes.CodeRequirement_CodeUnit, false),
        Verified_By_Test_Unit_Trace(CoreRelationTypes.Verification_Requirement, CoreRelationTypes.Verification_Verifier, true),
        Used_By_Test_Unit_Trace(CoreRelationTypes.Uses_Requirement, CoreRelationTypes.Uses_TestUnit, true),
        Validation_By_TestProcedure(CoreRelationTypes.Validation_Requirement, CoreRelationTypes.Validation_Validator, true);

        private RelationTypeSide toReq;
        private RelationTypeSide toTraceUnit;
        private boolean isTestType;

        private TraceTypeEnum(RelationTypeSide toReq, RelationTypeSide toTraceUnit, boolean isTestType) {
            this.toReq = toReq;
            this.toTraceUnit = toTraceUnit;
            this.isTestType = isTestType;
        }

        public RelationTypeSide getRelatedToRequirement() {
            return this.toReq;
        }

        public RelationTypeSide getRelatedToTraceUnit() {
            return this.toTraceUnit;
        }

        public boolean isTestType() {
            return this.isTestType;
        }

        public String asLabel() {
            return this.name().replaceAll("_", " ");
        }

        public boolean isIn(Collection<TraceTypeEnum> traceTypes) {
            return traceTypes.contains((Object)this);
        }

        public static boolean containsTestEnum(List<TraceTypeEnum> traceTypes) {
            TraceTypeEnum[] traceTypeEnumArray = TraceTypeEnum.values();
            int n = traceTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TraceTypeEnum type = traceTypeEnumArray[n2];
                if (type.isTestType() && type.isIn(traceTypes)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

