/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.data;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public abstract class BaseTraceDataCache {
    private boolean isInitialized = false;
    private final BranchId branch;
    private final String traceType;

    public BaseTraceDataCache(String traceType, BranchId branch) {
        this.traceType = traceType;
        this.branch = branch;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public final IStatus initialize(IProgressMonitor monitor) {
        IStatus toReturn = Status.CANCEL_STATUS;
        try {
            this.reset();
            monitor.subTask(String.format("Loading %s from: [%s]", this.traceType, this.getBranch()));
            this.doBulkLoad(monitor);
            if (!monitor.isCanceled()) {
                toReturn = Status.OK_STATUS;
            }
            this.isInitialized = true;
        }
        catch (Exception ex) {
            toReturn = new Status(4, "org.eclipse.osee.define.ide", String.format("Loading %s ", this.traceType), (Throwable)ex);
        }
        return toReturn;
    }

    protected abstract void doBulkLoad(IProgressMonitor var1) throws Exception;

    protected void populateTraceMap(IProgressMonitor monitor, List<Artifact> artList, Map<String, Artifact> toPopulate) {
        for (Artifact artifact : artList) {
            toPopulate.put(this.asTraceMapKey(artifact), artifact);
        }
    }

    protected String asTraceMapKey(Artifact artifact) {
        return artifact.getName();
    }

    public void reset() {
        this.isInitialized = false;
    }
}

