/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.define.ide.traceability.BranchTraceabilityOperation;
import org.eclipse.osee.define.ide.traceability.RequirementTraceabilityData;
import org.eclipse.osee.define.ide.traceability.ScriptTraceabilityOperation;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.define.ide.traceability.TraceabilityFactory;
import org.eclipse.osee.define.ide.traceability.TraceabilityProviderOperation;
import org.eclipse.osee.define.ide.traceability.TraceabilityTable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PublishStdStpTraceability
extends AbstractBlam {
    private static final String PROGRAM_BRANCH = "Program Branch";
    private static final String scriptDirectory = "<XWidget xwidgetType=\"XText\" displayName=\"Script Root Directory\" defaultValue=\"C:/UserData/workspaceScripts\"/>";
    private static final String requirementsBranch = "<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Program Branch\" defaultValue=\"\" />";
    private static final String artifactTypeChooser = "<XWidget xwidgetType=\"XArtifactTypeMultiChoiceSelect\" displayName=\"Artifact Type(s) to Trace\" defaultValue=\"" + CoreArtifactTypes.SoftwareRequirementMsWord.getName() + "\"/>";
    private static final String searchInheritedTypes = "<XWidget xwidgetType=\"XCheckBox\" displayName=\"Search Inherited Types\" labelAfter=\"true\" horizontalLabel=\"true\" defaultValue=\"false\" />";
    private static final String useGitCodeStructure = "<XWidget xwidgetType=\"XCheckBox\" displayName=\"Search Git Code Structure\" labelAfter=\"true\" horizontalLabel=\"true\" defaultValue=\"false\" />";
    private static final String TRACE_HANDLER_CHECKBOX = "<XWidget xwidgetType=\"XCheckBox\" displayName=\"%s\" labelAfter=\"true\" horizontalLabel=\"true\"/>";
    private static final String includeImpd = "<XWidget xwidgetType=\"XCheckBox\" displayName=\"Include IMPD\" labelAfter=\"true\" horizontalLabel=\"true\" defaultValue=\"false\" />";
    private Collection<String> availableTraceHandlers;
    private XCombo branchViewWidget;
    private XBranchSelectWidget branchWidget;

    public String getName() {
        return "Publish STD/STP Traceability";
    }

    public String getDescriptionUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("<form>This BLAM can be ran where test traceability is either stored in OSEE");
        sb.append(" via relations OR by parsing test scripts for embedded tracemarks.<br/>");
        sb.append("<li>If a script parser is not selected, BLAM will assume test traceability is stored in OSEE</li>");
        sb.append("<br/>Click the play button at the top right or in the Execute section.</form>");
        return sb.toString();
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select tables to generate:\"/>");
        TraceabilityFactory.TraceabilityStyle[] traceabilityStyleArray = TraceabilityFactory.TraceabilityStyle.values();
        int n = traceabilityStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceabilityFactory.TraceabilityStyle style = traceabilityStyleArray[n2];
            builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"");
            builder.append(style.asLabel());
            builder.append("\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
            ++n2;
        }
        builder.append(requirementsBranch);
        builder.append("<XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/>");
        builder.append(artifactTypeChooser);
        builder.append(searchInheritedTypes);
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"===  For traceability stored in test scripts, select the following  ===\" />");
        builder.append(useGitCodeStructure);
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"===  To include IMPD, select the following  ===\" />");
        builder.append(includeImpd);
        this.availableTraceHandlers = new LinkedList<String>();
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select appropriate script parser:\" />");
        List<String> traceHandlers = TraceUnitExtensionManager.getInstance().getAllTraceHandlerNames();
        for (String handler : traceHandlers) {
            builder.append(String.format(TRACE_HANDLER_CHECKBOX, handler));
            this.availableTraceHandlers.add(handler);
        }
        builder.append(scriptDirectory);
        builder.append("</xWidgets>");
        return builder.toString();
    }

    private List<TraceabilityFactory.TraceabilityStyle> getStyles(VariableMap variableMap) {
        ArrayList<TraceabilityFactory.TraceabilityStyle> styles = new ArrayList<TraceabilityFactory.TraceabilityStyle>();
        TraceabilityFactory.TraceabilityStyle[] traceabilityStyleArray = TraceabilityFactory.TraceabilityStyle.values();
        int n = traceabilityStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceabilityFactory.TraceabilityStyle style = traceabilityStyleArray[n2];
            boolean isSelected = variableMap.getBoolean(style.asLabel());
            if (isSelected) {
                styles.add(style);
            }
            ++n2;
        }
        return styles;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        BranchToken requirementsBranch = variableMap.getBranch(PROGRAM_BRANCH);
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        Collection types = variableMap.getCollection(ArtifactTypeToken.class, "Artifact Type(s) to Trace");
        boolean searchInherited = variableMap.getBoolean("Search Inherited Types");
        File scriptDir = new File(variableMap.getString("Script Root Directory"));
        List<TraceabilityFactory.TraceabilityStyle> selectedReports = this.getStyles(variableMap);
        LinkedList<TraceUnitExtensionManager.TraceHandler> traceHandlers = new LinkedList<TraceUnitExtensionManager.TraceHandler>();
        for (String handler : this.availableTraceHandlers) {
            if (!variableMap.getBoolean(handler)) continue;
            TraceUnitExtensionManager.TraceHandler traceHandler = TraceUnitExtensionManager.getInstance().getTraceHandlerByName(handler);
            traceHandlers.add(traceHandler);
        }
        int totalWork = selectedReports.size() * 2 + 1;
        monitor.beginTask("Generate Traceability Tables", totalWork);
        if (selectedReports.size() > 0) {
            TraceabilityProviderOperation provider;
            if (traceHandlers.isEmpty()) {
                provider = new BranchTraceabilityOperation((BranchId)requirementsBranch, types, searchInherited, (ArtifactId)this.viewId);
            } else {
                boolean isGitBased = variableMap.getBoolean("Search Git Code Structure");
                boolean includeImpd = variableMap.getBoolean("Include IMPD");
                provider = new ScriptTraceabilityOperation(scriptDir, (BranchId)requirementsBranch, false, types, searchInherited, traceHandlers, isGitBased, (ArtifactId)this.viewId, includeImpd);
            }
            RequirementTraceabilityData traceabilityData = new RequirementTraceabilityData((BranchId)requirementsBranch, provider, (ArtifactId)this.viewId);
            IStatus status = traceabilityData.initialize(monitor);
            if (status.getSeverity() == 8) {
                monitor.setCanceled(true);
            } else if (status.getSeverity() == 0) {
                monitor.worked(1);
                int count = 0;
                ArrayList<IFile> files = new ArrayList<IFile>();
                for (TraceabilityFactory.TraceabilityStyle style : selectedReports) {
                    monitor.subTask(String.format("Creating table: [%s] [%s of %s]", style.asLabel(), ++count, selectedReports.size()));
                    TraceabilityTable table = TraceabilityFactory.getTraceabilityTable(style, traceabilityData);
                    if (table != null) {
                        table.run(monitor);
                    }
                    monitor.worked(1);
                    if (table != null) {
                        monitor.subTask(String.format("Writing table: [%s] [%s of %s]", style.asLabel(), count, selectedReports.size()));
                        String fileName = String.valueOf(style.toString()) + "." + Lib.getDateTimeString() + ".xml";
                        IFile iFile = OseeData.getIFile((String)fileName);
                        AIFile.writeToFile((IFile)iFile, (String)table.toString());
                        files.add(iFile);
                    }
                    monitor.worked(1);
                }
                for (IFile iFile : files) {
                    Program.launch((String)iFile.getLocation().toOSString());
                }
            } else {
                throw new Exception(status.getMessage(), status.getException());
            }
        }
        monitor.subTask("Done");
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(PROGRAM_BRANCH)) {
            this.branchWidget = (XBranchSelectWidget)xWidget;
            this.branchWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (PublishStdStpTraceability.this.branchViewWidget != null) {
                        PublishStdStpTraceability.this.branchViewWidget.setEditable(true);
                        BranchToken branch = PublishStdStpTraceability.this.branchWidget.getSelection();
                        if (branch != null && branch.isValid()) {
                            PublishStdStpTraceability.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            PublishStdStpTraceability.this.branchViewWidget.setDataStrings(PublishStdStpTraceability.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.TRACE);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.TRACE);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.TRACE);
    }
}

