/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.utility;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.utility.IResourceHandler;
import org.eclipse.osee.define.ide.utility.IResourceLocator;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class UriResourceContentFinder {
    private final Iterable<URI> sources;
    private final HashCollection<IResourceLocator, IResourceHandler> locatorMap;
    private final boolean isRecursionAllowed;
    private final boolean isFileWithMultiplePaths;

    public UriResourceContentFinder(Iterable<URI> sources, boolean isRecursionAllowed, boolean isFileWithMultiplePaths) {
        this.sources = sources;
        this.isRecursionAllowed = isRecursionAllowed;
        this.isFileWithMultiplePaths = isFileWithMultiplePaths;
        this.locatorMap = new HashCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocator(IResourceLocator locator, IResourceHandler ... handler) {
        if (locator != null && handler != null && handler.length > 0) {
            HashCollection<IResourceLocator, IResourceHandler> hashCollection = this.locatorMap;
            synchronized (hashCollection) {
                this.locatorMap.put((Object)locator, Arrays.asList(handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocator(IResourceLocator locator) {
        if (locator != null) {
            HashCollection<IResourceLocator, IResourceHandler> hashCollection = this.locatorMap;
            synchronized (hashCollection) {
                this.locatorMap.removeValues((Object)locator);
            }
        }
    }

    public void execute(IProgressMonitor monitor) {
        try {
            try {
                for (URI source : this.sources) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    IFileStore fileStore = EFS.getStore((URI)source);
                    if (this.isFileWithMultiplePaths) {
                        this.processFileWithPaths(monitor, fileStore);
                        continue;
                    }
                    monitor.beginTask("Scanning files", 1);
                    this.processFileStore(monitor, fileStore);
                    monitor.worked(1);
                }
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void processFileWithPaths(IProgressMonitor monitor, IFileStore fileStore) throws Exception {
        IFileInfo info = fileStore.fetchInfo(0, monitor);
        if (info != null && info.exists()) {
            ArrayList paths = Lib.readListFromFile((File)new File(fileStore.toURI()), (boolean)true);
            monitor.beginTask("Searching for files", paths.size());
            for (String path : paths) {
                if (Strings.isValid((String)path)) {
                    this.processFileStore(monitor, EFS.getStore((URI)new File(path).toURI()));
                }
                if (!monitor.isCanceled()) {
                    monitor.worked(1);
                    continue;
                }
                break;
            }
        } else {
            monitor.beginTask("Searching for files", 1);
        }
    }

    private void processFileStore(IProgressMonitor monitor, IFileStore fileStore) throws Exception {
        IFileInfo info = fileStore.fetchInfo(0, monitor);
        if (info != null && info.exists()) {
            if (info.isDirectory()) {
                this.processDirectory(monitor, fileStore);
            } else {
                this.processFile(monitor, fileStore);
            }
        }
    }

    private boolean isValidDirectory(IProgressMonitor monitor, IFileStore fileStore) {
        boolean result = false;
        for (IResourceLocator locator : this.locatorMap.keySet()) {
            if (monitor.isCanceled()) break;
            if (!locator.isValidDirectory(fileStore)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void processDirectory(IProgressMonitor monitor, IFileStore fileStore) throws Exception {
        if (this.isValidDirectory(monitor, fileStore)) {
            boolean isProcessingAllowed = false;
            IFileStore[] iFileStoreArray = fileStore.childStores(0, monitor);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore childStore = iFileStoreArray[n2];
                isProcessingAllowed = false;
                if (monitor.isCanceled()) break;
                isProcessingAllowed = !this.isRecursionAllowed ? !childStore.fetchInfo().isDirectory() : true;
                if (isProcessingAllowed) {
                    this.processFileStore(monitor, childStore);
                }
                ++n2;
            }
        }
        monitor.worked(1);
    }

    private void processFile(IProgressMonitor monitor, IFileStore fileStore) throws Exception {
        if (!monitor.isCanceled()) {
            for (IResourceLocator locator : this.locatorMap.keySet()) {
                CharBuffer fileBuffer;
                if (!locator.isValidFile(fileStore) || !locator.hasValidContent(fileBuffer = this.getContents(monitor, fileStore))) continue;
                String fileName = locator.getIdentifier(fileStore, fileBuffer).getName();
                if (monitor.isCanceled()) continue;
                monitor.subTask(String.format("processing [%s]", fileStore.getName()));
                this.notifyListeners(locator, fileStore.toURI(), fileName, fileBuffer);
            }
        }
        monitor.worked(1);
    }

    private CharBuffer getContents(IProgressMonitor monitor, IFileStore fileStore) throws Exception {
        CharBuffer toReturn = null;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(fileStore.openInputStream(0, monitor));
            toReturn = Lib.inputStreamToCharBuffer((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error closing stream for resource: [%s]", (Object[])new Object[]{fileStore.getName()});
                }
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error closing stream for resource: [%s]", (Object[])new Object[]{fileStore.getName()});
            }
        }
        return toReturn;
    }

    private void notifyListeners(IResourceLocator locator, URI uriPath, String fileName, CharBuffer fileBuffer) {
        for (IResourceHandler handler : (List)this.locatorMap.getValues((Object)locator)) {
            handler.onResourceFound(uriPath, fileName, fileBuffer);
        }
    }
}

