/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.net.InetAddress;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class IPAddressBox
extends Composite {
    private static final String PERIOD_SEPARATOR = ".";
    private static final String DASH_SEPARATOR = "-";
    private static final int NUM_BOXES = 4;
    private final Text[] box = new Text[4];
    private Color background;
    private final Text sep3;
    private final Text sep2;
    private final Text sep1;

    public IPAddressBox(Composite parent) {
        this(parent, true, 2048);
    }

    public IPAddressBox(Composite parent, int style, String separator) {
        super(parent, style);
        Widgets.setFormLayout(this, 0, 0);
        this.background = (style & 8) > 0 ? parent.getBackground() : this.getDisplay().getSystemColor(1);
        this.setBackground(this.background);
        int NO_BORDER_MASK = -2049;
        this.sep1 = new Text((Composite)this, 0x1000008);
        this.sep1.setText(separator);
        this.sep1.setBackground(this.background);
        Widgets.attachToParent((Control)this.sep1, 16384, 25, -2);
        Widgets.attachToParent((Control)this.sep1, 128, 0, 0);
        this.sep2 = new Text((Composite)this, 0x1000008);
        this.sep2.setText(separator);
        this.sep2.setBackground(this.background);
        Widgets.attachToParent((Control)this.sep2, 16384, 50, -2);
        Widgets.attachToControl((Control)this.sep2, (Control)this.sep1, 128, 128, 0);
        this.sep3 = new Text((Composite)this, 0x1000008);
        this.sep3.setText(separator);
        this.sep3.setBackground(this.background);
        Widgets.attachToParent((Control)this.sep3, 16384, 75, -2);
        Widgets.attachToControl((Control)this.sep3, (Control)this.sep1, 128, 128, 0);
        this.box[0] = new Text((Composite)this, 0x20004 | style & NO_BORDER_MASK);
        this.box[0].setTextLimit(3);
        this.box[0].setBackground(this.background);
        new Widgets.IntegerTextEntryHandler(this.box[0], false, 3){

            @Override
            public void applyValue(long value) {
                IPAddressBox.this.clamp(IPAddressBox.this.box[0], value);
            }
        };
        Widgets.attachToParent((Control)this.box[0], 16384, 0, 0);
        Widgets.attachToControl((Control)this.box[0], (Control)this.sep1, 131072, 16384, 0);
        Widgets.attachToControl((Control)this.box[0], (Control)this.sep1, 128, 0x1000000, 0);
        this.box[1] = new Text((Composite)this, 0x20004 | style & NO_BORDER_MASK);
        this.box[1].setTextLimit(3);
        this.box[1].setBackground(this.background);
        new Widgets.IntegerTextEntryHandler(this.box[1], false, 3){

            @Override
            public void applyValue(long value) {
                IPAddressBox.this.clamp(IPAddressBox.this.box[1], value);
            }
        };
        Widgets.attachToControl((Control)this.box[1], (Control)this.sep1, 16384, 131072, 0);
        Widgets.attachToControl((Control)this.box[1], (Control)this.sep2, 131072, 16384, 0);
        Widgets.attachToControl((Control)this.box[1], (Control)this.sep1, 128, 0x1000000, 0);
        this.box[2] = new Text((Composite)this, 0x20004 | style & NO_BORDER_MASK);
        this.box[2].setTextLimit(3);
        this.box[2].setBackground(this.background);
        new Widgets.IntegerTextEntryHandler(this.box[2], false, 3){

            @Override
            public void applyValue(long value) {
                IPAddressBox.this.clamp(IPAddressBox.this.box[2], value);
            }
        };
        Widgets.attachToControl((Control)this.box[2], (Control)this.sep2, 16384, 131072, 0);
        Widgets.attachToControl((Control)this.box[2], (Control)this.sep3, 131072, 16384, 0);
        Widgets.attachToControl((Control)this.box[2], (Control)this.sep1, 128, 0x1000000, 0);
        this.box[3] = new Text((Composite)this, 0x20004 | style & NO_BORDER_MASK);
        this.box[3].setTextLimit(3);
        this.box[3].setBackground(this.background);
        new Widgets.IntegerTextEntryHandler(this.box[3], false, 3){

            @Override
            public void applyValue(long value) {
                IPAddressBox.this.clamp(IPAddressBox.this.box[3], value);
            }
        };
        Widgets.attachToParent((Control)this.box[3], 131072, 100, 0);
        Widgets.attachToControl((Control)this.box[3], (Control)this.sep3, 16384, 131072, 0);
        Widgets.attachToControl((Control)this.box[3], (Control)this.sep1, 128, 0x1000000, 0);
    }

    public IPAddressBox(Composite parent, boolean useDash, int style) {
        this(parent, style, useDash ? DASH_SEPARATOR : PERIOD_SEPARATOR);
    }

    public IPAddressBox(Composite parent, boolean useDash) {
        this(parent, useDash, 2048);
    }

    private void clamp(Text txt, long value) {
        if (value < 0L) {
            txt.setText(Integer.toString(0));
        }
        if (value > 255L) {
            txt.setText(Integer.toString(255));
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.setBackground(color);
            ++n2;
        }
        this.background = color;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.setForeground(color);
            ++n2;
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public int getIntValue() {
        String txt0 = this.box[0].getText();
        String txt1 = this.box[1].getText();
        String txt2 = this.box[2].getText();
        String txt3 = this.box[3].getText();
        int a = txt0.equals("") ? 0 : Integer.parseInt(txt0) & 0xFF;
        int b = txt1.equals("") ? 0 : Integer.parseInt(txt1) & 0xFF;
        int c = txt2.equals("") ? 0 : Integer.parseInt(txt2) & 0xFF;
        int d = txt3.equals("") ? 0 : Integer.parseInt(txt3) & 0xFF;
        return a << 24 | b << 16 | c << 8 | d;
    }

    public void setTextValue(String txt) {
        String[] bytes = txt.split("\\.|-");
        if (bytes.length != 4) {
            throw new IllegalArgumentException("Invalid IP Address format: " + txt);
        }
        String[] stringArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            String bytestring = stringArray[n2];
            int value = Integer.parseInt(bytestring);
            if (value < 0 || value > 255) {
                throw new IllegalArgumentException("Invalid IP Address format: " + txt);
            }
            ++n2;
        }
        this.box[0].setText(bytes[0]);
        this.box[1].setText(bytes[1]);
        this.box[2].setText(bytes[2]);
        this.box[3].setText(bytes[3]);
    }

    public void setIntValue(int value) {
        int a = (value & 0xFF000000) >>> 24;
        int b = (value & 0xFF0000) >> 16;
        int c = (value & 0xFF00) >> 8;
        int d = value & 0xFF;
        this.box[0].setText(Integer.toString(a));
        this.box[1].setText(Integer.toString(b));
        this.box[2].setText(Integer.toString(c));
        this.box[3].setText(Integer.toString(d));
    }

    public void setByAdress(InetAddress address) {
        this.setIntValue(IPAddressBox.getInetAddressToInt(address));
    }

    public static byte[] getByteArray(int value) {
        int a = (value & 0xFF000000) >>> 24;
        int b = (value & 0xFF0000) >> 16;
        int c = (value & 0xFF00) >> 8;
        int d = value & 0xFF;
        return new byte[]{(byte)a, (byte)b, (byte)c, (byte)d};
    }

    public static int getInetAddressToInt(InetAddress address) {
        byte[] bytes = address.getAddress();
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static String toString(int value) {
        int a = (value & 0xFF000000) >>> 24;
        int b = (value & 0xFF0000) >> 16;
        int c = (value & 0xFF00) >> 8;
        int d = value & 0xFF;
        return String.format("%03d.%03d.%03d.%03d", a, b, c, d);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.box[0].setEnabled(enabled);
        this.box[1].setEnabled(enabled);
        this.box[2].setEnabled(enabled);
        this.box[3].setEnabled(enabled);
        this.sep1.setEnabled(enabled);
        this.sep2.setEnabled(enabled);
        this.sep3.setEnabled(enabled);
    }
}

