/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.OverlayImage;
import org.eclipse.osee.framework.ui.swt.ProgramImage;
import org.eclipse.osee.framework.ui.swt.internal.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ImageManager {
    public static final KeyedImage MISSING = new DefaultImage();

    private static ImageRegistry getImageRegistry() {
        return Activator.getInstance().getImageRegistry();
    }

    private static synchronized void storeOnImageRegistry(String key, ImageDescriptor descriptor) {
        ImageManager.getImageRegistry().put(key, descriptor);
    }

    public static synchronized Image getImage(String imageKey) {
        return ImageManager.getImageRegistry().get(imageKey);
    }

    public static synchronized ImageDescriptor getImageDescriptor(String imageKey) {
        return ImageManager.getImageRegistry().getDescriptor(imageKey);
    }

    public static synchronized void removeFromRegistry(String imageKey) {
        ImageManager.getImageRegistry().remove(imageKey);
    }

    public static synchronized Image getProgramImage(String extension) {
        if (ImageManager.isInTest()) {
            return ImageManager.getImage(MISSING);
        }
        return ImageManager.getImage(new ProgramImage(extension));
    }

    public static synchronized ImageDescriptor getProgramImageDescriptor(String extension) {
        if (ImageManager.isInTest()) {
            return ImageManager.getImageDescriptor(MISSING);
        }
        return ImageManager.getImageDescriptor(new ProgramImage(extension));
    }

    public static synchronized Optional<ImageDescriptor> safeGetProgramImageDescriptor(String extension) {
        try {
            return Optional.ofNullable(ImageManager.getImageDescriptor(new ProgramImage(extension)));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static boolean isInTest() {
        return Boolean.valueOf(System.getProperty("osee.isInTest"));
    }

    public static synchronized Image getImage(KeyedImage imageEnum) {
        return ImageManager.getImage(ImageManager.setupImage(imageEnum));
    }

    public static synchronized Image getImage(OseeImage oseeImage) {
        return ImageManager.getImage(ImageManager.setupImage(ImageManager.create(oseeImage)));
    }

    public static synchronized ImageDescriptor getImageDescriptor(KeyedImage imageEnum) {
        return ImageManager.getImageDescriptor(ImageManager.setupImage(imageEnum));
    }

    public static synchronized ImageDescriptor getImageDescriptor(OseeImage oseeImage) {
        return ImageManager.getImageDescriptor(ImageManager.setupImage(ImageManager.create(oseeImage)));
    }

    public static synchronized String setupImage(KeyedImage imageEnum) {
        String imageKey;
        String string = imageKey = imageEnum != null ? imageEnum.getImageKey() : MISSING.getImageKey();
        if (ImageManager.getImageRegistry().getDescriptor(imageKey) == null && imageEnum != null) {
            ImageDescriptor imageDescriptor = imageEnum.createImageDescriptor();
            if (imageDescriptor == null) {
                if (!imageKey.contains("nothere.gif") && !(imageEnum instanceof ProgramImage)) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Unable to load the image for [%s]", (Object[])new Object[]{imageEnum.getImageKey()});
                }
                return ImageManager.setupImage(MISSING);
            }
            ImageManager.storeOnImageRegistry(imageKey, imageDescriptor);
        }
        return imageKey;
    }

    public static synchronized KeyedImage setupImageWithOverlay(KeyedImage baseImageEnum, KeyedImage overlay, OverlayImage.Location location) {
        String baseImageName = ImageManager.setupImage(baseImageEnum);
        String overlayImageKey = String.valueOf(baseImageName) + "_" + overlay.getImageKey();
        Object overlayImageDescriptor = ImageManager.getImageDescriptor(overlayImageKey);
        if (overlayImageDescriptor == null) {
            Image baseImage = ImageManager.getImage(baseImageName);
            overlayImageDescriptor = new OverlayImage(baseImage, ImageManager.getImageDescriptor(ImageManager.setupImage(overlay)), location);
            ImageManager.storeOnImageRegistry(overlayImageKey, overlayImageDescriptor);
        }
        return new KeyedImagePair(overlayImageKey, (ImageDescriptor)overlayImageDescriptor);
    }

    public static ImageDescriptor createImageDescriptor(String symbolicBundleName, String imageFileName) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)symbolicBundleName, (String)("OSEE-INF/images/" + imageFileName));
    }

    public static KeyedImage createKeyedImage(String imageKey, ImageDescriptor descriptor) {
        return new KeyedImagePair(imageKey, descriptor);
    }

    public static KeyedImage create(final OseeImage oseeImage) {
        return new KeyedImage(){

            @Override
            public String getImageKey() {
                return oseeImage.name();
            }

            @Override
            public ImageDescriptor createImageDescriptor() {
                return ImageManager.createImageDescriptor(oseeImage.getPluginId(), oseeImage.name());
            }
        };
    }

    private static final class DefaultImage
    implements KeyedImage {
        private DefaultImage() {
        }

        @Override
        public ImageDescriptor createImageDescriptor() {
            return ImageDescriptor.getMissingImageDescriptor();
        }

        @Override
        public String getImageKey() {
            return "org.eclipse.osee.framework.ui.swt.missing";
        }
    }

    private static final class KeyedImagePair
    implements KeyedImage {
        private final ImageDescriptor descriptor;
        private final String imageKey;

        public KeyedImagePair(String imageKey, ImageDescriptor descriptor) {
            this.descriptor = descriptor;
            this.imageKey = imageKey;
        }

        @Override
        public ImageDescriptor createImageDescriptor() {
            return this.descriptor;
        }

        @Override
        public String getImageKey() {
            return this.imageKey;
        }
    }
}

