/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.jdk.core.type.ScalarOrVector;

public abstract class AbstractScalarOrVector<T, I extends Collection<T>, C extends I>
implements ScalarOrVector<T, I, C> {
    private Object store;
    private StoreType storeType;

    protected AbstractScalarOrVector() {
        this.storeType = StoreType.EMPTY;
        this.store = null;
    }

    protected AbstractScalarOrVector(C vectorValue) {
        this.validateCollection((Collection<?>)vectorValue);
        if (!vectorValue.isEmpty()) {
            this.storeType = StoreType.VECTOR;
            this.store = vectorValue;
        } else {
            this.storeType = StoreType.EMPTY;
            this.store = null;
        }
    }

    protected AbstractScalarOrVector(T scalarValue) {
        if (Objects.nonNull(scalarValue)) {
            this.storeType = StoreType.SCALAR;
            this.store = scalarValue;
        } else {
            this.storeType = StoreType.EMPTY;
            this.store = null;
        }
    }

    @Override
    public abstract boolean add(T var1);

    @Override
    public abstract boolean addAll(Collection<? extends T> var1);

    protected boolean addAll(Collection<? extends T> vectorValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
        this.validateCollection(vectorValue);
        Objects.requireNonNull(vectorCollectionSupplier);
        return this.storeType.addVector(this, vectorValue, vectorCollectionSupplier);
    }

    @Override
    public abstract boolean addAll(ScalarOrVector<T, I, C> var1);

    protected boolean addAll(ScalarOrVector<T, I, C> other, VectorCollectionSupplier<C> vectorCollectionSupplier) {
        this.validateCollection(other);
        Objects.requireNonNull(vectorCollectionSupplier);
        switch (other.rank()) {
            case EMPTY: {
                return false;
            }
            case SCALAR: {
                T otherScalar = other.getScalar().orElseThrow(NullPointerException::new);
                return this.storeType.addScalar(this, otherScalar, vectorCollectionSupplier);
            }
            case VECTOR: {
                return this.storeType.addVector(this, other, vectorCollectionSupplier);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void addAllUnsafe(C vectorValue) {
        this.validateCollection((Collection<?>)vectorValue);
        this.storeType.addForeignVector(this, (Collection)Objects.requireNonNull(vectorValue));
    }

    @Override
    public abstract void addAllUnsafe(ScalarOrVector<T, I, C> var1);

    protected void addAllUnsafe(ScalarOrVector<T, I, C> other, VectorCollectionSupplier<C> vectorCollectionSupplier) {
        this.validateCollection(other);
        Objects.requireNonNull(vectorCollectionSupplier);
        if (!(other instanceof AbstractScalarOrVector)) {
            throw new IllegalArgumentException();
        }
        AbstractScalarOrVector otherAbstractScalarOrVector = (AbstractScalarOrVector)other;
        switch (otherAbstractScalarOrVector.storeType) {
            case EMPTY: {
                return;
            }
            case SCALAR: {
                this.storeType.addScalar(this, otherAbstractScalarOrVector.getStoreScalar(), vectorCollectionSupplier);
                return;
            }
            case VECTOR: {
                this.storeType.addForeignVector(this, otherAbstractScalarOrVector.getStoreVector());
                return;
            }
        }
        throw new IllegalStateException();
    }

    protected boolean addScalarAllowDuplicates(T scalarValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
        Objects.requireNonNull(scalarValue);
        Objects.requireNonNull(vectorCollectionSupplier);
        return this.storeType.addScalar(this, scalarValue, vectorCollectionSupplier);
    }

    protected boolean addScalarNoDuplicates(T scalarValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
        Objects.requireNonNull(scalarValue);
        Objects.requireNonNull(vectorCollectionSupplier);
        if (this.storeType.isScalar() && this.store.equals(scalarValue)) {
            return false;
        }
        return this.storeType.addScalar(this, scalarValue, vectorCollectionSupplier);
    }

    @Override
    public void clear() {
        this.storeType.clear(this);
    }

    @Override
    public boolean contains(Object o) {
        return this.storeType.contains(this, o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.validateCollection(c);
        return this.storeType.containsAll(this, c);
    }

    @Override
    public abstract I get();

    @Override
    public Optional<T> getScalar() {
        return this.storeType.getScalar(this);
    }

    private T getStoreScalar() {
        assert (this.storeType.isScalar());
        Object scalar = this.store;
        return (T)scalar;
    }

    private C getStoreVector() {
        assert (this.storeType.isVector());
        Collection vector = (Collection)this.store;
        return (C)vector;
    }

    @Override
    public boolean isEmpty() {
        return this.storeType.isEmpty(this);
    }

    @Override
    public boolean isNotEmpty() {
        return !this.storeType.isEmpty(this);
    }

    @Override
    public boolean isScalar() {
        return this.storeType.isScalar(this);
    }

    @Override
    public boolean isVector() {
        return this.storeType.isVector(this);
    }

    @Override
    public Iterator<T> iterator() {
        return this.storeType.iterator(this);
    }

    @Override
    public ScalarOrVector.Rank rank() {
        return this.storeType.rank(this);
    }

    @Override
    public boolean remove(Object scalarValue) {
        Objects.requireNonNull(scalarValue);
        return this.storeType.removeScalar(this, scalarValue);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.validateCollection(c);
        return this.storeType.removeAll(this, c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.validateCollection(c);
        return this.storeType.retainAll(this, c);
    }

    @Override
    public int size() {
        return this.storeType.size(this);
    }

    @Override
    public Object[] toArray() {
        return this.storeType.toArray(this);
    }

    @Override
    public <E> E[] toArray(E[] a) {
        Objects.requireNonNull(a);
        return this.storeType.toArray(this, a);
    }

    @Override
    public void trim() {
        this.storeType.trim(this);
    }

    private void validateCollection(Collection<?> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return;
        }
        boolean collectionIsOk = true;
        try {
            if (c.contains(null)) {
                collectionIsOk = false;
            }
        }
        catch (NullPointerException nullPointerException) {}
        if (!collectionIsOk) {
            throw new NullPointerException();
        }
    }

    protected static enum StoreType {
        EMPTY{

            @Override
            <T, I extends Collection<T>, C extends I> boolean addForeignVector(AbstractScalarOrVector<T, I, C> store, C vectorValue) {
                store.storeType = VECTOR;
                store.store = vectorValue;
                return !vectorValue.isEmpty();
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean addScalar(AbstractScalarOrVector<T, I, C> store, T scalarValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
                store.storeType = SCALAR;
                store.store = scalarValue;
                return true;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean addVector(AbstractScalarOrVector<T, I, C> store, Collection<? extends T> vectorValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
                Collection collection = (Collection)vectorCollectionSupplier.get();
                store.storeType = VECTOR;
                collection.addAll(vectorValue);
                store.store = collection;
                return true;
            }

            @Override
            <T, I extends Collection<T>, C extends I> void clear(AbstractScalarOrVector<T, I, C> store) {
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean contains(AbstractScalarOrVector<T, I, C> store, Object o) {
                Objects.requireNonNull(o);
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean containsAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                return Objects.requireNonNull(c).isEmpty();
            }

            @Override
            <T, I extends Collection<T>, C extends I> Optional<T> getScalar(AbstractScalarOrVector<T, I, C> store) {
                return Optional.empty();
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isEmpty(AbstractScalarOrVector<T, I, C> store) {
                return true;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isScalar(AbstractScalarOrVector<T, I, C> store) {
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isVector(AbstractScalarOrVector<T, I, C> store) {
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> Iterator<T> iterator(AbstractScalarOrVector<T, I, C> store) {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public T next() {
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            <T, I extends Collection<T>, C extends I> ScalarOrVector.Rank rank(AbstractScalarOrVector<T, I, C> store) {
                return ScalarOrVector.Rank.EMPTY;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean removeAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean removeScalar(AbstractScalarOrVector<T, I, C> store, Object scalarValue) {
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean retainAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> int size(AbstractScalarOrVector<T, I, C> store) {
                return 0;
            }

            @Override
            <T, I extends Collection<T>, C extends I> Object[] toArray(AbstractScalarOrVector<T, I, C> store) {
                return new Object[0];
            }

            @Override
            <E, T, I extends Collection<T>, C extends I> E[] toArray(AbstractScalarOrVector<T, I, C> store, E[] a) {
                if (a.length == 0) {
                    return a;
                }
                a[0] = null;
                return a;
            }

            @Override
            <T, I extends Collection<T>, C extends I> void trim(AbstractScalarOrVector<T, I, C> store) {
            }
        }
        ,
        SCALAR{

            @Override
            <T, I extends Collection<T>, C extends I> boolean addForeignVector(AbstractScalarOrVector<T, I, C> store, C vectorValue) {
                int originalSize = vectorValue.size();
                vectorValue.add(store.getStoreScalar());
                store.storeType = VECTOR;
                store.store = vectorValue;
                return vectorValue.size() > originalSize;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean addScalar(AbstractScalarOrVector<T, I, C> store, T scalarValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
                Collection collection = (Collection)Objects.requireNonNull(vectorCollectionSupplier).get();
                store.storeType = VECTOR;
                collection.add(store.getStoreScalar());
                collection.add(scalarValue);
                store.store = collection;
                return collection.size() > 1;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean addVector(AbstractScalarOrVector<T, I, C> store, Collection<? extends T> vectorValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
                Collection collection = (Collection)vectorCollectionSupplier.get();
                T scalar = store.getStoreScalar();
                store.storeType = VECTOR;
                collection.add(scalar);
                collection.addAll(vectorValue);
                store.store = collection;
                return collection.size() > 1;
            }

            @Override
            <T, I extends Collection<T>, C extends I> void clear(AbstractScalarOrVector<T, I, C> store) {
                store.storeType = EMPTY;
                store.store = null;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean contains(AbstractScalarOrVector<T, I, C> store, Object o) {
                T scalar = store.getStoreScalar();
                return scalar.equals(o);
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean containsAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                if (Objects.isNull(c) || c.isEmpty()) {
                    return false;
                }
                T scalar = store.getStoreScalar();
                return c.contains(scalar);
            }

            @Override
            <T, I extends Collection<T>, C extends I> Optional<T> getScalar(AbstractScalarOrVector<T, I, C> store) {
                return Optional.of(store.getStoreScalar());
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isEmpty(AbstractScalarOrVector<T, I, C> store) {
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isScalar(AbstractScalarOrVector<T, I, C> store) {
                return true;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isVector(AbstractScalarOrVector<T, I, C> store) {
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> Iterator<T> iterator(final AbstractScalarOrVector<T, I, C> store) {
                return new Iterator<T>(){
                    boolean done = false;

                    @Override
                    public boolean hasNext() {
                        return this.done;
                    }

                    @Override
                    public T next() {
                        if (this.done) {
                            throw new NoSuchElementException();
                        }
                        this.done = true;
                        return store.getStoreScalar();
                    }
                };
            }

            @Override
            <T, I extends Collection<T>, C extends I> ScalarOrVector.Rank rank(AbstractScalarOrVector<T, I, C> store) {
                return ScalarOrVector.Rank.SCALAR;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean removeAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                if (Objects.nonNull(c) && !c.isEmpty() && c.contains(store.getStoreScalar())) {
                    store.storeType = EMPTY;
                    store.store = null;
                    return true;
                }
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean removeScalar(AbstractScalarOrVector<T, I, C> store, Object scalarValue) {
                if (store.store.equals(scalarValue)) {
                    store.storeType = EMPTY;
                    store.store = null;
                    return true;
                }
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean retainAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                if (Objects.nonNull(c) && !c.isEmpty() && !c.contains(store.getStoreScalar())) {
                    store.storeType = EMPTY;
                    store.store = null;
                    return true;
                }
                return false;
            }

            @Override
            <T, I extends Collection<T>, C extends I> int size(AbstractScalarOrVector<T, I, C> store) {
                return 1;
            }

            @Override
            <T, I extends Collection<T>, C extends I> Object[] toArray(AbstractScalarOrVector<T, I, C> store) {
                return new Object[]{store.getStoreScalar()};
            }

            @Override
            <E, T, I extends Collection<T>, C extends I> E[] toArray(AbstractScalarOrVector<T, I, C> store, E[] a) {
                E[] rv = a.length > 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
                T scalar = store.getStoreScalar();
                rv[0] = scalar;
                if (rv.length == 1) {
                    return rv;
                }
                rv[1] = null;
                return rv;
            }

            @Override
            <T, I extends Collection<T>, C extends I> void trim(AbstractScalarOrVector<T, I, C> store) {
            }
        }
        ,
        VECTOR{

            @Override
            <T, I extends Collection<T>, C extends I> boolean addForeignVector(AbstractScalarOrVector<T, I, C> store, C vectorValue) {
                C collection = store.getStoreVector();
                if (collection.size() >= vectorValue.size()) {
                    return collection.addAll(vectorValue);
                }
                boolean rv = vectorValue.addAll(collection);
                store.store = vectorValue;
                return rv;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean addScalar(AbstractScalarOrVector<T, I, C> store, T scalarValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
                C collection = store.getStoreVector();
                return collection.add(scalarValue);
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean addVector(AbstractScalarOrVector<T, I, C> store, Collection<? extends T> vectorValue, VectorCollectionSupplier<C> vectorCollectionSupplier) {
                C collection = store.getStoreVector();
                return collection.addAll(vectorValue);
            }

            @Override
            <T, I extends Collection<T>, C extends I> void clear(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                collection.clear();
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean contains(AbstractScalarOrVector<T, I, C> store, Object o) {
                if (Objects.isNull(o)) {
                    return false;
                }
                C collection = store.getStoreVector();
                return collection.contains(o);
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean containsAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                C collection = store.getStoreVector();
                return collection.containsAll(c);
            }

            @Override
            <T, I extends Collection<T>, C extends I> Optional<T> getScalar(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                return collection.size() == 1 ? Optional.of(collection.iterator().next()) : Optional.empty();
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isEmpty(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                return collection.isEmpty();
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isScalar(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                return collection.size() == 1;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean isVector(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                return collection.size() > 1;
            }

            @Override
            <T, I extends Collection<T>, C extends I> Iterator<T> iterator(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                return collection.iterator();
            }

            @Override
            <T, I extends Collection<T>, C extends I> ScalarOrVector.Rank rank(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                switch (collection.size()) {
                    case 0: {
                        return ScalarOrVector.Rank.EMPTY;
                    }
                    case 1: {
                        return ScalarOrVector.Rank.SCALAR;
                    }
                }
                return ScalarOrVector.Rank.VECTOR;
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean removeAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                C collection = store.getStoreVector();
                return collection.removeAll(c);
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean removeScalar(AbstractScalarOrVector<T, I, C> store, Object scalarValue) {
                C collection = store.getStoreVector();
                return collection.remove(scalarValue);
            }

            @Override
            <T, I extends Collection<T>, C extends I> boolean retainAll(AbstractScalarOrVector<T, I, C> store, Collection<?> c) {
                C collection = store.getStoreVector();
                return collection.retainAll(c);
            }

            @Override
            <T, I extends Collection<T>, C extends I> int size(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                return collection.size();
            }

            @Override
            <T, I extends Collection<T>, C extends I> Object[] toArray(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                return collection.toArray();
            }

            @Override
            <E, T, I extends Collection<T>, C extends I> E[] toArray(AbstractScalarOrVector<T, I, C> store, E[] a) {
                C collection = store.getStoreVector();
                return collection.toArray(a);
            }

            @Override
            <T, I extends Collection<T>, C extends I> void trim(AbstractScalarOrVector<T, I, C> store) {
                C collection = store.getStoreVector();
                if (collection.size() == 0) {
                    store.storeType = EMPTY;
                    store.store = null;
                    return;
                }
                if (collection.size() == 1) {
                    store.storeType = SCALAR;
                    store.store = collection.iterator().next();
                    return;
                }
            }
        };


        abstract <T, I extends Collection<T>, C extends I> boolean addForeignVector(AbstractScalarOrVector<T, I, C> var1, C var2);

        abstract <T, I extends Collection<T>, C extends I> boolean addScalar(AbstractScalarOrVector<T, I, C> var1, T var2, VectorCollectionSupplier<C> var3);

        abstract <T, I extends Collection<T>, C extends I> boolean addVector(AbstractScalarOrVector<T, I, C> var1, Collection<? extends T> var2, VectorCollectionSupplier<C> var3);

        abstract <T, I extends Collection<T>, C extends I> void clear(AbstractScalarOrVector<T, I, C> var1);

        abstract <T, I extends Collection<T>, C extends I> boolean contains(AbstractScalarOrVector<T, I, C> var1, Object var2);

        abstract <T, I extends Collection<T>, C extends I> boolean containsAll(AbstractScalarOrVector<T, I, C> var1, Collection<?> var2);

        abstract <T, I extends Collection<T>, C extends I> Optional<T> getScalar(AbstractScalarOrVector<T, I, C> var1);

        abstract <T, I extends Collection<T>, C extends I> boolean isEmpty(AbstractScalarOrVector<T, I, C> var1);

        boolean isScalar() {
            return SCALAR.equals((Object)this);
        }

        abstract <T, I extends Collection<T>, C extends I> boolean isScalar(AbstractScalarOrVector<T, I, C> var1);

        boolean isVector() {
            return VECTOR.equals((Object)this);
        }

        abstract <T, I extends Collection<T>, C extends I> boolean isVector(AbstractScalarOrVector<T, I, C> var1);

        abstract <T, I extends Collection<T>, C extends I> Iterator<T> iterator(AbstractScalarOrVector<T, I, C> var1);

        abstract <T, I extends Collection<T>, C extends I> ScalarOrVector.Rank rank(AbstractScalarOrVector<T, I, C> var1);

        abstract <T, I extends Collection<T>, C extends I> boolean removeAll(AbstractScalarOrVector<T, I, C> var1, Collection<?> var2);

        abstract <T, I extends Collection<T>, C extends I> boolean removeScalar(AbstractScalarOrVector<T, I, C> var1, Object var2);

        abstract <T, I extends Collection<T>, C extends I> boolean retainAll(AbstractScalarOrVector<T, I, C> var1, Collection<?> var2);

        abstract <T, I extends Collection<T>, C extends I> int size(AbstractScalarOrVector<T, I, C> var1);

        abstract <T, I extends Collection<T>, C extends I> Object[] toArray(AbstractScalarOrVector<T, I, C> var1);

        abstract <E, T, I extends Collection<T>, C extends I> E[] toArray(AbstractScalarOrVector<T, I, C> var1, E[] var2);

        abstract <T, I extends Collection<T>, C extends I> void trim(AbstractScalarOrVector<T, I, C> var1);
    }

    @FunctionalInterface
    protected static interface VectorCollectionSupplier<C> {
        public C get();
    }
}

