/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public final class Result<V, E>
implements ToMessage {
    private static @NonNull Result<?, ?> emptyResult = new Result();
    private final E error;
    private final V value;

    public static <V, E> @NonNull Result<V, E> empty() {
        Result<?, ?> result = emptyResult;
        return result;
    }

    @SafeVarargs
    public static <E> Optional<E> getMergedError(@NonNull ErrorMerger<E> errorMerger, Result<?, E> ... results) {
        if (Objects.isNull(results) || results.length == 0) {
            return Optional.empty();
        }
        Objects.requireNonNull(errorMerger);
        @Nullable E accumulator = null;
        int i = 0;
        while (i < results.length) {
            Result<?, E> result = results[i];
            if (result != null && result.isPresentError()) {
                accumulator = Objects.nonNull(accumulator) ? errorMerger.apply(accumulator, result.getError()) : result.getError();
            }
            ++i;
        }
        if (Objects.isNull(accumulator)) {
            return Optional.empty();
        }
        return Optional.of(accumulator);
    }

    public static <V, E> @NonNull Result<V, E> ofError(@NonNull E error) {
        return new Result<Object, E>(null, Objects.requireNonNull(error));
    }

    public static <V, E> @NonNull Result<V, E> ofError(@NonNull Result<?, E> errorResult) {
        if (!Objects.requireNonNull(errorResult).isPresentError()) {
            throw new IllegalArgumentException();
        }
        Result<?, E> result = errorResult;
        return result;
    }

    public static <V, E> @NonNull Result<V, E> ofErrorNullable(@Nullable E error) {
        return Objects.nonNull(error) ? new Result<Object, E>(null, error) : Result.empty();
    }

    public static <V, E> @NonNull Result<V, E> ofValue(@NonNull Result<V, ?> valueResult) {
        if (!Objects.requireNonNull(valueResult).isPresentValue()) {
            throw new IllegalArgumentException();
        }
        Result<V, ?> result = valueResult;
        return result;
    }

    public static <V, E> @NonNull Result<V, E> ofValue(@NonNull V value) {
        return new Result<V, Object>(Objects.requireNonNull(value), null);
    }

    public static <V, E> @NonNull Result<V, E> ofValueNullable(@Nullable V value) {
        return Objects.nonNull(value) ? new Result<V, Object>(value, null) : Result.empty();
    }

    @SafeVarargs
    public static <E, T extends Throwable> void throwIfError(@NonNull ErrorMerger<E> errorMerger, @NonNull ErrorToThrowableMapper<E, T> errorToThrowableMapper, Result<?, E> ... results) throws Throwable {
        if (Objects.isNull(results) || results.length == 0) {
            return;
        }
        Objects.requireNonNull(errorMerger);
        Object accumulator = null;
        int i = 0;
        while (i < results.length) {
            Result<?, E> result = results[i];
            if (result != null && result.isPresentError()) {
                accumulator = Objects.nonNull(accumulator) ? errorMerger.apply(accumulator, result.getError()) : result.getError();
            }
            ++i;
        }
        if (Objects.isNull(accumulator)) {
            return;
        }
        throw Objects.requireNonNull(errorToThrowableMapper).apply(accumulator);
    }

    private Result() {
        this.value = null;
        this.error = null;
    }

    private Result(@Nullable V value, @Nullable E error) {
        if (Objects.nonNull(value) && Objects.nonNull(error)) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.error = error;
    }

    public @NonNull Result<V, E> filterError(@NonNull Predicate<? super E> errorPredicate) {
        return Objects.nonNull(this.error) ? (Objects.requireNonNull(errorPredicate).test(this.error) ? this : Result.empty()) : this;
    }

    public @NonNull Result<V, E> filterError(@NonNull Predicate<? super E> errorPredicate, @NonNull ErrorToValueMapper<? extends V, ? super E> failedPredicateErrorToValueMapper) {
        return Objects.nonNull(this.error) && !Objects.requireNonNull(errorPredicate).test(this.error) ? Result.ofValueNullable(Objects.requireNonNull(failedPredicateErrorToValueMapper).apply(this.error)) : this;
    }

    public @NonNull Result<V, E> filterValue(@NonNull Predicate<? super V> valuePredicate) {
        return Objects.nonNull(this.value) ? (Objects.requireNonNull(valuePredicate).test(this.value) ? this : Result.empty()) : this;
    }

    public @NonNull Result<V, E> filterValue(@NonNull Predicate<? super V> valuePredicate, @NonNull ValueToErrorMapper<? super V, ? extends E> failedPredicateValueToErrorMapper) {
        return Objects.nonNull(this.value) && !Objects.requireNonNull(valuePredicate).test(this.value) ? Result.ofErrorNullable(Objects.requireNonNull(failedPredicateValueToErrorMapper).apply(this.value)) : this;
    }

    public <EM> @NonNull Result<V, EM> flatMapError(@NonNull ErrorToResultMapper<V, E, EM> errorToResultMapper) {
        if (Objects.isNull(this.error)) {
            Result rv = this;
            return rv;
        }
        Result<V, EM> result = Objects.requireNonNull(errorToResultMapper).apply(this.error);
        return result;
    }

    public <EM> @NonNull Result<V, EM> flatMapError(@NonNull ErrorToResultMapper<V, E, EM> errorToResultMapper, @NonNull ThrowableToErrorMapper<E, EM> throwableToErrorMapper) {
        Result<V, EM> result;
        if (Objects.isNull(this.error)) {
            Result rv = this;
            return rv;
        }
        try {
            result = Objects.requireNonNull(errorToResultMapper).apply(this.error);
        }
        catch (Throwable t) {
            result = Result.ofErrorNullable(Objects.requireNonNull(throwableToErrorMapper).apply(this.error, t));
        }
        return result;
    }

    public <VM> @NonNull Result<VM, E> flatMapOptionalValue(@NonNull ValueToOptionalMapper<V, VM> valueToOptionalMapper) {
        if (Objects.isNull(this.value)) {
            Result rv = this;
            return rv;
        }
        Result<V, E> result = Objects.requireNonNull(valueToOptionalMapper).apply(this.value).map(value -> Result.ofValue(value)).orElse(Result.empty());
        return result;
    }

    public <VM> @NonNull Result<VM, E> flatMapOptionalValue(@NonNull ValueToOptionalMapper<V, VM> valueToOptionalMapper, @NonNull ThrowableToErrorMapper<V, E> throwableToErrorMapper) {
        if (Objects.isNull(this.value)) {
            Result rv = this;
            return rv;
        }
        try {
            Result<V, E> result = Objects.requireNonNull(valueToOptionalMapper).apply(this.value).map(value -> Result.ofValue(value)).orElse(Result.empty());
            return result;
        }
        catch (Exception e) {
            @Nullable E error = throwableToErrorMapper.apply(this.value, e);
            return Result.ofErrorNullable(error);
        }
    }

    public <VM> @NonNull Result<VM, E> flatMapValue(@NonNull ValueToResultMapper<V, VM, E> valueToResultMapper) {
        if (Objects.isNull(this.value)) {
            Result rv = this;
            return rv;
        }
        Result<VM, E> result = Objects.requireNonNull(valueToResultMapper).apply(this.value);
        return result;
    }

    public <VM> @NonNull Result<VM, E> flatMapValue(@NonNull ValueToResultMapper<V, VM, E> valueToResultMapper, @NonNull ThrowableToErrorMapper<V, E> throwableToErrorMapper) {
        if (Objects.isNull(this.value)) {
            Result rv = this;
            return rv;
        }
        try {
            Result<VM, E> result = Objects.requireNonNull(valueToResultMapper).apply(this.value);
            return result;
        }
        catch (Exception e) {
            Result<V, E> result = Result.ofErrorNullable(Objects.requireNonNull(throwableToErrorMapper).apply(this.value, e));
            return result;
        }
    }

    public <T extends Throwable> Optional<V> getAsOptionalOrElseThrow(@NonNull ErrorToThrowableMapper<E, T> errorToThrowableMapper) throws T {
        if (this.error == null) {
            return Optional.ofNullable(this.value);
        }
        throw Conditions.requireNonNull(errorToThrowableMapper).apply(this.error);
    }

    public @NonNull E getError() {
        if (Objects.nonNull(this.error)) {
            return this.error;
        }
        throw new NoSuchElementException("Result::getError, error not present.");
    }

    public @NonNull V getValue() {
        if (Objects.nonNull(this.value)) {
            return this.value;
        }
        throw new NoSuchElementException("Result::getValue, value not present.");
    }

    public @NonNull Result<V, E> ifEmptyThrow() {
        if (Objects.isNull(this.error) && Objects.isNull(this.value)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public <T extends Throwable> @NonNull Result<V, E> ifEmptyThrow(@NonNull ThrowableSupplier<T> throwableSupplier) throws T {
        if (Objects.isNull(this.error) && Objects.isNull(this.value)) {
            throw Objects.requireNonNull(throwableSupplier).get();
        }
        return this;
    }

    public void ifErrorAction(@NonNull ErrorAction<E> errorAction) {
        if (Objects.nonNull(this.error)) {
            Objects.requireNonNull(errorAction).accept(this.error);
        }
    }

    public void ifErrorActionElseAction(@NonNull ErrorAction<E> errorAction, @NonNull Runnable errorNotPresentAction) {
        if (Objects.nonNull(this.error)) {
            Objects.requireNonNull(errorAction).accept(this.error);
        } else {
            Objects.requireNonNull(errorNotPresentAction).run();
        }
    }

    public @NonNull Result<V, E> ifErrorThrow() {
        if (Objects.nonNull(this.error)) {
            throw new NoSuchElementException(this.error.toString());
        }
        return this;
    }

    public <T extends Throwable> @NonNull Result<V, E> ifErrorThrow(@NonNull ErrorToThrowableMapper<E, T> errorToThrowableMapper) throws T {
        if (Objects.nonNull(this.error)) {
            throw Objects.requireNonNull(errorToThrowableMapper).apply(this.error);
        }
        return this;
    }

    public void ifValueAction(@NonNull ValueAction<V> valueAction) {
        if (Objects.nonNull(this.value)) {
            Objects.requireNonNull(valueAction).accept(this.value);
        }
    }

    public void ifValueActionElseAction(@NonNull ValueAction<V> valueAction, @NonNull Runnable valueNotPresentAction) {
        if (Objects.nonNull(this.value)) {
            Objects.requireNonNull(valueAction).accept(this.value);
        } else {
            Objects.requireNonNull(valueNotPresentAction).run();
        }
    }

    public <T extends Throwable> void ifValueActionElseThrow(@NonNull ValueAction<V> valueAction, @NonNull ErrorToThrowableMapper<E, T> errorToThrowableMapper) throws T {
        if (Objects.nonNull(this.value)) {
            Objects.requireNonNull(valueAction).accept(this.value);
            return;
        }
        if (Objects.nonNull(this.error)) {
            throw Objects.requireNonNull(errorToThrowableMapper).apply(this.error);
        }
        throw new NoSuchElementException();
    }

    public <T extends Throwable> void ifValueActionElseThrow(@NonNull ValueAction<V> valueAction, @NonNull ErrorToThrowableMapper<E, T> errorToThrowableMapper, @NonNull ThrowableSupplier<T> throwableSupplier) throws T {
        if (Objects.nonNull(this.value)) {
            Objects.requireNonNull(valueAction).accept(this.value);
            return;
        }
        if (Objects.nonNull(this.error)) {
            throw Objects.requireNonNull(errorToThrowableMapper).apply(this.error);
        }
        throw Objects.requireNonNull(throwableSupplier).get();
    }

    public void ifValueActionIfErrorActionElseAction(@NonNull ValueAction<V> valueAction, @NonNull ErrorAction<E> errorAction, @NonNull Runnable emptyAction) {
        if (Objects.nonNull(this.value)) {
            Objects.requireNonNull(valueAction).accept(this.value);
            return;
        }
        if (Objects.nonNull(this.error)) {
            Objects.requireNonNull(errorAction).accept(this.error);
        }
        emptyAction.run();
    }

    public <T extends Throwable> void ifValueActionIfErrorThrowElseAction(@NonNull ValueAction<V> valueAction, @NonNull ErrorToThrowableMapper<E, T> errorToThrowableMapper, @NonNull Runnable emptyAction) throws T {
        if (Objects.nonNull(this.value)) {
            Objects.requireNonNull(valueAction).accept(this.value);
            return;
        }
        if (Objects.nonNull(this.error)) {
            throw Objects.requireNonNull(errorToThrowableMapper).apply(this.error);
        }
        emptyAction.run();
    }

    public boolean isEmpty() {
        return Objects.isNull(this.value);
    }

    public boolean isPresentError() {
        return Objects.nonNull(this.error);
    }

    public boolean isPresentValue() {
        return Objects.nonNull(this.value);
    }

    public <EM> @NonNull Result<V, EM> mapError(@NonNull ErrorMapper<E, EM> errorMapper) {
        if (Objects.isNull(this.error)) {
            Result rv = this;
            return rv;
        }
        return Result.ofErrorNullable(Objects.requireNonNull(errorMapper).apply(this.error));
    }

    public <VM> @NonNull Result<VM, E> mapError(@NonNull ErrorToValueMapper<VM, E> errorToValueMapper) {
        if (Objects.isNull(this.error)) {
            Result rv = this;
            return rv;
        }
        return Result.ofValueNullable(Objects.requireNonNull(errorToValueMapper).apply(this.error));
    }

    public <VM> @NonNull Result<VM, E> mapValue(@NonNull ValueMapper<V, VM> valueMapper) {
        if (Objects.isNull(this.value)) {
            Result rv = this;
            return rv;
        }
        return Result.ofValueNullable(Objects.requireNonNull(valueMapper).apply(this.value));
    }

    public <VM> @NonNull Result<VM, E> mapValue(@NonNull ValueMapper<V, VM> valueMapper, @NonNull ThrowableToErrorMapper<? super V, ? extends E> throwableToErrorMapper) {
        if (Objects.isNull(this.value)) {
            Result rv = this;
            return rv;
        }
        try {
            return Result.ofValueNullable(Objects.requireNonNull(valueMapper).apply(this.value));
        }
        catch (Exception e) {
            return Result.ofErrorNullable(Objects.requireNonNull(throwableToErrorMapper).apply(this.value, e));
        }
    }

    public <EM> @NonNull Result<V, EM> mapValueToError(@NonNull ValueToErrorMapper<V, EM> valueToErrorMapper) {
        if (Objects.isNull(this.value)) {
            Result rv = this;
            return rv;
        }
        return Result.ofErrorNullable(Objects.requireNonNull(valueToErrorMapper).apply(this.value));
    }

    public @NonNull Result<V, E> or(@NonNull ResultSupplier<V, E> resultSupplier) {
        Result<V, E> result = Objects.nonNull(this.value) ? this : Objects.requireNonNull(resultSupplier).get();
        return result;
    }

    public @Nullable V orElseGet(@NonNull ErrorToResultMapper<V, E, E> errorToResultMapper, @NonNull ValueSupplier<V> valueSupplier) {
        V result = Objects.nonNull(this.value) ? this.value : (Objects.nonNull(this.error) ? Objects.requireNonNull(errorToResultMapper).apply(this.error).orElseGet(valueSupplier) : Objects.requireNonNull(valueSupplier).get());
        return result;
    }

    public @Nullable V orElseGet(@Nullable V otherValue) {
        V result = Objects.nonNull(this.value) ? this.value : otherValue;
        return result;
    }

    public @Nullable V orElseGet(@NonNull ValueSupplier<V> valueSupplier) {
        return Objects.nonNull(this.value) ? this.value : Objects.requireNonNull(valueSupplier).get();
    }

    public @NonNull V orElseThrow() {
        if (Objects.nonNull(this.value)) {
            return this.value;
        }
        if (Objects.nonNull(this.error)) {
            throw new NoSuchElementException(this.error.toString());
        }
        throw new NoSuchElementException();
    }

    public <T extends Throwable> @NonNull V orElseThrow(@NonNull ErrorToThrowableMapper<E, T> errorToThrowableMapper) throws T {
        if (Objects.nonNull(this.value)) {
            return this.value;
        }
        if (Objects.nonNull(this.error)) {
            throw Objects.requireNonNull(errorToThrowableMapper).apply(this.error);
        }
        throw new NoSuchElementException();
    }

    public @NonNull Result<V, E> orWhenEmpty(@NonNull ResultSupplier<V, E> resultSupplier) {
        Result<V, E> result = Objects.nonNull(this.value) || Objects.nonNull(this.error) ? this : Objects.requireNonNull(Objects.requireNonNull(resultSupplier).get());
        return result;
    }

    public @NonNull Result<V, E> orWhenError(@NonNull ResultSupplier<V, E> resultSupplier) {
        Result<V, E> result = Objects.nonNull(this.value) || Objects.isNull(this.error) ? this : Objects.requireNonNull(Objects.requireNonNull(resultSupplier).get());
        return result;
    }

    public @NonNull Result<V, E> peekEmpty(@NonNull Runnable action) {
        if (Objects.isNull(this.value) && Objects.isNull(this.error)) {
            action.run();
        }
        return this;
    }

    public @NonNull Result<V, E> peekError(@NonNull ErrorAction<E> errorAction) {
        if (Objects.nonNull(this.error)) {
            Objects.requireNonNull(errorAction).accept(this.error);
        }
        return this;
    }

    public @NonNull Result<V, E> peekValue(@NonNull ValueAction<V> valueAction) {
        if (Objects.nonNull(this.value)) {
            Objects.requireNonNull(valueAction).accept(this.value);
        }
        return this;
    }

    public boolean reportIfError(@NonNull ErrorAction<E> errorAction) {
        if (Objects.nonNull(this.error)) {
            Objects.requireNonNull(errorAction).accept(this.error);
            return true;
        }
        return false;
    }

    @Override
    public @NonNull Message toMessage(int indent, @Nullable Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title("Result").indentInc();
        if (this.value instanceof ToMessage) {
            outMessage.title("Value").indentInc().toMessage((ToMessage)this.value).indentDec();
        } else {
            outMessage.segment("Value", this.value);
        }
        if (this.error instanceof ToMessage) {
            outMessage.title("Error").indentInc().toMessage((ToMessage)this.error).indentDec();
        } else {
            outMessage.segment("Error", this.error);
        }
        outMessage.indentDec();
        return outMessage;
    }

    public @NonNull String toString() {
        return Conditions.requireNonNull(this.toMessage(0, null).toString());
    }

    @FunctionalInterface
    public static interface ErrorAction<E> {
        public void accept(@NonNull E var1);
    }

    @FunctionalInterface
    public static interface ErrorMapper<E, EM> {
        public @Nullable EM apply(@NonNull E var1);
    }

    @FunctionalInterface
    public static interface ErrorMerger<E> {
        public @NonNull E apply(@NonNull E var1, @NonNull E var2);
    }

    @FunctionalInterface
    public static interface ErrorToResultMapper<V, E, EM> {
        public @NonNull Result<V, EM> apply(@NonNull E var1);
    }

    @FunctionalInterface
    public static interface ErrorToThrowableMapper<E, T extends Throwable> {
        public @NonNull T apply(@NonNull E var1);

        public static <E extends T, T extends Throwable> ErrorToThrowableMapper<E, T> identity() {
            return new ErrorToThrowableMapper<E, T>(){

                @Override
                public @NonNull T apply(@NonNull E errorObject) {
                    return errorObject;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ErrorToValueMapper<V, E> {
        public V apply(@NonNull E var1);
    }

    @FunctionalInterface
    public static interface ResultSupplier<V, E> {
        public @NonNull Result<V, E> get();
    }

    @FunctionalInterface
    public static interface ThrowableSupplier<T extends Throwable> {
        public @NonNull T get();
    }

    @FunctionalInterface
    public static interface ThrowableToErrorMapper<V, E> {
        default public <E2> ThrowableToErrorMapper<V, E2> andThen(Function<? super E, ? extends E2> after) {
            Objects.requireNonNull(after);
            return (v, t) -> after.apply((E)this.apply(v, t));
        }

        public @Nullable E apply(@NonNull V var1, @NonNull Throwable var2);
    }

    @FunctionalInterface
    public static interface ValueAction<V> {
        public void accept(@NonNull V var1);
    }

    @FunctionalInterface
    public static interface ValueMapper<V, VM> {
        public @Nullable VM apply(@NonNull V var1);
    }

    @FunctionalInterface
    public static interface ValueSupplier<V> {
        public @Nullable V get();
    }

    @FunctionalInterface
    public static interface ValueToErrorMapper<V, E> {
        public @Nullable E apply(@NonNull V var1);
    }

    @FunctionalInterface
    public static interface ValueToOptionalMapper<V, VM> {
        public @NonNull Optional<VM> apply(@NonNull V var1);
    }

    @FunctionalInterface
    public static interface ValueToResultMapper<V, VM, E> {
        public @NonNull Result<VM, E> apply(@NonNull V var1);
    }
}

