/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.osee.framework.jdk.core.util.MapCollection;

public class AbstractMapCollection<K, V, C extends Collection<V>>
implements MapCollection<K, V, C> {
    protected final Supplier<C> collectionSupplier;
    protected final Map<K, C> mapCollection;

    public AbstractMapCollection(Map<K, C> mapCollection) {
        this.collectionSupplier = null;
        this.mapCollection = mapCollection;
    }

    public AbstractMapCollection(Supplier<Map<K, C>> mapCollectionSupplier, Supplier<C> collectionSupplier) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.mapCollection = Objects.requireNonNull(Objects.requireNonNull(mapCollectionSupplier)).get();
    }

    @Override
    public void clear() {
        this.mapCollection.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mapCollection.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapCollection.containsValue(value);
    }

    @Override
    public boolean containsValueInAnyCollection(Object value) {
        for (Collection collection : this.mapCollection.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, C>> entrySet() {
        return this.mapCollection.entrySet();
    }

    @Override
    public void forEachEntry(Consumer<Map.Entry<K, V>> action) {
        this.mapCollection.forEach((key, collection) -> collection.forEach((? super T value) -> action.accept(Map.entry(key, value))));
    }

    @Override
    public void forEachEntry(K key, Consumer<Map.Entry<K, V>> action) {
        Collection collection = (Collection)this.mapCollection.get(key);
        if (Objects.isNull(collection)) {
            return;
        }
        collection.forEach((? super T value) -> action.accept(Map.entry(key, value)));
    }

    @Override
    public void forEachValue(BiConsumer<K, V> action) {
        this.mapCollection.forEach((key, collection) -> collection.forEach((? super T value) -> action.accept(key, value)));
    }

    @Override
    public void forEachValue(K key, Consumer<V> action) {
        Collection collection = (Collection)this.mapCollection.get(key);
        if (Objects.isNull(collection)) {
            return;
        }
        collection.forEach(action::accept);
    }

    @Override
    public C get(Object key) {
        return (C)((Collection)this.mapCollection.get(key));
    }

    @Override
    public Optional<C> getOptional(K key) {
        return Optional.ofNullable((Collection)this.mapCollection.get(key));
    }

    @Override
    public boolean isEmpty() {
        return this.mapCollection.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.mapCollection.keySet();
    }

    @Override
    public C put(K key, C value) {
        return (C)((Collection)this.mapCollection.put(key, value));
    }

    @Override
    public C putAll(K key, C values) {
        Collection collection = (Collection)this.mapCollection.get(key);
        if (Objects.isNull(collection)) {
            collection = (Collection)this.collectionSupplier.get();
            this.mapCollection.put(key, collection);
        }
        collection.addAll(values);
        return (C)collection;
    }

    @Override
    public void putAll(Map<? extends K, ? extends C> m) {
        this.mapCollection.putAll(m);
    }

    @Override
    public C putEntry(Map.Entry<K, V> entry) {
        return this.putValue(entry.getKey(), entry.getValue());
    }

    @Override
    public C putValue(K key, V value) {
        Collection collection = (Collection)this.mapCollection.get(key);
        if (Objects.isNull(collection)) {
            collection = (Collection)this.collectionSupplier.get();
            this.mapCollection.put(key, collection);
        }
        collection.add(value);
        return (C)collection;
    }

    @Override
    public C remove(Object key) {
        return (C)((Collection)this.mapCollection.remove(key));
    }

    @Override
    public boolean removeEntry(Map.Entry<K, V> entry) {
        return Objects.nonNull(entry) ? this.removeValue(entry.getKey(), entry.getValue()) : false;
    }

    @Override
    public boolean removeValue(K key, V value) {
        Collection collection = (Collection)this.mapCollection.get(key);
        if (Objects.nonNull(collection) && collection.remove(value)) {
            if (collection.isEmpty()) {
                this.mapCollection.remove(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.mapCollection.size();
    }

    @Override
    public int size(K key) {
        Collection collection = (Collection)this.mapCollection.get(key);
        int size = Objects.nonNull(collection) ? collection.size() : 0;
        return size;
    }

    @Override
    public int sizeValues() {
        int size = 0;
        for (Collection collection : this.mapCollection.values()) {
            size += collection.size();
        }
        return size;
    }

    @Override
    public Stream<V> stream(K key) {
        Collection collection = (Collection)this.mapCollection.get(key);
        return Objects.nonNull(collection) ? collection.stream() : Stream.empty();
    }

    @Override
    public Stream<Map.Entry<K, V>> streamAllCollectionValuesAsEntries() {
        return this.mapCollection.keySet().stream().flatMap(key -> ((Collection)this.mapCollection.get(key)).stream().map(value -> Map.entry(key, value)));
    }

    @Override
    public Stream<C> streamCollections() {
        return this.mapCollection.values().stream();
    }

    @Override
    public Stream<Map.Entry<K, C>> streamEntries() {
        return this.mapCollection.entrySet().stream();
    }

    @Override
    public Stream<K> streamKeys() {
        return this.mapCollection.keySet().stream();
    }

    @Override
    public Collection<C> values() {
        return this.mapCollection.values();
    }
}

