/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DoubleMap;

public class DoubleEnumMap<Kp extends Enum<Kp>, Ks extends Enum<Ks>, V>
implements DoubleMap<Kp, Ks, V> {
    private final @NonNull EnumMap<Kp, Map<Ks, V>> primaryMap;
    private final @NonNull Class<Ks> enumerationSecondaryKeyClass;

    public DoubleEnumMap(@NonNull Class<Kp> enumerationPrimaryKeyClass, @NonNull Class<Ks> enumerationSecondaryKeyClass) {
        Class<Kp> safeEnumerationPrimaryKeyClass = Conditions.requireNonNull(enumerationPrimaryKeyClass, "enumerationPrimaryKeyClass");
        Class<Ks> safeEnumerationSecondaryKeyClass = Conditions.requireNonNull(enumerationSecondaryKeyClass, "enumerationSecondaryKeyClass");
        this.primaryMap = new EnumMap(safeEnumerationPrimaryKeyClass);
        this.enumerationSecondaryKeyClass = safeEnumerationSecondaryKeyClass;
    }

    @Override
    public void clear() {
        this.primaryMap.clear();
    }

    @Override
    public boolean containsKey(Kp primaryKey) {
        return this.primaryMap.containsKey(primaryKey);
    }

    @Override
    public boolean containsKey(Kp primaryKey, Ks secondaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? secondaryMap.containsKey(secondaryKey) : false;
    }

    @Override
    public Optional<V> get(Kp primaryKey, Ks secondaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.ofNullable(secondaryMap.get(secondaryKey)) : Optional.empty();
    }

    @Override
    public Optional<Map<Ks, V>> get(Kp primaryKey) {
        return Optional.ofNullable(this.primaryMap.get(primaryKey));
    }

    @Override
    public Set<Kp> keySet() {
        return this.primaryMap.keySet();
    }

    @Override
    public Optional<Set<Ks>> keySet(Kp primaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.of(secondaryMap.keySet()) : Optional.empty();
    }

    @Override
    public Optional<V> put(Kp primaryKey, Ks secondaryKey, V value) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        if (secondaryMap == null) {
            secondaryMap = new EnumMap(this.enumerationSecondaryKeyClass);
            this.primaryMap.put(primaryKey, secondaryMap);
            secondaryMap.put(secondaryKey, value);
            return Optional.empty();
        }
        V priorValue = secondaryMap.put(secondaryKey, value);
        return Optional.ofNullable(priorValue);
    }

    @Override
    public Optional<Map<Ks, V>> put(Kp primaryKey, Map<Ks, V> secondaryMap) {
        Map<Ks, V> priorSecondaryMap = this.primaryMap.get(primaryKey);
        this.primaryMap.put(primaryKey, secondaryMap);
        return Optional.ofNullable(priorSecondaryMap);
    }

    @Override
    public int size() {
        return this.primaryMap.values().stream().collect(Collectors.summingInt(Map::size));
    }

    @Override
    public Optional<Integer> size(Kp primaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.of(secondaryMap.size()) : Optional.empty();
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){
            Iterator<Map<Ks, V>> primaryIterator;
            Iterator<V> secondaryIterator;
            {
                this.primaryIterator = DoubleEnumMap.this.primaryMap.values().iterator();
                this.secondaryIterator = this.primaryIterator.hasNext() ? this.primaryIterator.next().values().iterator() : null;
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        if (secondaryIterator == null) {
                            return false;
                        }
                        if (secondaryIterator.hasNext()) {
                            return true;
                        }
                        if (primaryIterator.hasNext()) {
                            secondaryIterator = primaryIterator.next().values().iterator();
                            return this.hasNext();
                        }
                        secondaryIterator = null;
                        return false;
                    }

                    @Override
                    public V next() {
                        if (secondaryIterator == null) {
                            throw new NoSuchElementException();
                        }
                        return secondaryIterator.next();
                    }
                };
            }

            @Override
            public int size() {
                return DoubleEnumMap.this.size();
            }
        };
    }

    @Override
    public Optional<Collection<V>> values(Kp primaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.of(secondaryMap.values()) : Optional.empty();
    }
}

